/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.item;

import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;

public abstract class ItemRendererBase
implements IItemRenderer {
    public final void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderDropped(item, (RenderBlocks)data[0], (EntityItem)data[1]);
                break;
            }
            case EQUIPPED: {
                this.renderEquipped(item, (RenderBlocks)data[0], (EntityLivingBase)data[1]);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderFirstPerson(item, (RenderBlocks)data[0], (EntityLiving)data[1]);
                break;
            }
            case FIRST_PERSON_MAP: {
                this.renderFirstPersonMap(item, (EntityPlayer)data[0], (TextureManager)data[1], (MapData)data[2]);
                break;
            }
            case INVENTORY: {
                this.renderInventory(item, (RenderBlocks)data[0]);
            }
        }
    }

    public abstract boolean handleRenderType(ItemStack var1, IItemRenderer.ItemRenderType var2);

    protected abstract void renderDropped(ItemStack var1, RenderBlocks var2, EntityItem var3);

    protected abstract void renderEquipped(ItemStack var1, RenderBlocks var2, EntityLivingBase var3);

    protected abstract void renderFirstPerson(ItemStack var1, RenderBlocks var2, EntityLiving var3);

    protected abstract void renderInventory(ItemStack var1, RenderBlocks var2);

    protected abstract void renderFirstPersonMap(ItemStack var1, EntityPlayer var2, TextureManager var3, MapData var4);
}

