/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.ranch.BlockRanchBlock;
import com.pixelmonmod.pixelmon.blocks.ranch.TileEntityRanchBlock;
import com.pixelmonmod.pixelmon.tools.Vector3f;
import com.pixelmonmod.pixelmon.util.Bounds;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import org.lwjgl.opengl.GL11;

public class RanchBlockHighlightRender {
    private static ResourceLocation ranchOverlay = new ResourceLocation("pixelmon:textures/blocks/ranchOverlay.png");
    private TileEntityRanchBlock lastBlock;
    private int tick = 0;

    @SubscribeEvent
    public void onHighlight(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            World world = event.player.field_70170_p;
            Block block = world.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
            if (block != null) {
                if (block instanceof BlockRanchBlock) {
                    try {
                        int meta = world.func_72805_g(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
                        MultiBlock mb = (MultiBlock)world.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
                        Vector3f loc = mb.findBaseBlock(world, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, meta);
                        TileEntityRanchBlock rb = (TileEntityRanchBlock)world.func_147438_o((int)loc.x, (int)loc.y, (int)loc.z);
                        if (rb.getOwnerUUID().equals(event.player.func_110124_au()) || rb.getPlayerName().equals(event.player.getDisplayName())) {
                            if (rb == this.lastBlock) {
                                if (this.tick >= 40) {
                                    this.renderBounds(rb, event.player, world, event.partialTicks);
                                } else {
                                    ++this.tick;
                                }
                            } else {
                                this.tick = 0;
                            }
                            this.lastBlock = rb;
                        }
                    }
                    catch (Exception e) {}
                } else {
                    this.tick = 0;
                }
            } else {
                this.tick = 0;
            }
        } else {
            this.tick = 0;
        }
    }

    private void renderBounds(TileEntityRanchBlock te, EntityPlayer player, World world, float partialTicks) {
        Bounds b = te.getBounds();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ranchOverlay);
        for (int x = b.left; x <= b.right; ++x) {
            for (int z = b.bottom; z <= b.top; ++z) {
                if (x == te.field_145851_c && z == te.field_145849_e) continue;
                int y = world.func_72825_h(x, z);
                Block block = world.func_147439_a(x, y, z);
                block.func_149719_a((IBlockAccess)world, x, y, z);
                float f1 = 0.002f;
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                this.drawBlockOverlay(tessellator, block.func_149633_g(world, x, y, z).func_72314_b((double)f1, (double)f1, (double)f1).func_72325_c(-d0, -d1, -d2));
            }
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    private void drawBlockOverlay(Tessellator tessellator, AxisAlignedBB box) {
        tessellator.func_78374_a(box.field_72340_a + 0.15, box.field_72338_b + (double)0.05f, box.field_72334_f - 0.15, 0.0, 1.0);
        tessellator.func_78374_a(box.field_72336_d - 0.15, box.field_72338_b + (double)0.05f, box.field_72334_f - 0.15, 1.0, 1.0);
        tessellator.func_78374_a(box.field_72336_d - 0.15, box.field_72338_b + (double)0.05f, box.field_72339_c + 0.15, 1.0, 0.0);
        tessellator.func_78374_a(box.field_72340_a + 0.15, box.field_72338_b + (double)0.05f, box.field_72339_c + 0.15, 0.0, 0.0);
    }
}

