/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.comm.PixelmonUpdateData;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoves;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;

public class PixelmonData {
    public int[] pokemonID;
    public String name;
    public String nickname;
    public String OT = "";
    public int lvl;
    public int hp;
    public int health;
    public int friendship;
    public Gender gender;
    public boolean isFainted;
    public boolean isEgg;
    public int eggCycles;
    public int steps;
    public String eggDescription = "";
    private int nationalPokedexNumber = -1;
    public boolean selected = false;
    private EnumType type1 = null;
    private EnumType type2 = null;
    public int order;
    public int numMoves;
    public int HP;
    public int Speed;
    public int Attack;
    public int Defence;
    public int SpecialAttack;
    public int SpecialDefence;
    public int nextLvlXP;
    public int boxNumber = 0;
    public boolean isShiny;
    public boolean hasOwner;
    public boolean doesLevel;
    public boolean canHoldAnItem;
    public ItemStack heldItem = null;
    public int xp;
    protected int effectCount = 0;
    public EnumBossMode bossMode;
    public EnumNature nature;
    public EnumGrowth growth;
    public EnumPokeballs pokeball;
    public ArrayList<StatusType> status = new ArrayList();
    public PixelmonMovesetData[] moveset = new PixelmonMovesetData[4];
    public String ability;
    public short specialTexture;
    public boolean isInRanch = false;
    public int targetId = -1;
    private String description;
    public boolean outside;
    public int choiceMove = -1;
    protected boolean resetMoves = true;
    private ExternalMoveBase[] externalMoves;

    public int getNationalPokedexNumber() {
        if (this.nationalPokedexNumber == -1) {
            this.nationalPokedexNumber = Entity3HasStats.getBaseStats((String)this.name).nationalPokedexNumber;
        }
        return this.nationalPokedexNumber;
    }

    public EnumType getType1() {
        if (this.type1 == null) {
            this.type1 = Entity3HasStats.getBaseStats((String)this.name).type1;
        }
        return this.type1;
    }

    public EnumType getType2() {
        if (this.type2 == null) {
            this.type2 = Entity3HasStats.getBaseStats((String)this.name).type2;
        }
        return this.type2;
    }

    public PixelmonData() {
    }

    public PixelmonData(NBTTagCompound p) {
        NBTBase oldtag;
        int i;
        this.pokemonID = PixelmonMethods.getID(p);
        this.name = p.func_74779_i("Name");
        this.nickname = p.func_74779_i("Nickname");
        this.lvl = p.func_74762_e("Level");
        this.nextLvlXP = p.func_74762_e("EXPToNextLevel");
        this.xp = p.func_74762_e("EXP");
        this.hp = p.func_74762_e("StatsHP");
        this.friendship = p.func_74762_e("Friendship");
        this.health = p.func_74765_d("Health");
        this.gender = Gender.getGender(p.func_74765_d("Gender"));
        this.isFainted = p.func_74767_n("IsFainted");
        this.isShiny = p.func_74767_n("IsShiny");
        this.isEgg = p.func_74767_n("isEgg");
        this.eggCycles = p.func_74762_e("eggCycles");
        this.steps = p.func_74762_e("steps");
        this.eggDescription = EntityPixelmon.getEggDescription(this.eggCycles);
        this.canHoldAnItem = !this.isEgg;
        this.nature = EnumNature.getNatureFromIndex(p.func_74765_d("Nature"));
        this.growth = EnumGrowth.getGrowthFromIndex(p.func_74765_d("Growth"));
        this.pokeball = EnumPokeballs.getFromIndex(p.func_74762_e("CaughtBall"));
        this.order = p.func_74762_e("PixelmonOrder");
        this.numMoves = p.func_74762_e("PixelmonNumberMoves");
        try {
            for (i = 0; i < this.numMoves; ++i) {
                this.moveset[i] = PixelmonMovesetData.create(p, i);
            }
        }
        catch (NullPointerException e) {
            this.fixMoveset(p);
            for (int i2 = 0; i2 < this.numMoves; ++i2) {
                this.moveset[i2] = PixelmonMovesetData.create(p, i2);
            }
        }
        this.HP = p.func_74762_e("StatsHP");
        this.Speed = p.func_74762_e("StatsSpeed");
        this.Attack = p.func_74762_e("StatsAttack");
        this.Defence = p.func_74762_e("StatsDefence");
        this.SpecialAttack = p.func_74762_e("StatsSpecialAttack");
        this.SpecialDefence = p.func_74762_e("StatsSpecialDefence");
        if (p.func_74764_b("HeldItem") && this.canHoldAnItem && (oldtag = p.func_74781_a("HeldItem")) instanceof NBTTagInt && p.func_74762_e("HeldItem") != -1) {
            this.heldItem = new ItemStack(Item.func_150899_d((int)p.func_74762_e("HeldItem")), 1);
        }
        if (p.func_74764_b("HeldItemStack") && this.canHoldAnItem) {
            this.heldItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)p.func_74781_a("HeldItemStack")));
        }
        if (p.func_74764_b("BoxNumber")) {
            this.boxNumber = p.func_74762_e("BoxNumber");
        }
        this.hasOwner = true;
        this.doesLevel = p.func_74767_n("DoesLevel");
        this.effectCount = p.func_74765_d("EffectCount");
        for (i = 0; i < this.effectCount; ++i) {
            this.status.add(StatusType.getEffect(p.func_74762_e("Effect" + i)));
        }
        this.bossMode = EnumBossMode.getMode(p.func_74765_d("BossMode"));
        if (p.func_74764_b("originalTrainer")) {
            this.OT = p.func_74779_i("originalTrainer");
        }
        this.ability = p.func_74779_i("Ability");
        this.specialTexture = p.func_74765_d("specialTexture");
        this.isInRanch = p.func_74767_n("isInRanch");
    }

    private void fixMoveset(NBTTagCompound p) {
        for (int i = 0; i < this.numMoves; ++i) {
            Attack a;
            if (p.func_74764_b("PixelmonMoveID" + i) || (a = DatabaseMoves.getAttack(p.func_74779_i("PixelmonMoveName" + i))) != null) continue;
            p.func_82580_o("PixelmonMoveName" + i);
            p.func_82580_o("PixelmonMoveType" + i);
            p.func_82580_o("PixelmonMovePP" + i);
            p.func_82580_o("PixelmonMovePPBase" + i);
            for (int j = i + 1; j < this.numMoves; ++j) {
                int newIndex = j - 1;
                p.func_74778_a("PixelmonMoveName" + newIndex, p.func_74779_i("PixelmonMoveName" + j));
                p.func_74768_a("PixelmonMoveType" + newIndex, p.func_74762_e("PixelmonMoveType" + j));
                p.func_74768_a("PixelmonMovePP" + newIndex, p.func_74762_e("PixelmonMovePP" + j));
                p.func_74768_a("PixelmonMovePPBase" + newIndex, p.func_74762_e("PixelmonMovePPBase" + j));
            }
            --this.numMoves;
        }
    }

    public PixelmonData(EntityPixelmon p) {
        int i;
        this.pokemonID = p.getPokemonId();
        this.name = p.getName();
        this.nickname = p.getNickname();
        this.lvl = p.getLvl().getLevel();
        this.nextLvlXP = p.getLvl().expToNextLevel;
        this.xp = p.getLvl().getExp();
        this.hp = p.stats.HP;
        this.friendship = p.friendship.getFriendship();
        this.health = (int)p.func_110143_aJ();
        this.gender = p.gender;
        this.isFainted = p.isFainted;
        this.isShiny = p.getIsShiny();
        this.isEgg = p.isEgg;
        this.eggCycles = p.eggCycles;
        this.eggDescription = EntityPixelmon.getEggDescription(this.eggCycles);
        this.canHoldAnItem = !this.isEgg;
        this.nature = p.getNature();
        this.growth = p.getGrowth();
        this.pokeball = p.caughtBall;
        if (p.func_70902_q() != null) {
            try {
                this.order = p.getStorage().getPosition(this.pokemonID);
            }
            catch (Exception e) {
                this.order = 0;
            }
        } else {
            this.order = 0;
        }
        if (p.getMoveset().size() == 0) {
            p.loadMoveset();
        }
        this.numMoves = p.getMoveset().size();
        for (i = 0; i < this.numMoves; ++i) {
            this.moveset[i] = PixelmonMovesetData.create(p.getMoveset(), i);
        }
        this.HP = p.stats.HP;
        this.Speed = p.stats.Speed;
        this.Attack = p.stats.Attack;
        this.Defence = p.stats.Defence;
        this.SpecialAttack = p.stats.SpecialAttack;
        this.SpecialDefence = p.stats.SpecialDefence;
        if (p.heldItem != null) {
            this.heldItem = p.heldItem;
        }
        this.hasOwner = p.func_70902_q() != null || p.getTrainer() != null;
        this.doesLevel = p.doesLevel;
        this.effectCount = p.getStatusSize();
        for (i = 0; i < this.effectCount; ++i) {
            this.status.add(p.getStatus((int)i).type);
        }
        this.bossMode = p.getBossMode();
        this.OT = p.originalTrainer;
        this.ability = p.getAbility().getName().replaceAll(" ", "");
        this.specialTexture = p.func_70096_w().func_75693_b(26);
        this.isInRanch = p.isInRanchBlock;
        this.targetId = p.func_70638_az() != null ? p.func_70638_az().func_145782_y() : -1;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = DatabaseStats.getDescription(this.name);
        }
        return this.description;
    }

    public void update(PixelmonUpdateData p) {
        block14: for (EnumUpdateType type : p.updateTypes) {
            switch (type) {
                case HP: {
                    this.hp = p.hp;
                    this.health = p.health;
                    this.isFainted = p.isFainted;
                    continue block14;
                }
                case Stats: {
                    this.lvl = p.lvl;
                    this.nextLvlXP = p.nextLvlXP;
                    this.xp = p.xp;
                    this.HP = p.HP;
                    this.Speed = p.Speed;
                    this.Attack = p.Attack;
                    this.Defence = p.Defence;
                    this.SpecialAttack = p.SpecialAttack;
                    this.SpecialDefence = p.SpecialDefence;
                    continue block14;
                }
                case Nickname: {
                    this.nickname = p.nickname;
                    continue block14;
                }
                case Name: {
                    this.name = p.name;
                    this.nationalPokedexNumber = -1;
                    continue block14;
                }
                case Friendship: {
                    this.friendship = p.friendship;
                    continue block14;
                }
                case Moveset: {
                    this.numMoves = p.numMoves;
                    this.moveset = p.moveset;
                    this.resetMoves = true;
                    continue block14;
                }
                case HeldItem: {
                    this.heldItem = p.heldItem;
                    continue block14;
                }
                case Status: {
                    this.effectCount = p.effectCount;
                    this.status = p.status;
                    continue block14;
                }
                case CanLevel: {
                    this.doesLevel = p.doesLevel;
                    continue block14;
                }
                case Egg: {
                    this.isEgg = p.isEgg;
                    this.eggCycles = p.eggCycles;
                    this.steps = p.steps;
                    this.eggDescription = EntityPixelmon.getEggDescription(this.eggCycles);
                    continue block14;
                }
                case Texture: {
                    this.specialTexture = p.specialTexture;
                    continue block14;
                }
                case Target: {
                    this.targetId = p.targetId;
                    continue block14;
                }
            }
        }
    }

    public void updatePokemon(NBTTagCompound p) {
        p.func_74778_a("Nickname", this.nickname);
        p.func_74768_a("Level", this.lvl);
        p.func_74777_a("Gender", (short)this.gender.ordinal());
        p.func_74757_a("IsFainted", this.isFainted);
        p.func_74757_a("IsShiny", this.isShiny);
        p.func_74777_a("Growth", (short)this.growth.index);
        p.func_74768_a("PixelmonNumberMoves", this.numMoves);
        p.func_74757_a("isEgg", this.isEgg);
        p.func_74768_a("eggCycles", this.eggCycles);
        p.func_74768_a("steps", this.steps);
        for (int i = 0; i < this.numMoves; ++i) {
            this.moveset[i].updatePokemon(p, i);
        }
        p.func_74777_a("BossMode", (short)this.bossMode.index);
    }

    public void encodeInto(ByteBuf data) {
        int i;
        data.writeInt(this.pokemonID[0]);
        data.writeInt(this.pokemonID[1]);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.nickname);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.OT);
        data.writeShort(this.lvl);
        data.writeInt(this.nextLvlXP);
        data.writeShort(this.xp);
        data.writeShort(this.hp);
        data.writeShort(this.friendship);
        data.writeShort(this.health);
        data.writeShort(this.gender.ordinal());
        data.writeBoolean(this.isFainted);
        data.writeBoolean(this.hasOwner);
        data.writeShort(this.order);
        data.writeShort(this.numMoves);
        for (i = 0; i < this.numMoves; ++i) {
            this.moveset[i].writeData(data);
        }
        data.writeShort(this.HP);
        data.writeShort(this.Speed);
        data.writeShort(this.Attack);
        data.writeShort(this.Defence);
        data.writeShort(this.SpecialAttack);
        data.writeShort(this.SpecialDefence);
        data.writeShort(this.boxNumber);
        data.writeBoolean(this.isShiny);
        data.writeShort(this.nature.index);
        data.writeShort(this.growth.index);
        data.writeShort(this.bossMode.index);
        if (this.pokeball != null) {
            data.writeShort(this.pokeball.getIndex());
        } else {
            data.writeShort(0);
        }
        data.writeBoolean(this.doesLevel);
        if (this.heldItem != null) {
            data.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.heldItem);
        } else {
            data.writeBoolean(false);
        }
        data.writeShort(this.effectCount);
        for (i = 0; i < this.effectCount; ++i) {
            data.writeShort(this.status.get(i).ordinal());
        }
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.ability);
        data.writeBoolean(this.isEgg);
        data.writeInt(this.eggCycles);
        data.writeInt(this.steps);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.eggDescription);
        data.writeShort((int)this.specialTexture);
        data.writeBoolean(this.isInRanch);
    }

    public void decodeInto(ByteBuf data) {
        int i;
        this.pokemonID = new int[]{data.readInt(), data.readInt()};
        this.name = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.nickname = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.OT = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.lvl = data.readShort();
        this.nextLvlXP = data.readInt();
        this.xp = data.readShort();
        this.hp = data.readShort();
        this.friendship = data.readShort();
        this.health = data.readShort();
        this.gender = Gender.getGender(data.readShort());
        this.isFainted = data.readBoolean();
        this.hasOwner = data.readBoolean();
        this.order = data.readShort();
        this.numMoves = data.readShort();
        for (i = 0; i < this.numMoves; ++i) {
            this.moveset[i] = new PixelmonMovesetData();
            this.moveset[i].readData(data);
        }
        this.HP = data.readShort();
        this.Speed = data.readShort();
        this.Attack = data.readShort();
        this.Defence = data.readShort();
        this.SpecialAttack = data.readShort();
        this.SpecialDefence = data.readShort();
        this.boxNumber = data.readShort();
        this.isShiny = data.readBoolean();
        this.nature = EnumNature.getNatureFromIndex(data.readShort());
        this.growth = EnumGrowth.getGrowthFromIndex(data.readShort());
        this.bossMode = EnumBossMode.getMode(data.readShort());
        this.pokeball = EnumPokeballs.getFromIndex(data.readShort());
        this.doesLevel = data.readBoolean();
        if (data.readBoolean()) {
            this.heldItem = ByteBufUtils.readItemStack((ByteBuf)data);
        }
        this.effectCount = data.readShort();
        for (i = 0; i < this.effectCount; ++i) {
            this.status.add(StatusType.getEffect(data.readShort()));
        }
        this.ability = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.isEgg = data.readBoolean();
        this.eggCycles = data.readInt();
        this.steps = data.readInt();
        this.eggDescription = ByteBufUtils.readUTF8String((ByteBuf)data);
        this.specialTexture = data.readShort();
        this.isInRanch = data.readBoolean();
    }

    public BaseStats getBaseStats() {
        return Entity3HasStats.getBaseStats(this.name);
    }

    public ExternalMoveBase[] getExternalMoves() {
        if (this.resetMoves) {
            this.externalMoves = ExternalMoves.load(this);
            this.resetMoves = false;
        }
        return this.externalMoves;
    }
}

