/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumType;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class PixelmonMovesetData {
    public int attackIndex;
    public EnumType type;
    public int pp;
    public int ppBase;
    public boolean disabled = false;

    public static PixelmonMovesetData create(Moveset moveset, int i) {
        if (moveset.size() <= i) {
            return null;
        }
        PixelmonMovesetData p = new PixelmonMovesetData();
        p.attackIndex = moveset.get((int)i).baseAttack.attackIndex;
        p.pp = moveset.get((int)i).pp;
        p.ppBase = moveset.get((int)i).ppBase;
        p.type = moveset.get((int)i).baseAttack.attackType;
        p.disabled = moveset.get(i).getDisabled();
        return p;
    }

    public static PixelmonMovesetData create(NBTTagCompound nbt, int i) {
        if (nbt.func_74762_e("PixelmonNumberMoves") <= i) {
            return null;
        }
        PixelmonMovesetData p = new PixelmonMovesetData();
        p.attackIndex = !nbt.func_74764_b("PixelmonMoveID" + i) ? DatabaseMoves.getAttack((String)nbt.func_74779_i((String)new StringBuilder().append((String)"PixelmonMoveName").append((int)i).toString())).baseAttack.attackIndex : nbt.func_74762_e("PixelmonMoveID" + i);
        p.type = EnumType.parseType(nbt.func_74762_e("PixelmonMoveType" + i));
        p.pp = nbt.func_74762_e("PixelmonMovePP" + i);
        p.ppBase = nbt.func_74762_e("PixelmonMovePPBase" + i);
        return p;
    }

    public void writeData(ByteBuf data) {
        data.writeInt(this.attackIndex);
        data.writeShort(this.type.getIndex());
        data.writeShort(this.pp);
        data.writeShort(this.ppBase);
        data.writeBoolean(this.disabled);
    }

    public void readData(ByteBuf data) {
        this.attackIndex = data.readInt();
        this.type = EnumType.parseType(data.readShort());
        this.pp = data.readShort();
        this.ppBase = data.readShort();
        this.disabled = data.readBoolean();
    }

    public void updatePokemon(NBTTagCompound p, int i) {
        p.func_74768_a("PixelmonMoveID" + i, this.attackIndex);
        p.func_74768_a("PixelmonMoveType" + i, this.type.getIndex());
        p.func_74768_a("PixelmonMovePP" + i, this.pp);
        p.func_74768_a("PixelmonMovePPBase" + i, this.ppBase);
    }

    public static PixelmonMovesetData createPacket(Attack a) {
        PixelmonMovesetData p = new PixelmonMovesetData();
        p.attackIndex = a.baseAttack.attackIndex;
        p.pp = a.pp;
        p.ppBase = a.ppBase;
        p.type = a.baseAttack.attackType;
        p.disabled = a.getDisabled();
        return p;
    }
}

