/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.blocks.TileEntityTradeMachine;
import com.pixelmonmod.pixelmon.blocks.TradingRegistry;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RequestModList;
import com.pixelmonmod.pixelmon.customStarters.CustomStarters;
import com.pixelmonmod.pixelmon.customStarters.SelectPokemonController;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.util.PixelmonMsg;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BattleDimChunkProvider;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BlankTeleporter;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class PixelmonPlayerTracker {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player.field_70170_p.func_72863_F() instanceof ChunkProviderServer && ((ChunkProviderServer)player.field_70170_p.func_72863_F()).field_73246_d instanceof BattleDimChunkProvider) {
            ((EntityPlayerMP)player).field_71133_b.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)player, 0, (Teleporter)new BlankTeleporter((WorldServer)player.field_70170_p));
        }
        this.logout(player);
        CustomStarters.reloadStarters();
        if (player instanceof EntityPlayerMP) {
            PixelmonStorage.playerLoggedIn((EntityPlayerMP)player);
            try {
                PixelmonStorage.PokeballManager.loadPlayer((EntityPlayerMP)player);
            }
            catch (PlayerNotLoadedException e) {
                e.printStackTrace();
            }
            Pixelmon.network.sendTo((IMessage)new RequestModList(), (EntityPlayerMP)player);
            PixelmonMsg.handleJoin(player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        this.logout(player);
    }

    private void logout(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            try {
                EvolutionQuery eq;
                TileEntityTradeMachine tm;
                PixelmonStorage.onPlayerDC((EntityPlayerMP)player);
                SelectPokemonController.removePlayer((EntityPlayerMP)player);
                BattleQuery bq = BattleQuery.getQuery((EntityPlayerMP)player);
                if (bq != null) {
                    bq.declineQuery((EntityPlayerMP)player);
                }
                if ((tm = TradingRegistry.getTileEntity((EntityPlayer)((EntityPlayerMP)player))) != null) {
                    tm.removePlayer(player);
                }
                if ((eq = EvolutionQuery.get(player)) != null) {
                    EvolutionQuery.declineQuery(eq.pokemonID);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

