/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonMovesetData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PixelmonUpdateData
extends PixelmonData {
    EnumUpdateType[] updateTypes;

    public PixelmonUpdateData() {
    }

    public PixelmonUpdateData(NBTTagCompound p, EnumUpdateType[] updateTypes) {
        super(p);
        this.updateTypes = updateTypes;
    }

    public PixelmonUpdateData(EntityPixelmon p, EnumUpdateType[] updateTypes) {
        super(p);
        this.updateTypes = updateTypes;
    }

    @Override
    public void encodeInto(ByteBuf data) {
        data.writeInt(this.pokemonID[0]);
        data.writeInt(this.pokemonID[1]);
        data.writeShort(this.updateTypes.length);
        for (EnumUpdateType t : this.updateTypes) {
            data.writeShort(t.ordinal());
        }
        block14: for (EnumUpdateType t : this.updateTypes) {
            switch (t) {
                case HP: {
                    data.writeShort(this.hp);
                    data.writeShort(this.health);
                    data.writeBoolean(this.isFainted);
                    continue block14;
                }
                case Stats: {
                    data.writeShort(this.lvl);
                    data.writeInt(this.nextLvlXP);
                    data.writeShort(this.xp);
                    data.writeShort(this.HP);
                    data.writeShort(this.Speed);
                    data.writeShort(this.Attack);
                    data.writeShort(this.Defence);
                    data.writeShort(this.SpecialAttack);
                    data.writeShort(this.SpecialDefence);
                    continue block14;
                }
                case Nickname: {
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.nickname);
                    continue block14;
                }
                case Name: {
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.name);
                    continue block14;
                }
                case Friendship: {
                    data.writeShort(this.friendship);
                    continue block14;
                }
                case Moveset: {
                    int i;
                    data.writeShort(this.numMoves);
                    for (i = 0; i < this.numMoves; ++i) {
                        this.moveset[i].writeData(data);
                    }
                    continue block14;
                }
                case HeldItem: {
                    ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.heldItem);
                    continue block14;
                }
                case Status: {
                    int i;
                    data.writeShort(this.effectCount);
                    for (i = 0; i < this.effectCount; ++i) {
                        data.writeShort(((StatusType)((Object)this.status.get(i))).ordinal());
                    }
                    continue block14;
                }
                case CanLevel: {
                    data.writeBoolean(this.doesLevel);
                    continue block14;
                }
                case Egg: {
                    data.writeBoolean(this.isEgg);
                    data.writeInt(this.eggCycles);
                    data.writeInt(this.steps);
                    ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.eggDescription);
                    continue block14;
                }
                case Target: {
                    data.writeInt(this.targetId);
                    continue block14;
                }
            }
        }
    }

    @Override
    public void decodeInto(ByteBuf data) {
        this.pokemonID = new int[]{data.readInt(), data.readInt()};
        int numTypes = data.readShort();
        this.updateTypes = new EnumUpdateType[numTypes];
        for (int i = 0; i < numTypes; ++i) {
            this.updateTypes[i] = EnumUpdateType.getType(data.readShort());
        }
        block14: for (EnumUpdateType t : this.updateTypes) {
            switch (t) {
                case HP: {
                    this.hp = data.readShort();
                    this.health = data.readShort();
                    this.isFainted = data.readBoolean();
                    continue block14;
                }
                case Stats: {
                    this.lvl = data.readShort();
                    this.nextLvlXP = data.readInt();
                    this.xp = data.readShort();
                    this.HP = data.readShort();
                    this.Speed = data.readShort();
                    this.Attack = data.readShort();
                    this.Defence = data.readShort();
                    this.SpecialAttack = data.readShort();
                    this.SpecialDefence = data.readShort();
                    continue block14;
                }
                case Nickname: {
                    this.nickname = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block14;
                }
                case Name: {
                    this.name = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block14;
                }
                case Friendship: {
                    this.friendship = data.readShort();
                    continue block14;
                }
                case Moveset: {
                    int i;
                    this.numMoves = data.readShort();
                    for (i = 0; i < this.numMoves; ++i) {
                        this.moveset[i] = new PixelmonMovesetData();
                        this.moveset[i].readData(data);
                    }
                    continue block14;
                }
                case HeldItem: {
                    this.heldItem = ByteBufUtils.readItemStack((ByteBuf)data);
                    continue block14;
                }
                case Status: {
                    int i;
                    this.effectCount = data.readShort();
                    for (i = 0; i < this.effectCount; ++i) {
                        this.status.add(StatusType.getEffect(data.readShort()));
                    }
                    continue block14;
                }
                case CanLevel: {
                    this.doesLevel = data.readBoolean();
                    continue block14;
                }
                case Egg: {
                    this.isEgg = data.readBoolean();
                    this.eggCycles = data.readInt();
                    this.steps = data.readInt();
                    this.eggDescription = ByteBufUtils.readUTF8String((ByteBuf)data);
                    continue block14;
                }
                case Target: {
                    this.targetId = data.readInt();
                    continue block14;
                }
            }
        }
    }
}

