/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Remove;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrader;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionType;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class AcceptNPCTradePacket
implements IMessage {
    private static int tradeIndex;
    private static int lvl;
    private static String offer;
    private static String exchange;
    private static int id;

    public AcceptNPCTradePacket() {
    }

    public AcceptNPCTradePacket(int num, int lvl, String offer, String exchange, int id) {
        tradeIndex = num;
        AcceptNPCTradePacket.lvl = lvl;
        AcceptNPCTradePacket.offer = offer;
        AcceptNPCTradePacket.exchange = exchange;
        AcceptNPCTradePacket.id = id;
    }

    public void fromBytes(ByteBuf buffer) {
        tradeIndex = buffer.readInt();
        lvl = buffer.readInt();
        offer = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        exchange = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        id = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(tradeIndex);
        buffer.writeInt(lvl);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)offer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)exchange);
        buffer.writeInt(id);
    }

    public static class Handler
    implements IMessageHandler<AcceptNPCTradePacket, IMessage> {
        public IMessage onMessage(AcceptNPCTradePacket message, MessageContext ctx) {
            EntityPlayerMP playerMP = ctx.getServerHandler().field_147369_b;
            boolean checked = false;
            EntityPixelmon pokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName(offer, playerMP.field_70170_p);
            try {
                PlayerStorage storage1 = PixelmonStorage.PokeballManager.getPlayerStorage(playerMP);
                NBTTagCompound nbt = new NBTTagCompound();
                for (int i = 0; i < storage1.getList().length; ++i) {
                    String name;
                    if (storage1.getList()[i] != null) {
                        nbt = storage1.getList()[i];
                    }
                    if (!((name = nbt.func_74779_i("Name")).equalsIgnoreCase(exchange) & !checked)) continue;
                    Pixelmon.network.sendTo((IMessage)new Remove(PixelmonMethods.getID(storage1.partyPokemon[i])), playerMP);
                    storage1.changePokemon(i, null);
                    if (tradeIndex == 1) {
                        pokemon.setIsShiny(true);
                    }
                    pokemon.getLvl().setLevel(lvl);
                    storage1.pokedex.set(Pokedex.nameToID(pokemon.getName()), Pokedex.DexRegisterStatus.caught);
                    storage1.pokedex.sendToPlayer(playerMP);
                    storage1.sendUpdatedList();
                    if (!PixelmonConfig.reuseTraders) {
                        EntityTrader.locateTrader(playerMP.field_70170_p, id).func_70106_y();
                    }
                    checked = true;
                    playerMP.func_71053_j();
                    storage1.addToParty(pokemon);
                    pokemon.checkEvolution(EvolutionType.Trade);
                }
            }
            catch (PlayerNotLoadedException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

