/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PixelmonRecievedEvent;
import com.pixelmonmod.pixelmon.api.events.ReceiveType;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.StarterList;
import com.pixelmonmod.pixelmon.customStarters.CustomStarters;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class ChooseStarter
implements IMessage {
    int starterIndex;

    public ChooseStarter() {
    }

    public ChooseStarter(int starterIndex) {
        this.starterIndex = starterIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.starterIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.starterIndex);
    }

    public static class Handler
    implements IMessageHandler<ChooseStarter, IMessage> {
        public IMessage onMessage(ChooseStarter message, MessageContext ctx) {
            try {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                PlayerStorage s = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                if (s.starterPicked) {
                    return null;
                }
                EntityPixelmon p = (EntityPixelmon)PixelmonEntityList.createEntityByName(StarterList.StarterList[message.starterIndex].name, player.field_70170_p);
                p.getLvl().setLevel(CustomStarters.starterLevel);
                if (CustomStarters.shinyStarter) {
                    p.setIsShiny(CustomStarters.shinyStarter);
                }
                p.func_70606_j(p.stats.HP);
                p.loadMoveset();
                p.caughtBall = EnumPokeballs.PokeBall;
                p.friendship.initFromCapture();
                s.addToParty(p);
                s.starterPicked = true;
                Pixelmon.EVENT_BUS.post((Event)new PixelmonRecievedEvent((EntityPlayer)player, ReceiveType.Starter, p));
            }
            catch (PlayerNotLoadedException playerNotLoadedException) {
                // empty catch block
            }
            return null;
        }
    }
}

