/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityOccupiedPokeball;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.world.World;

public class KeyPacket
implements IMessage {
    public static HashMap<EntityPlayer, EntityPokeBall> playerPokeballs = new HashMap();
    int[] pokemonId;
    int entityId;
    int moveIndex;
    int x;
    int y;
    int z;
    int side;
    PacketMode mode;

    public KeyPacket() {
    }

    public KeyPacket(int[] id) {
        this.pokemonId = id;
        this.mode = PacketMode.SendPokemon;
    }

    public KeyPacket(int[] id, int entityId, PacketMode mode) {
        this.pokemonId = id;
        this.entityId = entityId;
        this.mode = mode;
    }

    public KeyPacket(int[] id, int moveIndex, int entityId) {
        this.pokemonId = id;
        this.moveIndex = moveIndex;
        this.entityId = entityId;
        this.mode = PacketMode.ExternalMoveEntity;
    }

    public KeyPacket(int[] id, int moveIndex, int x, int y, int z, int side) {
        this.pokemonId = id;
        this.moveIndex = moveIndex;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = PacketMode.ExternalMoveBlock;
        this.side = side;
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = PacketMode.getFromOrdinal(buffer.readByte());
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                this.entityId = buffer.readInt();
                break;
            }
            case ExternalMoveEntity: {
                this.entityId = buffer.readInt();
                this.moveIndex = buffer.readInt();
                break;
            }
            case ExternalMoveBlock: {
                this.moveIndex = buffer.readInt();
                this.x = buffer.readInt();
                this.y = buffer.readInt();
                this.z = buffer.readInt();
                this.side = buffer.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.mode.ordinal());
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        switch (this.mode) {
            case ExternalMove: 
            case ActionKeyEntity: {
                buffer.writeInt(this.entityId);
                break;
            }
            case ExternalMoveEntity: {
                buffer.writeInt(this.entityId);
                buffer.writeInt(this.moveIndex);
                break;
            }
            case ExternalMoveBlock: {
                buffer.writeInt(this.moveIndex);
                buffer.writeInt(this.x);
                buffer.writeInt(this.y);
                buffer.writeInt(this.z);
                buffer.writeInt(this.side);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<KeyPacket, IMessage> {
        public IMessage onMessage(KeyPacket message, MessageContext ctx) {
            PacketMode mode = message.mode;
            if (mode == PacketMode.SendPokemon) {
                this.sendPokemon(message, ctx);
                return null;
            }
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            EntityPixelmon p = this.getPokemon(world, message.pokemonId, ctx);
            if (p != null) {
                if (mode == PacketMode.ExternalMove) {
                    try {
                        p.getStorage().moves.get(message.pokemonId, message.entityId).execute(p, null);
                    }
                    catch (PlayerNotLoadedException e) {
                        e.printStackTrace();
                    }
                }
                if (mode.isEntity()) {
                    EntityLivingBase entity = (EntityLivingBase)world.func_73045_a(message.entityId);
                    if (mode == PacketMode.ActionKeyEntity) {
                        p.func_70624_b(entity);
                    } else {
                        p.setAttackTarget(entity, message.moveIndex);
                    }
                } else {
                    p.setBlockTarget(message.x, message.y, message.z, message.side, message.moveIndex);
                }
                if (mode.isAction()) {
                    p.update(EnumUpdateType.Target);
                }
            }
            return null;
        }

        private EntityPixelmon getPokemon(World world, int[] pokemonId, MessageContext ctx) {
            try {
                PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(ctx.getServerHandler().field_147369_b);
                EntityPixelmon p = storage.getAlreadyExists(pokemonId, world);
                return p;
            }
            catch (PlayerNotLoadedException e) {
                return null;
            }
        }

        private void sendPokemon(KeyPacket message, MessageContext ctx) {
            if (!Pixelmon.canSendOutPokemon) {
                return;
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            try {
                int[] pokemonId = message.pokemonId;
                NBTTagCompound nbt = PixelmonStorage.PokeballManager.getPlayerStorage(player).getNBT(pokemonId);
                if (nbt == null) {
                    return;
                }
                if (!PixelmonStorage.PokeballManager.getPlayerStorage(player).EntityAlreadyExists(pokemonId, player.field_70170_p) && !PixelmonStorage.PokeballManager.getPlayerStorage(player).isFainted(pokemonId)) {
                    if (playerPokeballs.get(player) != null && !KeyPacket.playerPokeballs.get((Object)player).field_70128_L) {
                        return;
                    }
                    EnumPokeballs caughtBall = EnumPokeballs.getFromIndex(nbt.func_74762_e("CaughtBall"));
                    EntityOccupiedPokeball pokeball = new EntityOccupiedPokeball(player.field_70170_p, (EntityLivingBase)player, pokemonId, caughtBall);
                    playerPokeballs.put((EntityPlayer)player, pokeball);
                    boolean flag = nbt.func_74779_i("NickName") == null || nbt.func_74779_i("Nickname").isEmpty();
                    ChatHandler.sendChat((Entity)player, "sendpixelmon.sentout", new ChatComponentTranslation(flag ? EntityPixelmon.getLocalizedName(nbt.func_74779_i("Name").toLowerCase()) : nbt.func_74779_i("Nickname"), new Object[0]));
                    player.field_70170_p.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    player.field_70170_p.func_72838_d((Entity)pokeball);
                } else if (PixelmonStorage.PokeballManager.getPlayerStorage(player).isFainted(pokemonId)) {
                    boolean flag = nbt.func_74779_i("NickName") == null || nbt.func_74779_i("Nickname").isEmpty();
                    ChatHandler.sendChat((Entity)player, "sendpixelmon.cantbattle", new ChatComponentTranslation(flag ? EntityPixelmon.getLocalizedName(nbt.func_74779_i("Name")) : nbt.func_74779_i("Nickname"), new Object[0]));
                } else if (PixelmonStorage.PokeballManager.getPlayerStorage(player).EntityAlreadyExists(pokemonId, player.field_70170_p)) {
                    EntityPixelmon pixelmon = PixelmonStorage.PokeballManager.getPlayerStorage(player).getAlreadyExists(pokemonId, player.field_70170_p);
                    if (pixelmon == null) {
                        return;
                    }
                    if (pixelmon.battleController != null) {
                        ChatHandler.sendChat((Entity)player, "sendpixelmon.inbattle", new ChatComponentTranslation("pixelmon." + pixelmon.getLocalizedName().toLowerCase() + ".name", new Object[0]));
                        return;
                    }
                    BattleRegistry.deRegisterBattle(BattleRegistry.getBattle((EntityPlayer)player));
                    if (pixelmon.field_70153_n == player) {
                        player.func_70078_a(null);
                    }
                    if (pixelmon.func_70902_q() == null) {
                        pixelmon.unloadEntity();
                    } else if (pixelmon.func_70902_q() == player) {
                        pixelmon.catchInPokeball();
                        boolean flag = nbt.func_74779_i("NickName") == null || nbt.func_74779_i("Nickname").isEmpty();
                        ChatHandler.sendChat((Entity)player, "sendpixelmon.retrieved", new ChatComponentTranslation(flag ? EntityPixelmon.getLocalizedName(nbt.func_74779_i("Name")) : nbt.func_74779_i("Nickname"), new Object[0]));
                    }
                }
            }
            catch (PlayerNotLoadedException e) {
                // empty catch block
            }
        }
    }

    public static enum PacketMode {
        SendPokemon,
        ActionKeyEntity,
        ActionKeyBlock,
        ExternalMoveEntity,
        ExternalMoveBlock,
        ExternalMove;


        public static PacketMode getFromOrdinal(int ordinal) {
            return PacketMode.values()[ordinal];
        }

        public boolean isEntity() {
            return this == ActionKeyEntity || this == ExternalMoveEntity;
        }

        public boolean isAction() {
            return this == ActionKeyBlock || this == ActionKeyEntity;
        }
    }
}

