/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class RenamePokemon
implements IMessage {
    int[] id;
    String name;

    public RenamePokemon() {
    }

    public RenamePokemon(int[] pokemonId, String name) {
        this.id = pokemonId;
        this.name = name;
    }

    public void fromBytes(ByteBuf buffer) {
        this.id = new int[]{buffer.readInt(), buffer.readInt()};
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.id[0]);
        buffer.writeInt(this.id[1]);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
    }

    public static class Handler
    implements IMessageHandler<RenamePokemon, IMessage> {
        public IMessage onMessage(RenamePokemon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            try {
                PlayerComputerStorage comp;
                NBTTagCompound nbt;
                if (PixelmonStorage.PokeballManager.getPlayerStorage(player).EntityAlreadyExists(message.id, player.field_70170_p)) {
                    PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                    storage.getAlreadyExists(message.id, player.field_70170_p).setNickname(message.name);
                    PixelmonStorage.PokeballManager.savePlayer(storage);
                } else if (PixelmonStorage.PokeballManager.getPlayerStorage(player).getNBT(message.id) != null) {
                    NBTTagCompound nbt2 = PixelmonStorage.PokeballManager.getPlayerStorage(player).getNBT(message.id);
                    if (nbt2 != null) {
                        nbt2.func_74778_a("Nickname", message.name);
                    }
                    PixelmonStorage.PokeballManager.savePlayer(PixelmonStorage.PokeballManager.getPlayerStorage(player));
                } else if (PixelmonStorage.ComputerManager.getPlayerStorage(player).contains(message.id) && (nbt = (comp = PixelmonStorage.ComputerManager.getPlayerStorage(player)).getPokemonNBT(message.id)) != null) {
                    nbt.func_74778_a("Nickname", message.name);
                    comp.updatePokemonNBT(message.id, nbt);
                }
            }
            catch (PlayerNotLoadedException e) {
                // empty catch block
            }
            return null;
        }
    }
}

