/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.TMListEntry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentTranslation;

public class ReplaceMove
implements IMessage {
    public static ArrayList<TMListEntry> list = new ArrayList();
    int[] pokemonId;
    int attackId;
    int replaceIndex;
    int level;

    public ReplaceMove() {
    }

    public ReplaceMove(int[] pokemonId, int attackId, int replaceIndex, int level) {
        this.pokemonId = pokemonId;
        this.attackId = attackId;
        this.replaceIndex = replaceIndex;
        this.level = level;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.attackId = buffer.readInt();
        this.replaceIndex = buffer.readInt();
        this.level = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        buffer.writeInt(this.attackId);
        buffer.writeInt(this.replaceIndex);
        buffer.writeInt(this.level);
    }

    public static void addToList(EntityPlayerMP player, Item item) {
        TMListEntry entry;
        while ((entry = ReplaceMove.getEntry(player)) != null) {
            list.remove(entry);
        }
        list.add(new TMListEntry((EntityPlayer)player, item));
    }

    public static boolean listContains(EntityPlayerMP player) {
        for (TMListEntry entry : list) {
            if (!entry.player.func_110124_au().equals(player.func_110124_au())) continue;
            return true;
        }
        return false;
    }

    public static TMListEntry getEntry(EntityPlayerMP player) {
        for (TMListEntry entry : list) {
            if (!entry.player.func_110124_au().equals(player.func_110124_au())) continue;
            return entry;
        }
        return null;
    }

    public static class Handler
    implements IMessageHandler<ReplaceMove, IMessage> {
        public IMessage onMessage(ReplaceMove message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (ReplaceMove.listContains(player)) {
                TMListEntry entry = ReplaceMove.getEntry(player);
                list.remove(entry);
                if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_146026_a(entry.item)) {
                    return null;
                }
            }
            Attack a = DatabaseMoves.getAttack(message.attackId);
            try {
                PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                EntityPixelmon p = storage.EntityAlreadyExists(message.pokemonId, player.field_70170_p) ? storage.getAlreadyExists(message.pokemonId, player.field_70170_p) : storage.sendOut(message.pokemonId, player.field_70170_p);
                ChatHandler.sendChat((Entity)player, "replacemove.replace", new ChatComponentTranslation("pixelmon." + p.getLocalizedName().toLowerCase() + ".name", new Object[0]), new ChatComponentTranslation("attack." + p.getMoveset().get((int)message.replaceIndex).baseAttack.getLocalizedName().toLowerCase() + ".name", new Object[0]), new ChatComponentTranslation("attack." + a.baseAttack.getLocalizedName().toLowerCase() + ".name", new Object[0]));
                p.getMoveset().set(message.replaceIndex, a);
                storage.update(p, EnumUpdateType.Moveset);
            }
            catch (PlayerNotLoadedException e) {
                // empty catch block
            }
            return null;
        }
    }
}

