/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;

public class SetHeldItem
implements IMessage {
    int[] pokemonId;
    ItemStack item;

    public SetHeldItem() {
    }

    public SetHeldItem(int[] pokemonId, ItemStack item) {
        this.pokemonId = pokemonId;
        this.item = item;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.item = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.item);
    }

    public static class Handler
    implements IMessageHandler<SetHeldItem, IMessage> {
        public IMessage onMessage(SetHeldItem message, MessageContext ctx) {
            try {
                int[] pokemonId = message.pokemonId;
                ItemStack newItem = message.item;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (newItem != null && !player.field_71071_by.func_146028_b(newItem.func_77973_b()) && player.field_71071_by.func_70445_o() != null && player.field_71071_by.func_70445_o().func_77973_b() != newItem.func_77973_b() && !player.field_71075_bZ.field_75098_d) {
                    return null;
                }
                PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                NBTBase oldtag = storage.getNBT(pokemonId).func_74781_a("HeldItem");
                if (oldtag instanceof NBTTagInt) {
                    int oldid = storage.getNBT(pokemonId).func_74762_e("HeldItem");
                    if (oldid != -1) {
                        ItemStack oldType = new ItemStack(Item.func_150899_d((int)oldid), 1);
                        storage.getNBT(pokemonId).func_74782_a("HeldItemStack", (NBTBase)oldType.func_77955_b(new NBTTagCompound()));
                    }
                    storage.getNBT(pokemonId).func_82580_o("HeldItem");
                }
                ItemStack oldItem = ItemStack.func_77949_a((NBTTagCompound)storage.getNBT(pokemonId).func_74775_l("HeldItemStack"));
                if (storage.EntityAlreadyExists(pokemonId, player.field_70170_p)) {
                    EntityPixelmon pixelmon = storage.getAlreadyExists(pokemonId, player.field_70170_p);
                    ItemStack heldItem = newItem;
                    pixelmon.heldItem = heldItem != null ? heldItem : null;
                    storage.update(pixelmon, EnumUpdateType.HeldItem);
                } else if (newItem != null) {
                    storage.getNBT(pokemonId).func_74782_a("HeldItemStack", (NBTBase)newItem.func_77955_b(new NBTTagCompound()));
                } else {
                    storage.getNBT(pokemonId).func_82580_o("HeldItemStack");
                }
                ItemStack playerHeldItem = player.field_71071_by.func_70445_o();
                if (playerHeldItem != null) {
                    --playerHeldItem.field_77994_a;
                }
                if (oldItem == null) {
                    if (playerHeldItem == null || playerHeldItem.field_77994_a <= 0) {
                        player.field_71071_by.func_70437_b(null);
                    } else {
                        player.field_71071_by.func_70437_b(playerHeldItem);
                    }
                } else {
                    if (oldItem.field_77994_a == 0) {
                        oldItem.field_77994_a = 1;
                    }
                    if (newItem == null) {
                        player.field_71071_by.func_70437_b(oldItem);
                    } else if (newItem != oldItem) {
                        if (playerHeldItem == null || playerHeldItem.field_77994_a <= 0) {
                            player.field_71071_by.func_70437_b(oldItem);
                        } else {
                            player.field_71071_by.func_70437_b(playerHeldItem);
                            if (newItem != null) {
                                player.field_71071_by.func_70441_a(oldItem);
                            }
                        }
                    } else {
                        if (playerHeldItem != null) {
                            ++playerHeldItem.field_77994_a;
                        }
                        player.field_71071_by.func_70437_b(playerHeldItem);
                    }
                }
            }
            catch (PlayerNotLoadedException playerNotLoadedException) {
                // empty catch block
            }
            return null;
        }
    }
}

