/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class StopStartLevelling
implements IMessage {
    int[] pokemonId;

    public StopStartLevelling() {
    }

    public StopStartLevelling(int[] pokemonId) {
        this.pokemonId = pokemonId;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
    }

    public static class Handler
    implements IMessageHandler<StopStartLevelling, IMessage> {
        public IMessage onMessage(StopStartLevelling message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            try {
                int[] pokemonId = message.pokemonId;
                if (PixelmonStorage.PokeballManager.getPlayerStorage(player).EntityAlreadyExists(pokemonId, player.field_70170_p)) {
                    PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                    EntityPixelmon pixelmon = storage.getAlreadyExists(pokemonId, player.field_70170_p);
                    pixelmon.doesLevel = !pixelmon.doesLevel;
                    storage.update(pixelmon, EnumUpdateType.CanLevel);
                } else if (PixelmonStorage.PokeballManager.getPlayerStorage(player).getNBT(pokemonId) != null) {
                    PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                    NBTTagCompound nbt = storage.getNBT(pokemonId);
                    if (nbt != null) {
                        if (nbt.func_74764_b("DoesLevel")) {
                            if (nbt.func_74767_n("DoesLevel")) {
                                nbt.func_74757_a("DoesLevel", false);
                            } else {
                                nbt.func_74757_a("DoesLevel", true);
                            }
                        } else {
                            nbt.func_74757_a("DoesLevel", true);
                        }
                    }
                    storage.updateClient(nbt, EnumUpdateType.CanLevel);
                } else if (PixelmonStorage.ComputerManager.getPlayerStorage(player).contains(pokemonId)) {
                    PlayerComputerStorage comp = PixelmonStorage.ComputerManager.getPlayerStorage(player);
                    if (!comp.contains(pokemonId)) {
                        return null;
                    }
                    NBTTagCompound nbt = comp.getPokemonNBT(pokemonId);
                    if (nbt != null) {
                        if (nbt.func_74764_b("DoesLevel")) {
                            if (nbt.func_74767_n("DoesLevel")) {
                                nbt.func_74757_a("DoesLevel", false);
                            } else {
                                nbt.func_74757_a("DoesLevel", true);
                            }
                        } else {
                            nbt.func_74757_a("DoesLevel", true);
                        }
                        comp.updatePokemonNBT(pokemonId, nbt);
                    }
                }
            }
            catch (PlayerNotLoadedException e) {
                // empty catch block
            }
            return null;
        }
    }
}

