/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerComputerStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;

public class SwapMove
implements IMessage {
    int[] pokemonId;
    int selected;
    int clicked;

    public SwapMove() {
    }

    public SwapMove(int[] pokemonId, int selected, int clicked) {
        this.pokemonId = pokemonId;
        this.selected = selected;
        this.clicked = clicked;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.selected = buffer.readInt();
        this.clicked = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        buffer.writeInt(this.selected);
        buffer.writeInt(this.clicked);
    }

    public static class Handler
    implements IMessageHandler<SwapMove, IMessage> {
        public IMessage onMessage(SwapMove message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            try {
                int[] pokemonId = message.pokemonId;
                if (PixelmonStorage.PokeballManager.getPlayerStorage(player).contains(pokemonId)) {
                    PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                    EntityPixelmon p = storage.EntityAlreadyExists(pokemonId, player.field_70170_p) ? storage.getAlreadyExists(pokemonId, player.field_70170_p) : storage.sendOut(pokemonId, player.field_70170_p);
                    p.getMoveset().swap(message.selected, message.clicked);
                    storage.update(p, EnumUpdateType.Moveset);
                } else if (PixelmonStorage.ComputerManager.getPlayerStorage(player).contains(pokemonId)) {
                    PlayerComputerStorage compStore = PixelmonStorage.ComputerManager.getPlayerStorage(player);
                    EntityPixelmon p = compStore.getPokemonEntity(pokemonId);
                    p.getMoveset().swap(message.selected, message.clicked);
                    compStore.updatePokemonEntry(p);
                }
            }
            catch (PlayerNotLoadedException e) {
                // empty catch block
            }
            return null;
        }
    }
}

