/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public class BackToMainMenu
implements IMessage {
    boolean canSwitch;
    ArrayList<int[]> pokemonToChoose;

    public BackToMainMenu() {
    }

    public BackToMainMenu(boolean canSwitch, ArrayList<PixelmonWrapper> pokemonToChoose) {
        this.canSwitch = canSwitch;
        this.pokemonToChoose = new ArrayList();
        for (PixelmonWrapper p : pokemonToChoose) {
            this.pokemonToChoose.add(p.pokemon.getPokemonId());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.canSwitch = buffer.readBoolean();
        int size = buffer.readShort();
        this.pokemonToChoose = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.pokemonToChoose.add(new int[]{buffer.readInt(), buffer.readInt()});
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.canSwitch);
        buffer.writeShort(this.pokemonToChoose.size());
        for (int[] id : this.pokemonToChoose) {
            buffer.writeInt(id[0]);
            buffer.writeInt(id[1]);
        }
    }

    public static class Handler
    implements IMessageHandler<BackToMainMenu, IMessage> {
        public IMessage onMessage(BackToMainMenu message, MessageContext ctx) {
            ClientProxy.battleManager.startPicking(message.canSwitch, message.pokemonToChoose);
            return null;
        }
    }
}

