/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.attacks.IBattleMessage;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;

public class DamagePacket
implements IMessage,
IBattleMessage {
    Attack attack;
    boolean userHasNickname;
    boolean sourceHasNickname;
    String user;
    String source;
    int damage;

    public DamagePacket() {
    }

    public DamagePacket(EntityPixelmon user, BattleDamageSource source, int damage) {
        if (user.hasNickname()) {
            this.userHasNickname = true;
            this.user = user.getNickname();
        } else {
            this.user = user.getName();
        }
        this.source = source.getWrapper().pokemon.getNickname();
        this.attack = source.getWrapper().attack;
        this.damage = damage;
    }

    public void fromBytes(ByteBuf buf) {
        this.user = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.source = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.attack = DatabaseMoves.getAttack(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.user);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.source);
        buf.writeBoolean(this.attack != null);
        if (this.attack != null) {
            buf.writeInt(this.attack.baseAttack.attackIndex);
        }
    }

    @Override
    public ChatComponentTranslation getMessage() {
        ChatComponentText username = this.userHasNickname ? new ChatComponentText(this.user) : new ChatComponentTranslation("pixelmon." + this.user + ".name", new Object[0]);
        username.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
        ChatComponentText sourcename = this.sourceHasNickname ? new ChatComponentText(this.source) : new ChatComponentTranslation("pixelmon." + this.source + ".name", new Object[0]);
        sourcename.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
        ChatComponentText damagec = new ChatComponentText("" + this.damage);
        damagec.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        ChatComponentTranslation c = new ChatComponentTranslation("battlecontroller.recievedDamage", new Object[]{username, damagec, sourcename});
        return c;
    }

    public static class Handler
    implements IMessageHandler<DamagePacket, IMessage> {
        public IMessage onMessage(DamagePacket message, MessageContext ctx) {
            ClientProxy.battleManager.addBattleMessage(message);
            return null;
        }
    }
}

