/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.attacks.IBattleMessage;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;

public class HealPacket
implements IMessage,
IBattleMessage {
    private String user;
    private boolean userHasNickname = false;
    private int heal;

    public HealPacket() {
    }

    public HealPacket(EntityPixelmon user, int healAmount) {
        if (user.hasNickname()) {
            this.user = user.getNickname();
            this.userHasNickname = true;
        } else {
            this.user = user.getName();
        }
        this.heal = healAmount;
    }

    public void fromBytes(ByteBuf buf) {
        this.user = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.userHasNickname = buf.readBoolean();
        this.heal = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.user);
        buf.writeBoolean(this.userHasNickname);
        buf.writeInt(this.heal);
    }

    @Override
    public ChatComponentTranslation getMessage() {
        ChatComponentText username = this.userHasNickname ? new ChatComponentText(this.user) : new ChatComponentTranslation("pixelmon." + this.user + ".name", new Object[0]);
        username.func_150256_b().func_150238_a(EnumChatFormatting.BLUE);
        ChatComponentText healc = new ChatComponentText("" + this.heal);
        healc.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
        ChatComponentTranslation c = new ChatComponentTranslation("battlecontroller.recievedDamage", new Object[]{username, healc});
        return c;
    }

    public static class Handler
    implements IMessageHandler<HealPacket, IMessage> {
        public IMessage onMessage(HealPacket message, MessageContext ctx) {
            ClientProxy.battleManager.addBattleMessage(message);
            return null;
        }
    }
}

