/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;

public class SetStruggle
implements IMessage {
    public boolean[][] targetting;
    public int battleIndex;
    public int[] pokemonId;

    public SetStruggle() {
    }

    public SetStruggle(int[] pokemonId, boolean[][] targetting, int battleIndex) {
        this.pokemonId = pokemonId;
        this.battleIndex = battleIndex;
        this.targetting = targetting;
    }

    public void fromBytes(ByteBuf buffer) {
        int i;
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.battleIndex = buffer.readInt();
        this.targetting = new boolean[buffer.readShort()][];
        for (i = 0; i < this.targetting.length; ++i) {
            this.targetting[i] = new boolean[buffer.readShort()];
        }
        for (i = 0; i < this.targetting.length; ++i) {
            for (int j = 0; j < this.targetting[i].length; ++j) {
                this.targetting[i][j] = buffer.readBoolean();
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        int i;
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        buffer.writeInt(this.battleIndex);
        buffer.writeShort(this.targetting.length);
        for (i = 0; i < this.targetting.length; ++i) {
            buffer.writeShort(this.targetting[i].length);
        }
        for (i = 0; i < this.targetting.length; ++i) {
            for (int j = 0; j < this.targetting[i].length; ++j) {
                buffer.writeBoolean(this.targetting[i][j]);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<SetStruggle, IMessage> {
        public IMessage onMessage(SetStruggle message, MessageContext ctx) {
            BattleControllerBase bc = BattleRegistry.getBattle(message.battleIndex);
            for (BattleParticipant p : bc.participants) {
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    if (!PixelmonMethods.isIDSame(pw.pokemon, message.pokemonId)) continue;
                    if (p.isAFK) {
                        p.isAFK = false;
                        for (BattleParticipant p2 : bc.participants) {
                            if (p2.getType() != ParticipantType.Player) continue;
                            if (p.getEntity().func_145782_y() == p2.getEntity().func_145782_y()) {
                                ChatHandler.sendChat((Entity)p.getEntity(), "battlecontroller.selfafkback", PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
                                continue;
                            }
                            ChatHandler.sendChat((Entity)p2.getEntity(), "battlecontroller.afkback", p.getName(), PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
                        }
                    }
                    ArrayList<PixelmonWrapper> targets = this.findTargets(message, bc, p);
                    pw.setStruggle(targets);
                }
            }
            return null;
        }

        private ArrayList<PixelmonWrapper> findTargets(SetStruggle message, BattleControllerBase bc, BattleParticipant p) {
            ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
            ArrayList<PixelmonWrapper> teamPokemon = bc.getTeamPokemon(p);
            for (int i = 0; i < message.targetting[0].length; ++i) {
                if (!message.targetting[0][i]) continue;
                targets.add(teamPokemon.get(i));
            }
            ArrayList<PixelmonWrapper> opponentPokemon = bc.getOpponentPokemon(p);
            for (int i = 0; i < message.targetting[0].length; ++i) {
                if (!message.targetting[1][i]) continue;
                targets.add(opponentPokemon.get(i));
            }
            return targets;
        }
    }
}

