/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class StartBattle
implements IMessage {
    int battleControllerIndex;
    ParticipantType[][] type;

    public StartBattle() {
    }

    public StartBattle(int battleControllerIndex, ParticipantType[][] type) {
        this.battleControllerIndex = battleControllerIndex;
        this.type = type;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.battleControllerIndex);
        for (int i = 0; i < 2; ++i) {
            buffer.writeShort(this.type[i].length);
            for (ParticipantType p : this.type[i]) {
                buffer.writeInt(p.ordinal());
            }
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.battleControllerIndex = buffer.readInt();
        this.type = new ParticipantType[2][];
        for (int i = 0; i < 2; ++i) {
            this.type[i] = new ParticipantType[buffer.readShort()];
            for (int j = 0; j < this.type[i].length; ++j) {
                this.type[i][j] = ParticipantType.get(buffer.readInt());
            }
        }
    }

    public static class Handler
    implements IMessageHandler<StartBattle, IMessage> {
        public IMessage onMessage(StartBattle message, MessageContext ctx) {
            ClientProxy.battleManager.StartBattle(message.battleControllerIndex, message.type);
            return null;
        }
    }
}

