/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class SwitchPokemon
implements IMessage {
    int pos;
    int battleControllerIndex;
    int[] switchingPokemonId;
    boolean happensInstantly;

    public SwitchPokemon() {
    }

    public SwitchPokemon(int pos, int battleControllerIndex, int[] switchingPokemonId, boolean happensInstantly) {
        this.pos = pos;
        this.battleControllerIndex = battleControllerIndex;
        this.switchingPokemonId = switchingPokemonId;
        this.happensInstantly = happensInstantly;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pos = buffer.readInt();
        this.battleControllerIndex = buffer.readInt();
        this.switchingPokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.happensInstantly = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pos);
        buffer.writeInt(this.battleControllerIndex);
        buffer.writeInt(this.switchingPokemonId[0]);
        buffer.writeInt(this.switchingPokemonId[1]);
        buffer.writeBoolean(this.happensInstantly);
    }

    public static class Handler
    implements IMessageHandler<SwitchPokemon, IMessage> {
        public IMessage onMessage(SwitchPokemon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            BattleControllerBase bc = BattleRegistry.getBattle(message.battleControllerIndex);
            if (bc == null) {
                return null;
            }
            try {
                for (BattleParticipant p : bc.participants) {
                    if (!(p instanceof PlayerParticipant) || ((PlayerParticipant)p).player != player) continue;
                    if (p.getEntity() == player && p.isAFK) {
                        p.isAFK = false;
                        for (BattleParticipant p2 : bc.participants) {
                            if (p2.getType() != ParticipantType.Player) continue;
                            if (p.getEntity().func_145782_y() == p2.getEntity().func_145782_y()) {
                                ChatHandler.sendChat((Entity)p.getEntity(), "battlecontroller.selfafkback", PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
                                continue;
                            }
                            ChatHandler.sendChat((Entity)p2.getEntity(), "battlecontroller.afkback", p.getName(), PixelmonConfig.afkTimerActivateSeconds, PixelmonConfig.afkTimerTurnSeconds);
                        }
                    }
                    bc.SwitchPokemon(message.switchingPokemonId, PixelmonStorage.PokeballManager.getPlayerStorage(player).getIDFromPosition(message.pos), message.happensInstantly);
                }
            }
            catch (PlayerNotLoadedException e) {
                bc.endBattle();
            }
            return null;
        }
    }
}

