/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;

public class ChooseMoveset
implements IMessage {
    public static final ArrayList<ChoosingMovesetData> choosingMoveset = new ArrayList();
    int[] id;
    ArrayList<Integer> attackIds = new ArrayList();

    public ChooseMoveset() {
    }

    public ChooseMoveset(PixelmonData pokemon, ArrayList<Attack> chosenAttackList) {
        this.id = pokemon.pokemonID;
        for (Attack a : chosenAttackList) {
            this.attackIds.add(a.baseAttack.attackIndex);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new int[]{buf.readInt(), buf.readInt()};
        int num = buf.readShort();
        for (int i = 0; i < num; ++i) {
            this.attackIds.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id[0]);
        buf.writeInt(this.id[1]);
        buf.writeShort(this.attackIds.size());
        for (Integer i : this.attackIds) {
            buf.writeInt(i.intValue());
        }
    }

    public static class Handler
    implements IMessageHandler<ChooseMoveset, IMessage> {
        public IMessage onMessage(ChooseMoveset message, MessageContext ctx) {
            try {
                ChoosingMovesetData d;
                PlayerStorage s = PixelmonStorage.PokeballManager.getPlayerStorage(ctx.getServerHandler().field_147369_b);
                EntityPixelmon p = null;
                boolean wasout = false;
                if (s.EntityAlreadyExists(message.id, ctx.getServerHandler().field_147369_b.field_70170_p)) {
                    p = s.getAlreadyExists(message.id, ctx.getServerHandler().field_147369_b.field_70170_p);
                    wasout = true;
                } else {
                    p = s.sendOut(message.id, ctx.getServerHandler().field_147369_b.field_70170_p);
                }
                p.getMoveset().replaceWith(message.attackIds);
                p.update(EnumUpdateType.Moveset);
                if (!wasout) {
                    p.unloadEntity();
                }
                if ((d = this.getChoosingMoveset(ctx.getServerHandler().field_147369_b)) != null) {
                    d.next();
                    if (d.pokemonList.size() == 0) {
                        choosingMoveset.remove(d);
                    }
                }
            }
            catch (PlayerNotLoadedException e) {
                e.printStackTrace();
            }
            return null;
        }

        private ChoosingMovesetData getChoosingMoveset(EntityPlayerMP playerEntity) {
            for (ChoosingMovesetData c : choosingMoveset) {
                if (c.player.getPersistentID() != playerEntity.getPersistentID()) continue;
                return c;
            }
            return null;
        }
    }
}

