/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.mail;

import com.pixelmonmod.pixelmon.items.heldItems.ItemMail;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class MailPacket
implements IMessage {
    private Boolean sealed;
    private String author;
    private String contents;
    private String playerUUID;

    public MailPacket() {
    }

    public MailPacket(Boolean sealed, String author, String contents, EntityPlayer player) {
        this.sealed = sealed;
        this.author = author;
        this.contents = contents;
        this.playerUUID = player.func_110124_au().toString();
    }

    private String readString(ByteBuf buf) {
        int stringSize = buf.readInt();
        byte[] stringBuffer = new byte[stringSize];
        buf.readBytes(stringBuffer);
        return new String(stringBuffer);
    }

    private void writeString(String string, ByteBuf buf) {
        buf.writeInt(string.length());
        buf.writeBytes(string.getBytes());
    }

    public void fromBytes(ByteBuf buf) {
        this.sealed = buf.readBoolean();
        this.author = this.readString(buf);
        this.contents = this.readString(buf);
        this.playerUUID = this.readString(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.sealed.booleanValue());
        this.writeString(this.author, buf);
        this.writeString(this.contents, buf);
        this.writeString(this.playerUUID, buf);
    }

    public static class Handler
    implements IMessageHandler<MailPacket, IMessage> {
        public IMessage onMessage(MailPacket message, MessageContext ctx) {
            UUID targetUUID = UUID.fromString(message.playerUUID);
            List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            for (EntityPlayerMP player : players) {
                if (!player.func_110124_au().equals(targetUUID)) continue;
                ItemStack letter = player.func_70694_bm();
                if (letter.func_77973_b() instanceof ItemMail) {
                    NBTTagCompound nbtData = new NBTTagCompound();
                    nbtData.func_74757_a("editable", message.sealed == false);
                    nbtData.func_74778_a("author", message.author);
                    nbtData.func_74778_a("contents", message.contents);
                    letter.func_77982_d(nbtData);
                    continue;
                }
                FMLLog.info((String)"the hell?", (Object[])new Object[0]);
            }
            return null;
        }
    }
}

