/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.ranch;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.ranch.TileEntityRanchBlock;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiExtendRanch;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiRanchBlock;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;

public class RanchBlockClientPacket
implements IMessage {
    PacketMode mode;
    int x;
    int y;
    int z;
    boolean isEggReady;
    ArrayList<PixelmonData> pokemon;
    PixelmonData egg;
    boolean hasEgg = false;
    boolean[] extendDirections = new boolean[4];

    public RanchBlockClientPacket() {
    }

    public RanchBlockClientPacket(TileEntityRanchBlock rb, PacketMode mode) {
        this.mode = mode;
        this.x = rb.field_145851_c;
        this.y = rb.field_145848_d;
        this.z = rb.field_145849_e;
        if (mode == PacketMode.ViewBlock) {
            this.pokemon = rb.getPokemonData();
            for (PixelmonData d : this.pokemon) {
                d.boxNumber = -1;
            }
            this.egg = rb.getPokemonEggData();
            if (this.egg != null) {
                this.hasEgg = true;
            }
        } else if (mode == PacketMode.UpgradeBlock) {
            this.extendDirections[0] = rb.getBounds().canExtend(1, 0, 0, 0);
            this.extendDirections[1] = rb.getBounds().canExtend(0, 1, 0, 0);
            this.extendDirections[2] = rb.getBounds().canExtend(0, 0, 1, 0);
            this.extendDirections[3] = rb.getBounds().canExtend(0, 0, 0, 1);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mode = PacketMode.getFromOrdinal(buf.readShort());
        if (this.mode == PacketMode.ViewBlock) {
            this.pokemon = new ArrayList();
            int count = buf.readShort();
            for (int i = 0; i < count; ++i) {
                PixelmonData p = new PixelmonData();
                p.decodeInto(buf);
                this.pokemon.add(p);
            }
            this.hasEgg = buf.readBoolean();
            if (this.hasEgg) {
                this.egg = new PixelmonData();
                this.egg.decodeInto(buf);
            }
        } else if (this.mode == PacketMode.UpgradeBlock) {
            for (int i = 0; i < 4; ++i) {
                this.extendDirections[i] = buf.readBoolean();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeShort(this.mode.ordinal());
        if (this.mode == PacketMode.ViewBlock) {
            buf.writeShort(this.pokemon.size());
            for (PixelmonData d : this.pokemon) {
                d.encodeInto(buf);
            }
            buf.writeBoolean(this.hasEgg);
            if (this.hasEgg) {
                this.egg.encodeInto(buf);
            }
        } else if (this.mode == PacketMode.UpgradeBlock) {
            for (int i = 0; i < 4; ++i) {
                buf.writeBoolean(this.extendDirections[i]);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<RanchBlockClientPacket, IMessage> {
        public IMessage onMessage(RanchBlockClientPacket message, MessageContext ctx) {
            if (message.mode == PacketMode.ViewBlock) {
                GuiRanchBlock.pos = new int[]{message.x, message.y, message.z};
                GuiRanchBlock.pokemon = message.pokemon;
                GuiRanchBlock.egg = message.egg;
                Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.RanchBlock.getIndex().intValue(), Minecraft.func_71410_x().field_71439_g.field_70170_p, 0, 0, 0);
            } else if (message.mode == PacketMode.UpgradeBlock) {
                GuiExtendRanch.pos = new int[]{message.x, message.y, message.z};
                GuiExtendRanch.extendDirections = message.extendDirections;
                Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.ExtendRanch.getIndex().intValue(), Minecraft.func_71410_x().field_71439_g.field_70170_p, 0, 0, 0);
            }
            return null;
        }
    }

    public static enum PacketMode {
        ViewBlock,
        UpgradeBlock;


        public static PacketMode getFromOrdinal(int ord) {
            for (PacketMode p : PacketMode.values()) {
                if (p.ordinal() != ord) continue;
                return p;
            }
            return null;
        }
    }
}

