/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.ranch;

import com.pixelmonmod.pixelmon.blocks.ranch.TileEntityRanchBlock;
import com.pixelmonmod.pixelmon.items.ItemRanchUpgrade;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class RanchBlockServerPacket
implements IMessage {
    PacketMode mode;
    int x;
    int y;
    int z;
    int[] id;
    boolean[] extendDirection;

    public RanchBlockServerPacket() {
    }

    public RanchBlockServerPacket(int x, int y, int z, PacketMode mode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
    }

    public RanchBlockServerPacket(int x, int y, int z, int[] id, PacketMode mode) {
        this(x, y, z, mode);
        this.id = id;
    }

    public RanchBlockServerPacket(int x, int y, int z, PacketMode mode, boolean[] extendDirection) {
        this(x, y, z, mode);
        this.extendDirection = extendDirection;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mode = PacketMode.getFromOrdinal(buf.readShort());
        switch (this.mode) {
            case RemovePokemon: 
            case AddPokemon: {
                this.id = new int[]{buf.readInt(), buf.readInt()};
                break;
            }
            case ExtendRanch: {
                this.extendDirection = new boolean[]{buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean()};
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeShort(this.mode.ordinal());
        switch (this.mode) {
            case RemovePokemon: 
            case AddPokemon: {
                buf.writeInt(this.id[0]);
                buf.writeInt(this.id[1]);
                break;
            }
            case ExtendRanch: {
                buf.writeBoolean(this.extendDirection[0]);
                buf.writeBoolean(this.extendDirection[1]);
                buf.writeBoolean(this.extendDirection[2]);
                buf.writeBoolean(this.extendDirection[3]);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<RanchBlockServerPacket, IMessage> {
        public IMessage onMessage(RanchBlockServerPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntityRanchBlock rb = (TileEntityRanchBlock)player.field_70170_p.func_147438_o(message.x, message.y, message.z);
            block0 : switch (message.mode) {
                case AddPokemon: {
                    rb.addPokemon(player, message.id);
                    break;
                }
                case RemovePokemon: {
                    rb.removePokemon(player, message.id);
                    break;
                }
                case CollectEgg: {
                    rb.claimEgg(player);
                    break;
                }
                case ExtendRanch: {
                    rb.getBounds().Extend(ctx.getServerHandler().field_147369_b, message.extendDirection[0] ? 1 : 0, message.extendDirection[1] ? 1 : 0, message.extendDirection[2] ? 1 : 0, message.extendDirection[3] ? 1 : 0);
                    if (player.field_71075_bZ.field_75098_d) break;
                    if (player.func_71045_bC().func_77973_b() instanceof ItemRanchUpgrade) {
                        player.field_71071_by.func_146026_a(player.func_71045_bC().func_77973_b());
                        break;
                    }
                    for (ItemStack s : player.field_71071_by.field_70462_a) {
                        if (!(s.func_77973_b() instanceof ItemRanchUpgrade)) continue;
                        player.field_71071_by.func_146026_a(s.func_77973_b());
                        break block0;
                    }
                    break;
                }
            }
            return null;
        }
    }

    public static enum PacketMode {
        AddPokemon,
        CollectEgg,
        RemovePokemon,
        ExtendRanch;


        public static PacketMode getFromOrdinal(int ordinal) {
            for (PacketMode p : PacketMode.values()) {
                if (p.ordinal() != ordinal) continue;
                return p;
            }
            return null;
        }
    }
}

