/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;

public class StatuePacketServer
implements IMessage {
    PacketMode mode;
    int[] id;
    String name;

    public StatuePacketServer() {
    }

    public StatuePacketServer(PacketMode mode, int[] id, String name) {
        this.mode = mode;
        this.id = id;
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = PacketMode.getFromOrdinal(buf.readShort());
        this.id = new int[]{buf.readInt(), buf.readInt()};
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetName: {
                this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)((short)this.mode.ordinal()));
        buf.writeInt(this.id[0]);
        buf.writeInt(this.id[1]);
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetName: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<StatuePacketServer, IMessage> {
        public IMessage onMessage(StatuePacketServer message, MessageContext ctx) {
            EntityStatue statue = null;
            List entityList = ctx.getServerHandler().field_147369_b.field_70170_p.field_72996_f;
            for (Entity e : entityList) {
                if (!(e instanceof EntityStatue) || !PixelmonMethods.isIDSame(((EntityStatue)e).getPokemonId(), message.id)) continue;
                statue = (EntityStatue)e;
                break;
            }
            if (statue == null) {
                return null;
            }
            switch (message.mode) {
                case SetName: {
                    statue.init(message.name);
                    break;
                }
                case SetGrowth: {
                    statue.setGrowth(EnumGrowth.growthFromString(message.name));
                    break;
                }
                case SetLabel: {
                    statue.setLabel(message.name);
                    break;
                }
                case SetTextureType: {
                    statue.setTextureType(EnumStatueTextureType.getFromString(message.name));
                }
            }
            return null;
        }
    }

    public static enum PacketMode {
        SetName,
        SetGrowth,
        SetLabel,
        SetTextureType;


        public static PacketMode getFromOrdinal(int value) {
            for (PacketMode m : PacketMode.values()) {
                if (m.ordinal() != value) continue;
                return m;
            }
            return null;
        }
    }
}

