/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trainerEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerEditor.StoreTrainerPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumSteveTextures;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.EnumTrainerModel;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class TrainerServerPacket
implements IMessage {
    PacketType mode;
    int trainerId;
    EnumTrainerAI ai;
    EnumBossMode bm;
    EnumEncounterMode em;
    int modelIndex;
    String data;
    EnumPokemon pokemon;
    int pos;
    private EnumSteveTextures tex;

    public TrainerServerPacket() {
    }

    public TrainerServerPacket(int trainerId) {
        this.trainerId = trainerId;
    }

    public TrainerServerPacket(int trainerId, EnumTrainerAI ai) {
        this(trainerId);
        this.mode = PacketType.AI;
        this.ai = ai;
    }

    public TrainerServerPacket(int trainerId, EnumBossMode bm) {
        this(trainerId);
        this.mode = PacketType.BossMode;
        this.bm = bm;
    }

    public TrainerServerPacket(int trainerId, EnumEncounterMode bm) {
        this(trainerId);
        this.mode = PacketType.EncounterMode;
        this.em = bm;
    }

    public TrainerServerPacket(int trainerId, int modelIndex) {
        this(trainerId);
        this.mode = PacketType.Model;
        this.modelIndex = modelIndex;
    }

    public TrainerServerPacket(int trainerId, PacketType mode, String data) {
        this(trainerId);
        this.mode = mode;
        this.data = data;
    }

    public TrainerServerPacket(int trainerId, EnumPokemon pokemon, int pos) {
        this(trainerId);
        this.mode = PacketType.Pokemon;
        this.pokemon = pokemon;
        this.pos = pos;
    }

    public TrainerServerPacket(int trainerId, EnumSteveTextures tex) {
        this(trainerId);
        this.mode = PacketType.SteveTexture;
        this.tex = tex;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeShort(this.mode.ordinal());
        buffer.writeInt(this.trainerId);
        switch (this.mode) {
            case AI: {
                buffer.writeInt(this.ai.ordinal());
                break;
            }
            case BossMode: {
                buffer.writeInt(this.bm.ordinal());
                break;
            }
            case EncounterMode: {
                buffer.writeInt(this.em.ordinal());
                break;
            }
            case Model: {
                buffer.writeInt(this.modelIndex);
                break;
            }
            case CustomSteveTexture: 
            case Name: {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.data);
                break;
            }
            case Pokemon: {
                buffer.writeInt(this.pokemon.ordinal());
                buffer.writeInt(this.pos);
                break;
            }
            case SteveTexture: {
                buffer.writeInt(this.tex.ordinal());
            }
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = PacketType.values()[buffer.readShort()];
        this.trainerId = buffer.readInt();
        switch (this.mode) {
            case AI: {
                this.ai = EnumTrainerAI.getFromOrdinal(buffer.readInt());
                break;
            }
            case BossMode: {
                this.bm = EnumBossMode.getMode(buffer.readInt());
                break;
            }
            case EncounterMode: {
                this.em = EnumEncounterMode.getFromIndex(buffer.readInt());
                break;
            }
            case Model: {
                this.modelIndex = buffer.readInt();
                break;
            }
            case CustomSteveTexture: 
            case Name: {
                this.data = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                break;
            }
            case Pokemon: {
                this.pokemon = EnumPokemon.getFromOrdinal(buffer.readInt());
                this.pos = buffer.readInt();
                break;
            }
            case SteveTexture: {
                this.tex = EnumSteveTextures.getFromIndex(buffer.readInt());
            }
        }
    }

    public static class Handler
    implements IMessageHandler<TrainerServerPacket, IMessage> {
        public IMessage onMessage(TrainerServerPacket message, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            EntityTrainer t = EntityTrainer.locateTrainer(p.field_70170_p, message.trainerId);
            switch (message.mode) {
                case AI: {
                    t.setAIMode(message.ai);
                    t.initAI();
                    break;
                }
                case BossMode: {
                    t.setBossMode(message.bm);
                    break;
                }
                case EncounterMode: {
                    t.setEncounterMode(message.em);
                    break;
                }
                case Model: {
                    t.setModel(EnumTrainerModel.getFromInt(message.modelIndex), (EntityPlayer)p);
                    break;
                }
                case Name: {
                    if (message.data != null) {
                        t.setNickName(message.data);
                    }
                    t.initAI();
                    break;
                }
                case Pokemon: {
                    EntityPixelmon pix = (EntityPixelmon)PixelmonEntityList.createEntityByName(message.pokemon.name, p.field_70170_p);
                    t.getPokemonStorage().getList()[message.pos] = null;
                    t.getPokemonStorage().addToParty(pix);
                    t.updateLvl();
                    Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), p);
                    for (int i = 0; i < t.getPokemonStorage().count(); ++i) {
                        Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(new PixelmonData(t.getPokemonStorage().getList()[i])), p);
                    }
                    break;
                }
                case SteveTexture: {
                    t.setSteveTexture(message.tex.toString());
                    break;
                }
                case CustomSteveTexture: {
                    t.setCustomSteveTexture(message.data);
                }
            }
            return null;
        }
    }

    public static enum PacketType {
        AI,
        BossMode,
        CustomSteveTexture,
        EncounterMode,
        Model,
        Name,
        Pokemon,
        SteveTexture;

    }
}

