/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Battle2
extends CommandBase {
    public String func_71517_b() {
        return "pokebattle2";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/pokebattle2 <player> <player|pokemon> <player|pokemon> <player|pokemon>";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        EntityPlayerMP sender = Battle2.func_82359_c((ICommandSender)par1ICommandSender, (String)par1ICommandSender.func_70005_c_());
        if (par2ArrayOfStr.length < 4) {
            ChatHandler.sendChat((Entity)sender, this.func_71518_a(par1ICommandSender), new Object[0]);
            return;
        }
        try {
            ArrayList<BattleParticipant> participants = new ArrayList<BattleParticipant>();
            ArrayList<EntityPixelmon> wildPixelmon = new ArrayList<EntityPixelmon>();
            for (int i = 0; i < par2ArrayOfStr.length; ++i) {
                if (par2ArrayOfStr[i].startsWith("lvl")) continue;
                Object part = this.getPart(par1ICommandSender, par2ArrayOfStr[i]);
                if (part == null) {
                    ChatHandler.sendChat((Entity)sender, "Participant " + (i + 1) + " was invalid. Please try again.", new Object[0]);
                    return;
                }
                if (part instanceof EntityPlayerMP) {
                    PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)part);
                    participants.add(new PlayerParticipant((EntityPlayerMP)part, storage.getFirstAblePokemon(((EntityPlayerMP)part).field_70170_p)));
                    continue;
                }
                if (!(part instanceof EntityPixelmon)) continue;
                if (i == 0) {
                    ChatHandler.sendChat((Entity)sender, "First participant must be a player.", new Object[0]);
                    return;
                }
                if (i + 1 < par2ArrayOfStr.length && par2ArrayOfStr[i + 1].startsWith("lvl")) {
                    int level = Integer.parseInt(par2ArrayOfStr[i + 1].replaceAll("[^0-9]", ""));
                    if (level > 0 && level <= 100) {
                        ((EntityPixelmon)((Object)part)).getLvl().setLevel(level);
                    } else {
                        ChatHandler.sendChat((Entity)sender, "pixelmon.command.general.cheater", new Object[0]);
                    }
                } else {
                    ((EntityPixelmon)((Object)part)).getLvl().setLevel(((PlayerParticipant)participants.get(0)).getHighestLevel());
                }
                wildPixelmon.add((EntityPixelmon)((Object)part));
                participants.add(new WildPixelmonParticipant((EntityPixelmon)((Object)part)));
            }
            EntityPlayerMP player = ((PlayerParticipant)participants.get((int)0)).player;
            for (int i = 0; i < wildPixelmon.size(); ++i) {
                EntityPixelmon p = (EntityPixelmon)((Object)wildPixelmon.get(i));
                p.aggression = Entity7HasAI.Aggression.passive;
                if (i == 0) {
                    p.func_70107_b(player.field_70165_t + 2.0, this.getTopEarthBlock(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70161_v).intValue(), player.field_70161_v);
                } else if (i == 1) {
                    p.func_70107_b(player.field_70165_t, this.getTopEarthBlock(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70161_v).intValue(), player.field_70161_v + 2.0);
                } else if (i == 2) {
                    p.func_70107_b(player.field_70165_t + 2.0, this.getTopEarthBlock(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70161_v).intValue(), player.field_70161_v + 2.0);
                }
                player.field_70170_p.func_72838_d((Entity)p);
            }
            ((PlayerParticipant)participants.get((int)0)).startedBattle = true;
            new BattleControllerBase(new BattleParticipant[]{participants.get(0) instanceof PlayerParticipant ? (PlayerParticipant)participants.get(0) : (WildPixelmonParticipant)participants.get(0), participants.get(1) instanceof PlayerParticipant ? (PlayerParticipant)participants.get(1) : (WildPixelmonParticipant)participants.get(1)}, new BattleParticipant[]{participants.get(2) instanceof PlayerParticipant ? (PlayerParticipant)participants.get(2) : (WildPixelmonParticipant)participants.get(2), participants.get(3) instanceof PlayerParticipant ? (PlayerParticipant)participants.get(3) : (WildPixelmonParticipant)participants.get(3)});
        }
        catch (PlayerNotLoadedException e) {
            System.out.println("Error loading player for command /pokebattle2 " + par2ArrayOfStr[0] + "  " + par2ArrayOfStr[1]);
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            ChatHandler.sendChat((Entity)sender, "Please provide a level!", new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Error loading player for command /pokebattle2 " + par2ArrayOfStr[0] + "  " + par2ArrayOfStr[1]);
            e.printStackTrace();
        }
    }

    public Integer getTopEarthBlock(World world, int cpX, int cpZ) {
        Chunk chunk = world.func_72938_d(cpX, cpZ);
        Integer k = null;
        k = Math.max(0, Math.min(chunk.func_76625_h() + 15, 255));
        while (k > 0) {
            Block block = world.func_147439_a(cpX, k.intValue(), cpZ);
            if (block != Blocks.field_150350_a && !world.func_147439_a(cpX, k.intValue(), cpZ).isFoliage((IBlockAccess)world, cpX, k.intValue(), cpZ)) {
                return k + 1;
            }
            k = k - 1;
        }
        return null;
    }

    private Object getPart(ICommandSender commandSender, String value) {
        if (EnumPokemon.hasPokemon(value)) {
            EntityPixelmon poke = (EntityPixelmon)PixelmonEntityList.createEntityByName(value, commandSender.func_130014_f_());
            return poke;
        }
        try {
            EntityPlayerMP player = Battle2.func_82359_c((ICommandSender)commandSender, (String)value);
            return player;
        }
        catch (PlayerNotFoundException e) {
            return null;
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        ArrayList<String> pokemon = new ArrayList<String>();
        if (args.length == 1) {
            return Battle2.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        if (args.length >= 2 && args.length <= 4) {
            for (EnumPokemon p : EnumPokemon.values()) {
                pokemon.add(p.name);
            }
            return Battle2.func_71530_a((String[])args, (String[])pokemon.toArray(new String[pokemon.size()]));
        }
        return null;
    }

    public int compareTo(Object arg0) {
        return 0;
    }
}

