/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.blocks.TileEntityCloningMachine;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonGen;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonOreDictionary;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.lang.reflect.Modifier;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class PixelmonConfig {
    public static final int MILLI = 1000;
    public static final int SECONDS = 1;
    public static final int MINUTES = 60;
    public static final int HOURS = 3600;
    public static boolean isInMetric = true;
    public static Configuration config;
    public static boolean allowNonPixelmonMobs;
    public static boolean allowCapturingOutsideBattle;
    public static boolean allowNicknames;
    public static boolean spawnStructures;
    public static boolean spinBattleCamera;
    public static boolean useCustomTabList;
    public static boolean spawnMysteryDungeons;
    public static boolean isAgressionAllowed;
    public static int maxNumLandPokemon;
    public static int maxNumWaterPokemon;
    public static int maxNumUndergroundPokemon;
    public static int maxNumAirPokemon;
    public static int trainerRarityModifier;
    public static int nameplateRangeModifier;
    public static boolean scaleModelsUp;
    public static boolean pokemonDropsEnabled;
    public static boolean allowRiding;
    public static boolean allowPlanting;
    public static boolean removeVanillaMusic;
    public static int idTrainers;
    public static int idPixelmon;
    public static int idPokeball;
    public static int idCamera;
    public static boolean allowPVPExperience;
    public static boolean allowTrainerExperience;
    public static boolean printErrors;
    public static boolean allowRareCandyCrafting;
    public static boolean allowAnvilAutoloading;
    public static boolean allowLegendariesSpawn;
    public static boolean doLegendaryEvent;
    public static int legendarySpawnRate;
    public static boolean Gen1;
    public static boolean Gen2;
    public static boolean Gen3;
    public static boolean Gen4;
    public static boolean Gen5;
    public static boolean Gen6;
    public static boolean giveStarter;
    public static boolean spawnHidden;
    public static boolean spawnNormal;
    public static boolean spawnGrotto;
    public static Rate spawnRate;
    public static Modes spawnMode;
    public static int lootTime;
    public static boolean writeEntitiesToWorld;
    public static boolean spawnBirdShrines;
    public static boolean spawnGemShrines;
    public static boolean reusableBirdShrines;
    public static boolean haveHM;
    public static boolean reuseTraders;
    public static boolean allowGemCrafting;
    public static boolean allowGemBossDrop;
    public static boolean afkHandlerOn;
    public static int afkTimerActivateSeconds;
    public static int afkTimerTurnSeconds;
    public static boolean useLowResTextures;
    public static boolean allowBreeding;
    public static boolean allowRandomSpawnedEggsToBeLegendary;
    public static boolean allowRandomBreedingEggsToBeLegendary;
    public static boolean allowRanchCreation;
    public static boolean useBattleDimension;
    public static boolean enableSmoothPokemonShading;
    public static boolean enableSmoothPokeballShading;
    public static int[] spawnDimensions;
    public static double renderDistanceWeight;
    public static float shinyRate;
    public static boolean allowWildPokemonFleeing;
    public static boolean statuesUseOriginalPokemonTextures;
    public static boolean opToUseSpawners;
    public static boolean bossesDropRanchUpgrades;
    public static boolean useBreedingEnvironment;
    public static int numBreedingLevels;
    public static int stepsPerEggCycle;
    public static int breedingTicks;
    public static boolean allowRanchExpansion;
    public static boolean showTarget;
    public static boolean bossDropIsisHourglass;
    public static boolean despawnOnFleeOrLoss;
    public static boolean enablePointToSteer;
    public static boolean saveToDatabase;
    public static boolean allowExternalMoves;

    public static void loadConfig(Configuration configuration) {
        config = configuration;
        PixelmonBlocks.load(config);
        PixelmonItems.load(config);
        config.addCustomCategoryComment("general", "General settings for the world");
        Property propWildPokemonFlee = config.get("general", "Wild pokemon can try and flee from battles", false);
        allowWildPokemonFleeing = propWildPokemonFlee.getBoolean(false);
        propWildPokemonFlee.comment = "Wild pokemon will have a chance based on unfavourable battle conditions to try and flee from battle";
        Property propSpinBattleCamera = config.get("general", "Spin Battle Camera", true);
        spinBattleCamera = propSpinBattleCamera.getBoolean(true);
        propSpinBattleCamera.comment = "Battle camera rotates around player if true, and is stationary if false";
        Property propSpawnStructures = config.get("general", "Allow Structures to Spawn", true);
        spawnStructures = propSpawnStructures.getBoolean(true);
        propSpawnStructures.comment = "Allow random generation of structures such as Pokecenters, Shrines, and other buildings if true";
        if (spawnMysteryDungeons) {
            PixelmonGen.load(config);
        }
        Property propAllowNicknames = config.get("general", "Allow pokemon nicknames", true);
        allowNicknames = propAllowNicknames.getBoolean(true);
        propAllowNicknames.comment = "Allow the player to nickname pokemon (not a server-wide setting, just a client setting)";
        Property propAllowAnvilAutoloading = config.get("general", "Allow anvil autoreloading", false);
        allowAnvilAutoloading = propAllowAnvilAutoloading.getBoolean(false);
        propAllowAnvilAutoloading.comment = "Allow the anvil to replace finished items with starting item from player's inventory without manual placing";
        Property propAllowNonPixelmonMobs = config.get("general", "Allow vanilla mobs", false);
        allowNonPixelmonMobs = propAllowNonPixelmonMobs.getBoolean(false);
        propAllowNonPixelmonMobs.comment = "Allow creepers, skeletons, etc to spawn in the world - DANGER can kill you while battling";
        Property propAllowCapturingOutsideBattle = config.get("general", "Allow Capturing Outside of Battle", true);
        allowCapturingOutsideBattle = propAllowCapturingOutsideBattle.getBoolean(true);
        propAllowCapturingOutsideBattle.comment = "Allow player to throw pokeballs from hotbar, if false pokeballs can only be thrown in battles";
        Property propTrainerRarityModifier = config.get("general", "Trainer Rarity (percentage 0-200)", 50);
        trainerRarityModifier = propTrainerRarityModifier.getInt(50);
        propTrainerRarityModifier.comment = "Sets Trainer Rarity, higher values spawn trainers more often, 0 spawns no trainers";
        Property propNameplateRangeModifier = config.get("general", "Nameplate Visible Range Modifier (1=default, 2=farther, 3=far)", 1);
        nameplateRangeModifier = propNameplateRangeModifier.getInt(1);
        propNameplateRangeModifier.comment = "Sets how far pixelmon names and levels can be seen from (client setting only)";
        Property propScaleModelsUp = config.get("general", "Scale Models Up", true);
        scaleModelsUp = propScaleModelsUp.getBoolean(true);
        propScaleModelsUp.comment = "Increases Size of Pixelmon Models in Game by 30%";
        Property propPokemonDropsEnabled = config.get("general", "Pokemon Drops Enabled", true);
        pokemonDropsEnabled = propPokemonDropsEnabled.getBoolean(true);
        propPokemonDropsEnabled.comment = "Allows wild pokemon to drop items like feathers, etc on death";
        Property propRemoveVanillaMusic = config.get("general", "Remove Minecraft Music", true);
        removeVanillaMusic = propRemoveVanillaMusic.getBoolean(true);
        propRemoveVanillaMusic.comment = "Removes regular minecraft music so only Pixelmon music plays (Currently locked to true in code)";
        Property propPrintErrors = config.get("general", "Print Errors", false);
        printErrors = propPrintErrors.getBoolean(false);
        propPrintErrors.comment = "Prints more detailed error messages to the server.log file if enabled";
        Property propAllowRiding = config.get("general", "Allow Riding", true);
        allowRiding = propAllowRiding.getBoolean(true);
        propAllowRiding.comment = "Allow players to ride pokemon. If false no pokemon can be ridden. (Server side option)";
        Property propAllowPlanting = config.get("general", "Allow Planting", true);
        allowPlanting = propAllowPlanting.getBoolean(true);
        propAllowPlanting.comment = "Allow players to plant apricorns/berries in the ground";
        Property propAllowPVPExperience = config.get("general", "Allow PVP Experience", true);
        allowPVPExperience = propAllowPVPExperience.getBoolean(true);
        propAllowPVPExperience.comment = "Determines if player vs player battles give pokemon experience, no EXP gain in PVP when false";
        Property propAllowTrainerExperience = config.get("general", "Allow Trainer Experience", true);
        allowTrainerExperience = propAllowTrainerExperience.getBoolean(true);
        propAllowTrainerExperience.comment = "Determines if player vs trainer battles give pokemon experience, no EXP gain in trainer battles when false";
        Property propIsAggressionAllowed = config.get("general", "Wild Pokemon initiate battles", true);
        isAgressionAllowed = propIsAggressionAllowed.getBoolean(true);
        propIsAggressionAllowed.comment = "Allows some wild pokemon to aggro on player and force battles, no forced battles when false";
        Property propAllowRareCandyCrafting = config.get("general", "Allow Crafting of Rare Candy", true);
        allowRareCandyCrafting = propAllowRareCandyCrafting.getBoolean(true);
        propAllowRareCandyCrafting.comment = "Allows players to make rare candies by crafting (Serverside option)";
        Property propWriteEntitiesToWorld = config.get("general", "Write Entities To World Save", false);
        writeEntitiesToWorld = propWriteEntitiesToWorld.getBoolean(false);
        propWriteEntitiesToWorld.comment = "Saves Pixelmon entities to file when world saves (greatly increases savefile size and save time if true";
        Property propSpawnBirdShrines = config.get("general", "Spawn Bird Shrines", true);
        spawnBirdShrines = propSpawnBirdShrines.getBoolean(true);
        propSpawnBirdShrines.comment = "Allow Legendary Bird Shrines to Spawn Randomly in World";
        Property propSpawnGemShrines = config.get("general", "Spawn Gem Shrines", false);
        spawnGemShrines = propSpawnGemShrines.getBoolean(false);
        propSpawnGemShrines.comment = "Allow Haunted Jeweler Gem Shrines to Spawn Randomly in World";
        Property propReusableBirdShrines = config.get("general", "Bird Shrines are reusable", false);
        reusableBirdShrines = propReusableBirdShrines.getBoolean(false);
        propReusableBirdShrines.comment = "Set legendary shrines to one use (false) or multiple use (true)";
        Property propOpToUseSpawners = config.get("general", "Must be opped to use spawners", true);
        opToUseSpawners = propOpToUseSpawners.getBoolean(true);
        propOpToUseSpawners.comment = "If true must be opped, if false must be in creative mode";
        Property propHaveHM = config.get("general", "Have HM To Ride", false);
        haveHM = propHaveHM.getBoolean(false);
        propHaveHM.comment = "Requires HM move Fly or HM move Surf on a pokemon to be able to ride it";
        Property propEnableCloningMachine = config.get("general", "Cloning Machines Enabled", true);
        TileEntityCloningMachine.enabled = propEnableCloningMachine.getBoolean(true);
        propEnableCloningMachine.comment = "Allow Players to use Cloning Machines to clone Mew to Mewtwo";
        Property propReusableTraders = config.get("general", "Traders are reusable", false);
        reuseTraders = propReusableTraders.getBoolean(false);
        propReusableTraders.comment = "Set Traders to one use (false) or multiple use (true)";
        Property propAllowGemCrafting = config.get("general", "Allow Gems to be crafted", true);
        allowGemCrafting = propAllowGemCrafting.getBoolean(true);
        propAllowGemCrafting.comment = "Allows the 18 types of Gems to be crafted by players";
        Property propAllowGemBossDrop = config.get("general", "Allow Gem Boss Drop", false);
        allowGemBossDrop = propAllowGemBossDrop.getBoolean(false);
        propAllowGemBossDrop.comment = "Allows the 18 types of Gems to be dropped by bosses";
        Property propAllowRanchUpgradeBossDrop = config.get("general", "Allow Ranch Upgrade Boss Drop", true);
        bossesDropRanchUpgrades = propAllowRanchUpgradeBossDrop.getBoolean(false);
        propAllowRanchUpgradeBossDrop.comment = "Permits bosses to drop ranch area upgrades";
        Property propCustomTabList = config.get("general", "Use the Custom Tab List", true);
        useCustomTabList = propCustomTabList.getBoolean(true);
        propCustomTabList.comment = "Allows you to toggle which tab list you would like to use";
        Property propGiveStarter = config.get("general", "Give a starter on join", true);
        giveStarter = propGiveStarter.getBoolean(true);
        propGiveStarter.comment = "Lets you choose to give/not give a starter to a player on join (via the pixelmon starter screen)";
        Property propIsisHourglass = config.get("general", "Let bosses drop Isi's hourglass", true);
        bossDropIsisHourglass = propIsisHourglass.getBoolean(false);
        propIsisHourglass.comment = "Isi's hourglass is an item that lets you skip stages of breeding";
        Property propDisablePointToSteer = config.get("general", "Enable point to steer", true);
        enablePointToSteer = propDisablePointToSteer.getBoolean(true);
        propDisablePointToSteer.comment = "When mounted enables steering the pixelmon by looking";
        config.addCustomCategoryComment("IDs", "Entity IDs for Pixelmon Entities (DO NOT CHANGE, unless you know what you are doing)");
        idTrainers = config.get("IDs", "Trainer ID", 199).getInt(199);
        idPixelmon = config.get("IDs", "Pixelmon ID", 200).getInt(200);
        idPokeball = config.get("IDs", "Pokeball ID", 201).getInt(201);
        idCamera = config.get("IDs", "Camera ID", 202).getInt(202);
        config.addCustomCategoryComment("Spawning", "Settings that control what Pixelmon spawn and how many spawn");
        Property propSpawningDimensions = config.get("Spawning", "Dimensions Pokemon will spawn in", new int[]{0});
        spawnDimensions = propSpawningDimensions.getIntList();
        propSpawningDimensions.comment = "This lets you choose which dimensions the pixelmon spawner will operate in";
        Property propShinyRate = config.get("Spawning", "Shiny spawn rate", 8192);
        shinyRate = propShinyRate.getInt();
        propShinyRate.comment = "Shiny calculation uses 1/(shiny rate) to get odds of becoming shiny";
        Property propAllowLegendariesSpawn = config.get("Spawning", "Allow Legendaries to spawn", true);
        allowLegendariesSpawn = propAllowLegendariesSpawn.getBoolean(true);
        propAllowLegendariesSpawn.comment = "Allow wild legendaries to spawn (besides specific event spawns)";
        Property propDoLegendaryEvent = config.get("Spawning", "Display global message on legendary spawn", true);
        doLegendaryEvent = propDoLegendaryEvent.getBoolean(true);
        propDoLegendaryEvent.comment = "Displays server-wide announcement 'A Legendary Has Spawned in <name> Biome' when legendary spawns";
        Property propLegendarySpawnRate = config.get("Spawning", "Legendary Spawn Rate", 22000);
        legendarySpawnRate = propLegendarySpawnRate.getInt(22000);
        propLegendarySpawnRate.comment = "Sets odds of Legendary Spawning (1 in X spawns), higher values spawn wild legendaries less often";
        Property propGen1 = config.get("Spawning", "Gen1", true);
        Gen1 = propGen1.getBoolean(true);
        propGen1.comment = "Sets whether Generation 1 Pixelmon will be spawned or not (Pokedex 1-151)";
        Property propGen2 = config.get("Spawning", "Gen2", true);
        Gen2 = propGen2.getBoolean(true);
        propGen2.comment = "Sets whether Generation 2 Pixelmon will be spawned or not (Pokedex 152-251)";
        Property propGen3 = config.get("Spawning", "Gen3", true);
        Gen3 = propGen3.getBoolean(true);
        propGen3.comment = "Sets whether Generation 3 Pixelmon will be spawned or not (Pokedex 252-386)";
        Property propGen4 = config.get("Spawning", "Gen4", true);
        Gen4 = propGen4.getBoolean(true);
        propGen4.comment = "Sets whether Generation 4 Pixelmon will be spawned or not (Pokedex 387-493)";
        Property propGen5 = config.get("Spawning", "Gen5", true);
        Gen5 = propGen5.getBoolean(true);
        propGen5.comment = "Sets whether Generation 5 Pixelmon will be spawned or not (Pokedex 494-649)";
        Property propGen6 = config.get("Spawning", "Gen6", true);
        Gen6 = propGen6.getBoolean(true);
        propGen6.comment = "Sets whether Generation 6 Pixelmon will be spawned or not (Pokedex 650-719)";
        Property propMaxNumLandPokemon = config.get("Spawning", "Max number of Land Pokemon (at one time)", 40);
        maxNumLandPokemon = propMaxNumLandPokemon.getInt(40);
        propMaxNumLandPokemon.comment = "Sets max number of land pokemon in world at a time (higher numbers = more spawns)";
        Property propMaxNumUndergroundPokemon = config.get("Spawning", "Max number of Underground Pokemon (at one time)", 20);
        maxNumUndergroundPokemon = propMaxNumUndergroundPokemon.getInt(20);
        propMaxNumUndergroundPokemon.comment = "Sets max number of underground pokemon in world at a time (higher numbers = more spawns)";
        Property propMaxNumWaterPokemon = config.get("Spawning", "Max number of Water Pokemon (at one time)", 20);
        maxNumWaterPokemon = propMaxNumWaterPokemon.getInt(20);
        propMaxNumWaterPokemon.comment = "Sets max number of water pokemon in world at a time (higher numbers = more spawns)";
        Property propMaxNumAirPokemon = config.get("Spawning", "Max number of Air Pokemon (at one time)", 2);
        maxNumAirPokemon = propMaxNumAirPokemon.getInt(3);
        propMaxNumAirPokemon.comment = "Sets max number of flying pokemon in world at a time (higher numbers = more spawns) (KEEP THIS LOW)";
        Property propDespawnOnFleeOrLoss = config.get("Spawning", "Despawn on Flee or Loss", false);
        despawnOnFleeOrLoss = propDespawnOnFleeOrLoss.getBoolean(false);
        propDespawnOnFleeOrLoss.comment = "Forces wild pokemon to despawn after a battle";
        config.addCustomCategoryComment("PokeLoot", "Settings for controlling pokeloot chest spawns and behavior");
        Property propSpawnNormal = config.get("PokeLoot", "Normal PokeChest - Enabled", true);
        spawnNormal = propSpawnNormal.getBoolean(true);
        propSpawnNormal.comment = "Allows normal visible pokechests to spawn around the world randomly";
        Property propSpawnHidden = config.get("PokeLoot", "Hidden PokeChest - Enabled", true);
        spawnHidden = propSpawnHidden.getBoolean(true);
        propSpawnHidden.comment = "Allows invisible pokechests to spawn around the world randomly";
        Property propSpawnGrotto = config.get("PokeLoot", "Hidden Grotto -  Enabled", true);
        spawnGrotto = propSpawnGrotto.getBoolean(true);
        propSpawnGrotto.comment = "Allow Hidden Grottos to spawn in the world";
        Property propSpawnRate = config.get("PokeLoot", "Chest Spawn Rate (Minimal=0,Normal=1,More=2,Extreme=3)", Rate.NORMAL.ordinal());
        spawnRate = Rate.values()[propSpawnRate.getInt()];
        propSpawnRate.comment = "Sets the frequency of chests spawning in world (to disable completely use the '- Enabled' config settings)\nMinimal ~ 1 per 64 chunks, Normal ~ 1 per 32 chunks, More ~ 1 per 18 chunks, Extreme ~ 1 per 10 chunks";
        Property propSpawnMod = config.get("PokeLoot", "Default Spawn Mode (FCFS=0, PL1D=1, PUD=2, TIMED=3)", Modes.FCFS.ordinal());
        spawnMode = Modes.values()[propSpawnMod.getInt()];
        propSpawnMod.comment = "Sets the Mode of all randomly spawned pokeloot chests\nFCFS = First Come First Serve, only one player can loot chest, then chests vanishes\nPL1D = Player 1 Drop, chest gives one drop per person, chest remains for others to use once each\nPUD = Player Unlimited Drops, chests can be used infinitely by all players\nTIMED = Each player allowed to loot again after specified time interval (individual timers), chest remains after looting";
        Property propLootTime = config.get("PokeLoot", "Timed Loot (seconds)", lootTime);
        lootTime = propLootTime.getInt();
        propLootTime.comment = "Sets Frequency that a player can reuse a timed loot chest (both placed in creative and naturally spawned, if set to TIMED\nTime Conversions: One Hour = 3600 seconds, One Day = 86400 seconds, One Week = 604800 seconds";
        config.addCustomCategoryComment("AFKHandler", "Settings for controlling autobattler for AFK players");
        Property propAfkHandlerOn = config.get("AFKHandler", "AFK Handler Active", false);
        afkHandlerOn = propAfkHandlerOn.getBoolean(false);
        propAfkHandlerOn.comment = "Have autobattle take over if player is AFK during a battle, activates after specified time period and gives specified time for each turn after that";
        Property propAfkTimerActivateSeconds = config.get("AFKHandler", "AFK Activation Time Length", 90);
        afkTimerActivateSeconds = propAfkTimerActivateSeconds.getInt(90);
        propAfkTimerActivateSeconds.comment = "Sets the time (in seconds) before a player in battle is declared to be AFK and the autobattle code takes over for them";
        Property propAfkTimerTurnSeconds = config.get("AFKHandler", "AFK Activation Turn Time", 15);
        afkTimerTurnSeconds = propAfkTimerTurnSeconds.getInt(15);
        propAfkTimerTurnSeconds.comment = "Sets the time (in seconds) that the autobattle code allows for AFK player to move once autobattle is active, before selecting a move itself";
        config.addCustomCategoryComment("graphics", "Graphics Settings");
        Property propRenderDistance = config.get("graphics", "Render Distance Weight", 2.0);
        renderDistanceWeight = propRenderDistance.getDouble(2.0);
        propRenderDistance.comment = "Multiplier of the 64 distance usually used for rendering";
        Property propUseLowResTex = config.get("graphics", "Use low-res Textures", false);
        useLowResTextures = propUseLowResTex.getBoolean(false);
        propUseLowResTex.comment = "Use the low-res (256x256) pokemon and pokeball textures";
        Property propSmoothShadePokeballs = config.get("graphics", "Enable smooth shading for pokeballs", true);
        enableSmoothPokeballShading = propSmoothShadePokeballs.getBoolean(true);
        propSmoothShadePokeballs.comment = "Use the smd normal maps for shading pokeballs";
        Property propSmoothShadePokemon = config.get("graphics", "Enable smooth shading for pokemon", true);
        enableSmoothPokemonShading = propSmoothShadePokemon.getBoolean(true);
        propSmoothShadePokemon.comment = "Use the smd normal maps for shading pokemon";
        Property propKeepStatuePokemonTexture = config.get("graphics", "Use original pokemon textures for statues", false);
        statuesUseOriginalPokemonTextures = propKeepStatuePokemonTexture.getBoolean(false);
        propKeepStatuePokemonTexture.comment = "Use original pokemon textures for statues";
        Property propShowTargetOverlay = config.get("graphics", "Show current attack target", true);
        showTarget = propShowTargetOverlay.getBoolean(true);
        propShowTargetOverlay.comment = "Display the currently selected pokemon's attack target on the screen";
        config.addCustomCategoryComment("Breeding", "Settings for breeding behavior");
        Property propAllowBreeding = config.get("Breeding", "Allow placing of ranch blocks", true);
        allowBreeding = propAllowBreeding.getBoolean(true);
        propAllowBreeding.comment = "If disabled, prevents placing of ranch blocks, preventing breeding from occuring";
        Property propAllowRandomBreedingEggsToBeLegendary = config.get("Breeding", "Allow random BREEDING eggs to have a chance to be a legendary", false);
        allowRandomBreedingEggsToBeLegendary = propAllowRandomBreedingEggsToBeLegendary.getBoolean(false);
        propAllowRandomBreedingEggsToBeLegendary.comment = "If enabled, random eggs from ditto-ditto breeding might contain legendaries.";
        Property propAllowRandomSpawnedEggsToBeLegendary = config.get("Breeding", "Allow random SPAWNED eggs to have a chance to be a legendary", false);
        allowRandomSpawnedEggsToBeLegendary = propAllowRandomSpawnedEggsToBeLegendary.getBoolean(false);
        propAllowRandomSpawnedEggsToBeLegendary.comment = "If enabled, random eggs from /pokegiveEgg might contain legendaries.";
        Property propAllowRanchCreation = config.get("Breeding", "Allow crafting of Ranch Blocks", true);
        allowRanchCreation = propAllowRanchCreation.getBoolean(true);
        propAllowRanchCreation.comment = "If disabled, prevents crafting of Ranch Blocks";
        Property propUseBreedingEnvironments = config.get("Breeding", "Use breeding environments", true);
        useBreedingEnvironment = propUseBreedingEnvironments.getBoolean(true);
        propUseBreedingEnvironments.comment = "Control speed of breeding based on the blocks set in the area, if false will set breeding speed to 1.0x";
        Property propStepsPerEggCycle = config.get("Breeding", "Steps per egg cycle", 255);
        stepsPerEggCycle = propStepsPerEggCycle.getInt(255);
        propStepsPerEggCycle.comment = "Sets the number of steps per egg cycle, lower numbers hatch eggs faster";
        Property propNumBreedingLevels = config.get("Breeding", "Number of breeding levels", 5);
        numBreedingLevels = propNumBreedingLevels.getInt(5);
        propNumBreedingLevels.comment = "Number of stages to go through before breeding occurs (1-5)";
        Property propTicksForBreedingCheck = config.get("Breeding", "World ticks till breeding level increased", 18000);
        breedingTicks = propTicksForBreedingCheck.getInt(18000);
        propTicksForBreedingCheck.comment = "Number of ticks till the breeding level goes up by 1";
        Property propAllowRanchExpansion = config.get("Breeding", "Allow ranch expansion", true);
        allowRanchExpansion = propAllowRanchExpansion.getBoolean(true);
        propAllowRanchExpansion.comment = "Disabling this will remove the ranch expansion item from the game";
        config.save();
        PixelmonItems.registerItems();
        PixelmonBlocks.registerBlocks();
        PixelmonEntityList.registerEntities();
        PixelmonEntityList.addSpawns();
        PixelmonOreDictionary.registerOreDict();
    }

    public static void removeSpawns() {
        if (!allowNonPixelmonMobs) {
            for (Integer i : EntityList.field_75623_d.keySet()) {
                Class c1 = (Class)EntityList.field_75623_d.get(i);
                if (EntityPixelmon.class.isAssignableFrom(c1) || EntityTrainer.class.isAssignableFrom(c1) || !EntityLiving.class.isAssignableFrom(c1) || Modifier.isAbstract(c1.getModifiers())) continue;
                Class c3 = c1;
                int maxNonNullBiomes = 0;
                for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                    if (biome == null) continue;
                    ++maxNonNullBiomes;
                }
                int nextBiome = 0;
                BiomeGenBase[] biomes = new BiomeGenBase[maxNonNullBiomes];
                for (BiomeGenBase biomeGenBase : BiomeGenBase.func_150565_n()) {
                    if (biomeGenBase == null) continue;
                    biomes[nextBiome++] = biomeGenBase;
                }
                for (BiomeGenBase biomeGenBase : EnumCreatureType.values()) {
                    EntityRegistry.removeSpawn((Class)c3, (EnumCreatureType)biomeGenBase, (BiomeGenBase[])biomes);
                }
            }
        }
    }

    static {
        allowCapturingOutsideBattle = true;
        allowNicknames = true;
        spawnStructures = true;
        spinBattleCamera = true;
        useCustomTabList = true;
        spawnMysteryDungeons = false;
        isAgressionAllowed = true;
        pokemonDropsEnabled = true;
        allowRiding = true;
        allowPlanting = true;
        removeVanillaMusic = true;
        idTrainers = 199;
        idPixelmon = 200;
        idPokeball = 201;
        idCamera = 202;
        allowPVPExperience = true;
        allowTrainerExperience = true;
        printErrors = false;
        allowRareCandyCrafting = false;
        allowAnvilAutoloading = false;
        allowLegendariesSpawn = true;
        doLegendaryEvent = true;
        legendarySpawnRate = 25000;
        Gen1 = true;
        Gen2 = true;
        Gen3 = true;
        Gen4 = true;
        Gen5 = true;
        Gen6 = true;
        giveStarter = true;
        spawnHidden = true;
        spawnNormal = true;
        spawnGrotto = true;
        spawnRate = Rate.NORMAL;
        spawnMode = Modes.FCFS;
        lootTime = 86400;
        writeEntitiesToWorld = false;
        spawnBirdShrines = true;
        spawnGemShrines = false;
        reusableBirdShrines = false;
        haveHM = false;
        reuseTraders = false;
        allowGemCrafting = true;
        allowGemBossDrop = false;
        afkHandlerOn = false;
        afkTimerActivateSeconds = 90;
        afkTimerTurnSeconds = 15;
        useLowResTextures = false;
        allowBreeding = true;
        allowRandomSpawnedEggsToBeLegendary = false;
        allowRandomBreedingEggsToBeLegendary = false;
        allowRanchCreation = true;
        useBattleDimension = false;
        enableSmoothPokemonShading = true;
        enableSmoothPokeballShading = false;
        spawnDimensions = new int[]{0};
        renderDistanceWeight = 2.0;
        shinyRate = 8192.0f;
        allowWildPokemonFleeing = false;
        statuesUseOriginalPokemonTextures = false;
        opToUseSpawners = true;
        bossesDropRanchUpgrades = true;
        useBreedingEnvironment = true;
        numBreedingLevels = 5;
        stepsPerEggCycle = 255;
        breedingTicks = 18000;
        allowRanchExpansion = true;
        showTarget = true;
        bossDropIsisHourglass = true;
        despawnOnFleeOrLoss = false;
        enablePointToSteer = true;
        saveToDatabase = false;
        allowExternalMoves = false;
    }

    public static enum Modes {
        FCFS,
        PL,
        PU,
        TIMED;

    }

    public static enum Rate {
        MINIMAL,
        NORMAL,
        MORE,
        EXTREME;

    }
}

