/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.DatabaseTrainers;
import com.pixelmonmod.pixelmon.entities.custom.EntityClaw;
import com.pixelmonmod.pixelmon.entities.npcs.EntityDoctor;
import com.pixelmonmod.pixelmon.entities.npcs.EntityHalloween;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrader;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumTrainers;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PixelmonEntityList {
    public static EntityLiving createEntityByName(String par0Str, World par1World) {
        Object entity = null;
        try {
            ClassType type = null;
            if (EnumPokemon.hasPokemonAnyCase(par0Str)) {
                type = ClassType.Pixelmon;
                par0Str = EnumPokemon.getFromNameAnyCase((String)par0Str).name;
            }
            if (type == ClassType.Pixelmon) {
                entity = new EntityPixelmon(par1World);
                entity.init(par0Str);
            } else if (EnumTrainers.hasTrainer(par0Str)) {
                par0Str = EnumTrainers.get(par0Str);
                entity = new EntityTrainer(par1World);
                ((EntityTrainer)entity).init(par0Str);
            } else {
                NPCType npcType = NPCType.get(par0Str);
                entity = npcType == NPCType.Doctor ? new EntityDoctor(par1World) : (npcType == NPCType.Trader ? new EntityTrader(par1World) : new EntityTrainer(par1World));
                ((EntityNPC)((Object)entity)).init(par0Str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound par0NBTTagCompound, World par1World) {
        EntityLiving var2 = null;
        try {
            Class<EntityPixelmon> var3 = EntityPixelmon.class;
            if (var3 != null) {
                var2 = (EntityLiving)var3.getConstructor(World.class).newInstance(par1World);
                ((EntityPixelmon)var2).init(par0NBTTagCompound.func_74779_i("Name"));
            }
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        if (var2 != null) {
            var2.func_70020_e(par0NBTTagCompound);
        } else if (PixelmonConfig.printErrors) {
            System.out.println("Skipping Entity with id " + par0NBTTagCompound.func_74779_i("id"));
        }
        return var2;
    }

    public static void registerEntities() {
        EntityRegistry.registerModEntity(EntityTrainer.class, (String)"Trainer", (int)PixelmonConfig.idTrainers, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityHalloween.class, (String)"Hallwoeen", (int)3575, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityTrader.class, (String)"Trader", (int)3574, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityPixelmon.class, (String)"Pixelmon", (int)PixelmonConfig.idPixelmon, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityStatue.class, (String)"Statue", (int)203, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityClaw.class, (String)"Claw", (int)3576, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
    }

    public static void addSpawns() {
        String name;
        HashMap<String, String> hashmap = new HashMap<String, String>();
        System.out.println("[PIXELMON] Registering entity spawns");
        for (EnumPokemon enumPokemon : EnumPokemon.values()) {
            name = enumPokemon.name;
            SpawnRegistry.getGenerationInfo(hashmap, enumPokemon.name);
        }
        for (Enum enum_ : EnumTrainers.values()) {
            name = enum_.toString();
            int rarity = DatabaseTrainers.getRarity(name);
            double rardbl = rarity;
            rarity = (int)(rardbl *= (double)PixelmonConfig.trainerRarityModifier / 100.0);
            if (rarity < 1) continue;
            SpawnRegistry.addNPCSpawn(name, rarity, ClassType.Trainer);
        }
    }

    public static enum ClassType {
        Trainer,
        Pixelmon;

    }
}

