/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.spawning.spawners.SpawnerBase;
import com.pixelmonmod.pixelmon.util.ChancedWrapper;
import com.pixelmonmod.pixelmon.worldGeneration.biome.BiomeGenMysteryValley;
import com.pixelmonmod.pixelmon.worldGeneration.layer.InfiltratorGenLayer;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

public class PixelmonGen {
    public static TreeMap<Integer, Collection<ChancedWrapper<BiomeGenBase>>> rareBiomes = new TreeMap();
    public static int mysteryValleyId;
    public static int mysteryValleyEdgeId;
    public static int structuresBitmaskMV;
    public static boolean mysteryValleyTryout;
    public static BiomeGenMysteryValley mysteryValley;
    public static BiomeGenBase mysteryValleyEdge;

    public static void load(Configuration configuration) {
    }

    public static void register() {
        BiomeDictionary.registerBiomeType((BiomeGenBase)mysteryValley, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.registerBiomeType((BiomeGenBase)mysteryValleyEdge, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL});
        PixelmonGen.registerRareBiome(mysteryValley, 0.5f, BiomeGenBase.field_76767_f, BiomeGenBase.field_76780_h);
        SpawnerBase.register(mysteryValley);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)InfiltratorGenLayer.INSTANCE);
    }

    private static int loadBiomeID(Configuration configuration, String key, int defaultValue) {
        int result = configuration.get("WorldGen", key, defaultValue).getInt(defaultValue);
        if (result > 255 || result < 23) {
            throw new IllegalArgumentException("Error Initializing Biome: " + key + "! Expected a Biome ID between 23 & 255 (inclusive), but instead got '" + result + "'! Check the \"Biomes\" section in \"Pixelmon.cfg\" to fix this.");
        }
        return result;
    }

    public static void registerRareBiome(BiomeGenBase biome, float percentageChance, BiomeGenBase ... replaceThese) {
        for (int i = 0; i < replaceThese.length; ++i) {
            BiomeGenBase replace = replaceThese[i];
            if (rareBiomes.get(replace.field_76756_M) == null) {
                rareBiomes.put(replace.field_76756_M, new HashSet());
            }
            rareBiomes.get(replace.field_76756_M).add(new ChancedWrapper<BiomeGenBase>(biome, percentageChance));
        }
    }

    public static void postStructureInit() {
        if (mysteryValley != null) {
            mysteryValley.initStructures();
        }
    }

    static {
        structuresBitmaskMV = 0;
    }
}

