/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemHM;
import com.pixelmonmod.pixelmon.items.ItemTM;
import cpw.mods.fml.common.registry.GameRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;

public class PixelmonItemsTMs {
    public static ArrayList<Item> TMs = new ArrayList();
    public static ArrayList<Item> HMs = new ArrayList();

    public static void load(Configuration cfg) {
        System.out.println("PIXELMON: Loading TM/HMs");
        try {
            ItemTM item;
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from MOVES where TMID IS NOT NULL ORDER BY TMID");
            while (rs.next()) {
                try {
                    item = new ItemTM(rs.getString("NAME"), rs.getInt("TMID"), EnumType.parseTypeFromDBID(rs.getInt("TYPEID")), false);
                    Pixelmon.proxy.registerBossDropItem(item);
                    TMs.add(item);
                }
                catch (Exception e) {
                    System.out.println("Problem loading TMs");
                }
            }
            rs = stat.executeQuery("select * from MOVES where HMID IS NOT NULL ORDER BY HMID");
            while (rs.next()) {
                try {
                    item = new ItemHM(rs.getString("NAME"), rs.getInt("HMID"), EnumType.parseTypeFromDBID(rs.getInt("TYPEID")));
                    HMs.add(item);
                }
                catch (Exception e) {
                    System.out.println("Problem loading HMs");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerItems() {
        for (Item item : TMs) {
            GameRegistry.registerItem((Item)item, (String)ItemTM.getItemName(((ItemTM)item).index, ((ItemTM)item).attackName, false).replace(" ", "_"), (String)"pixelmon");
        }
        for (Item item : HMs) {
            GameRegistry.registerItem((Item)item, (String)ItemHM.getItemName(((ItemHM)item).index, ((ItemHM)item).attackName, true).replace(" ", "_"), (String)"pixelmon");
        }
    }
}

