/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.database;

import com.pixelmonmod.pixelmon.Pixelmon;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.minecraft.util.ResourceLocation;

public class DatabaseHelper {
    static Connection con;
    static boolean madeConnection;
    static String databasePath;
    static ResourceLocation databaseLoc;
    static ResourceLocation driverLoc;

    public static Connection getConnection() {
        try {
            File updateDatabaseDir;
            File databaseFile;
            File databaseLockFile;
            File databaseDir;
            if (madeConnection && !con.isClosed()) {
                return con;
            }
            if (databasePath == null) {
                databasePath = Pixelmon.modDirectory + "/database/";
            }
            if (!(databaseDir = new File(Pixelmon.modDirectory + "/database")).isDirectory()) {
                System.out.println("Creating database directory");
                databaseDir.mkdir();
            }
            if ((databaseLockFile = new File(databasePath + "Pixelmon2.lock.db")).exists()) {
                databaseLockFile.delete();
            }
            if ((databaseFile = new File(databasePath + "Pixelmon2.h2.db")).exists()) {
                databaseFile.delete();
            }
            if ((updateDatabaseDir = new File(Pixelmon.modDirectory + "/customdatabase/")).exists() && new File(updateDatabaseDir, "Pixelmon2.h2.db").exists()) {
                databasePath = Pixelmon.modDirectory + "/customdatabase/";
            } else {
                DatabaseHelper.copyDatabaseFromJar();
            }
            if (!new File(databasePath + "h2-1.3.173.jar").exists()) {
                DatabaseHelper.copyDriverFromJar();
            }
            ((ModClassLoader)Loader.instance().getModClassLoader()).addFile(new File(databasePath + "h2-1.3.173.jar"));
            System.out.println("Loading Database Driver");
            Class.forName("org.h2.Driver");
            System.out.println("Establishing Connection");
            con = DriverManager.getConnection("jdbc:h2:file:" + databasePath + "Pixelmon2;MVCC=true;ACCESS_MODE_DATA=r");
            madeConnection = true;
            return con;
        }
        catch (Exception e) {
            System.out.println("Could not get a connection to database");
            e.printStackTrace();
            return null;
        }
    }

    private static void copyDatabaseFromJar() {
        try {
            System.out.println("Extracting database");
            InputStream iStream = DatabaseHelper.class.getResourceAsStream("/assets/pixelmon/database/Pixelmon2.h2.db");
            FileOutputStream fos = null;
            fos = new FileOutputStream(databasePath + "Pixelmon2.h2.db");
            byte[] buf = new byte[2048];
            int r = iStream.read(buf);
            while (r != -1) {
                fos.write(buf, 0, r);
                r = iStream.read(buf);
            }
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to extract database");
        }
    }

    private static void copyDriverFromJar() {
        try {
            System.out.println("Extracting driver");
            InputStream iStream2 = DatabaseHelper.class.getResourceAsStream("/assets/pixelmon/database/h2-1.3.173.jar");
            FileOutputStream fos2 = null;
            fos2 = new FileOutputStream(databasePath + "h2-1.3.173.jar");
            byte[] buf = new byte[2048];
            int r = iStream2.read(buf);
            while (r != -1) {
                fos2.write(buf, 0, r);
                r = iStream2.read(buf);
            }
            if (fos2 != null) {
                fos2.close();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to extract driver");
        }
    }

    public static Statement getStatement(Connection c) {
        try {
            return c.createStatement();
        }
        catch (SQLException e) {
            System.out.println("Could not create statement for database");
            return null;
        }
    }

    public static Statement getStatement() {
        return DatabaseHelper.getStatement(DatabaseHelper.getConnection());
    }

    public static ResultSet getResultSet(Statement s, String query) {
        try {
            return s.executeQuery(query);
        }
        catch (SQLException e) {
            System.out.println("Could not create ResultSet for query " + query + " for database because " + e.getMessage());
            return null;
        }
    }

    public static ResultSet getResultSet(String query) {
        return DatabaseHelper.getResultSet(DatabaseHelper.getStatement(), query);
    }

    public static void finish(Connection c, Statement s) {
        try {
            s.close();
            c.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void finish(ResultSet r) {
        try {
            DatabaseHelper.finish(r.getStatement().getConnection(), r.getStatement());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static {
        madeConnection = false;
        databasePath = null;
        databaseLoc = new ResourceLocation("pixelmon:database/Pixelmon2.h2.db");
        driverLoc = new ResourceLocation("pixelmon:database/h2-1.3.173.jar");
    }
}

