/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.database;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.AttackCategory;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class DatabaseMoves {
    public static Moveset GetInitialMoves(Entity6CanBattle pixelmon, int level) {
        ArrayList<Object> attackList = new ArrayList();
        attackList = DatabaseMoves.getMovesetUpToLevel(pixelmon.baseStats.id, level);
        while (attackList.size() > 4) {
            int ind = RandomHelper.getRandomNumberBetween(0, attackList.size() - 1);
            attackList.remove(ind);
        }
        if (attackList.size() == 0) {
            attackList.add(DatabaseMoves.getAttack("Tackle"));
        }
        Moveset attacks = new Moveset();
        for (Attack attack : attackList) {
            attacks.add(attack);
        }
        return attacks;
    }

    public static ArrayList<Attack> getMovesetUpToLevel(int id, int level) {
        ArrayList<Attack> attackList = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int learnLevel = rs.getInt("LEARNLEVEL");
                int moveID = rs.getInt("MOVEID");
                if (learnLevel > level) continue;
                attackList.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception e) {
            System.out.println("pixelmon id=" + id + " has corrupted moves at level " + level);
        }
        for (int i = 0; i < attackList.size(); ++i) {
            for (int j = i + 1; j < attackList.size(); ++j) {
                if (attackList.get((int)i).baseAttack.attackIndex != attackList.get((int)j).baseAttack.attackIndex) continue;
                attackList.remove(j);
                --j;
            }
        }
        return attackList;
    }

    public static boolean LearnsAttackAtLevel(int id, int level) {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "' AND LEARNLEVEL='" + level + "'");
            if (rs.next()) {
                rs.close();
                return true;
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static ArrayList<Attack> getAttacksAtLevel(int id, int level) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "' AND LEARNLEVEL='" + level + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllTMHMAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONTMHMSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllTutorAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONTUTORSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllEggAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONEGGSKILLS where PIXELMONID='" + id + "'");
            while (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                attacks.add(DatabaseMoves.getAttack(moveID));
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attacks;
    }

    public static ArrayList<Attack> getAllTMHMTutorAttacks(int id) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        attacks.addAll(DatabaseMoves.getAllTMHMAttacks(id));
        attacks.addAll(DatabaseMoves.getAllTutorAttacks(id));
        return attacks;
    }

    public static Attack getAttack(String moveName) {
        block3: {
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from MOVES where NAME='" + moveName + "'");
                if (rs.next()) {
                    return new Attack(rs.getInt("MOVEID"), moveName, rs);
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block3;
                System.out.println(e.getMessage());
            }
        }
        return null;
    }

    public static AttackBase getAttackBase(int attackIndex) {
        block3: {
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from MOVES where MOVEID='" + attackIndex + "'");
                if (rs.next()) {
                    return new AttackBase(attackIndex, rs.getString("NAME"), rs);
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block3;
                System.out.println(e.getMessage());
            }
        }
        return null;
    }

    public static int getAttackIndex(String moveName) {
        block3: {
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select MOVEID from MOVES where NAME='" + moveName + "'");
                if (rs.next()) {
                    return rs.getInt("MOVEID");
                }
                rs.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block3;
                System.out.println(e.getMessage());
            }
        }
        return -1;
    }

    public static Attack getAttack(int moveIndex) {
        block3: {
            try {
                Connection conn = DatabaseHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("select * from MOVES where MOVEID='" + moveIndex + "'");
                if (rs.next()) {
                    return new Attack(moveIndex, rs.getString("NAME"), rs);
                }
                conn.close();
            }
            catch (Exception e) {
                if (!PixelmonConfig.printErrors) break block3;
                System.out.println(e.getMessage());
            }
        }
        return null;
    }

    public static boolean CanLearnAttack(int id, String attackName) {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select MOVEID from MOVES where NAME='" + attackName + "'");
            if (rs.next()) {
                int moveID = rs.getInt("MOVEID");
                rs.close();
                ResultSet levelSkillsrs = stat.executeQuery("select * from PIXELMONLEVELSKILLS where PIXELMONID='" + id + "' AND MOVEID='" + moveID + "'");
                if (levelSkillsrs.next()) {
                    return true;
                }
                levelSkillsrs.close();
                ResultSet tmSkillsrs = stat.executeQuery("select * from PIXELMONTMHMSKILLS where PIXELMONID='" + id + "' AND MOVEID='" + moveID + "'");
                if (tmSkillsrs.next()) {
                    return true;
                }
            } else {
                rs.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static AttackCategory[] getAttackCategories() {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from MOVECATEGORIES");
            ArrayList<AttackCategory> list = new ArrayList<AttackCategory>();
            while (rs.next()) {
                list.add(new AttackCategory(rs.getInt("MOVECATEGORYID"), rs.getString("NAME")));
            }
            rs.close();
            AttackCategory[] categories = new AttackCategory[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                categories[i] = (AttackCategory)list.get(i);
            }
            return categories;
        }
        catch (Exception e) {
            if (PixelmonConfig.printErrors) {
                System.out.println(e.getMessage());
            }
            return null;
        }
    }
}

