/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.database;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.database.DatabaseAbilities;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.database.EvolutionInfo;
import com.pixelmonmod.pixelmon.database.ExperienceGroup;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.DropList;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVsStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Rarity;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionByStone;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionFriendship;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionLevel;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionLevelHeldItem;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionMove;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionProximity;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionTrade;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionTyrogue;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.FriendshipEvolutionCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.IEvolutionData;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumEvolutionRock;
import com.pixelmonmod.pixelmon.enums.EnumEvolutionStone;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DatabaseStats {
    public static BaseStats GetBaseStats(String name) {
        Connection conn = null;
        BaseStats store = new BaseStats(name);
        try {
            conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMON where PIXELMONFULLNAME='" + name + "'");
            String error = "";
            boolean hasError = false;
            if (rs.next()) {
                EnumEggGroup[] eggGroups;
                store.pokemon = EnumPokemon.get(name);
                store.id = rs.getInt("PIXELMONID");
                store.hp = rs.getInt("BASEHP");
                if (rs.wasNull()) {
                    error = error + "[HP]";
                    hasError = true;
                }
                store.attack = rs.getInt("BASEATK");
                if (rs.wasNull()) {
                    error = error + "[ATTACK]";
                    hasError = true;
                }
                store.defence = rs.getInt("BASEDEF");
                if (rs.wasNull()) {
                    error = error + "[DEFENSE]";
                    hasError = true;
                }
                store.speed = rs.getInt("BASESPD");
                if (rs.wasNull()) {
                    error = error + "[SPEED]";
                    hasError = true;
                }
                store.spAtt = rs.getInt("BASESPATK");
                if (rs.wasNull()) {
                    error = error + "[SPATTACK]";
                    hasError = true;
                }
                store.spDef = rs.getInt("BASESPDEF");
                if (rs.wasNull()) {
                    error = error + "[SPDEFENSE]";
                    hasError = true;
                }
                if (hasError && PixelmonConfig.printErrors) {
                    System.out.println("Error in BaseStats [" + error + "]" + " For Pokemon : " + name);
                }
                store.catchRate = rs.getInt("CATCHRATE");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in CatchRate For Pokemon : " + name);
                }
                store.malePercent = rs.getInt("MALEPERCENT");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in MalePercent For Pokemon : " + name);
                }
                store.canFly = rs.getBoolean("CANFLY");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in CanFly For Pokemon : " + name);
                }
                store.doesHover = rs.getBoolean("DOESHOVER");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in DoesHover For Pokemon : " + name);
                }
                if (store.doesHover) {
                    store.hoverHeight = 1.0f;
                }
                store.canSurf = rs.getBoolean("CANSWIM");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in CANSWIM For Pokemon : " + name);
                }
                store.height = rs.getFloat("POKEDEXHEIGHT");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in Height For Pokemon : " + name);
                }
                store.width = rs.getFloat("POKEDEXWIDTH");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in Width For Pokemon : " + name);
                }
                store.length = rs.getFloat("POKEDEXLENGTH");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in Length For Pokemon : " + name);
                }
                store.weight = rs.getFloat("POKEDEXWEIGHT");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in Weight For Pokemon : " + name);
                }
                store.type1 = EnumType.parseTypeFromDBID(rs.getInt("PIXELMONTYPE1ID"));
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in Type For Pokemon : " + name);
                }
                rs.getInt("PIXELMONTYPE2ID");
                if (!rs.wasNull()) {
                    store.type2 = EnumType.parseTypeFromDBID(rs.getInt("PIXELMONTYPE2ID"));
                }
                store.baseExp = rs.getInt("BASEEXP");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in BaseExp For Pokemon : " + name);
                }
                store.experienceGroup = ExperienceGroup.getExperienceGroup(rs.getString("EXPERIENCEGROUP"));
                if ((rs.wasNull() || store.experienceGroup == null) && PixelmonConfig.printErrors) {
                    System.out.println("Error in ExperienceGroup For Pokemon : " + name);
                }
                store.nationalPokedexNumber = rs.getInt("NATIONALPOKEDEXNUMBER");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in NationalPokedexNumber For Pokemon : " + name);
                }
                store.spawnLevel = rs.getInt("MINSPAWNLEVEL");
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in SpawnLevel For Pokemon : " + name);
                }
                store.spawnLevelRange = rs.getInt("MAXSPAWNLEVEL") - store.spawnLevel;
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in SpawnLevelRange For Pokemon : " + name);
                }
                store.isRideable = rs.getBoolean("ISRIDEABLE");
                store.giScale = rs.getFloat("MODELSCALE");
                store.aggression = new Aggression(rs.getInt("PERCENTTIMID"), rs.getInt("PERCENTAGRESSIVE"), name);
                if (rs.wasNull() && PixelmonConfig.printErrors) {
                    System.out.println("Error in Aggression For Pokemon : " + name);
                }
                store.baseFriendship = rs.getInt("BASEFRIENDSHIP");
                Integer rarityBase = rs.getInt("RARITY");
                store.evGain = new EVsStore();
                store.evGain.HP = rs.getInt("EVGAINHP");
                store.evGain.Attack = rs.getInt("EVGAINATK");
                store.evGain.Defence = rs.getInt("EVGAINDEF");
                store.evGain.SpecialAttack = rs.getInt("EVGAINSPATK");
                store.evGain.SpecialDefence = rs.getInt("EVGAINSPDEF");
                store.evGain.Speed = rs.getInt("EVGAINSPD");
                store.maxGroupSize = rs.getInt("MAXGROUPSIZE");
                store.minGroupSize = rs.getInt("MINGROUPSIZE");
                store.abilities = DatabaseAbilities.getAbilities(name);
                rs.getInt("EGGGROUP1ID");
                if (rs.wasNull()) {
                    eggGroups = new EnumEggGroup[]{EnumEggGroup.Undiscovered};
                } else {
                    rs.getInt("EGGGROUP2ID");
                    eggGroups = rs.wasNull() ? new EnumEggGroup[]{EnumEggGroup.getEggGroupFromIndex(rs.getInt("EGGGROUP1ID"))} : new EnumEggGroup[]{EnumEggGroup.getEggGroupFromIndex(rs.getInt("EGGGROUP1ID")), EnumEggGroup.getEggGroupFromIndex(rs.getInt("EGGGROUP2ID"))};
                }
                store.eggGroups = eggGroups;
                rs.getInt("EGGCYCLES");
                store.eggCycles = rs.wasNull() ? Integer.valueOf(21) : Integer.valueOf(rs.getInt("EGGCYCLES"));
                DatabaseStats.getPixelmonDrops(store, stat);
                DatabaseStats.getPixelmonEvolutions(store, stat, name);
                DatabaseStats.getPixelmonRarity(store, stat, rarityBase);
                DatabaseStats.getPixelmonSpawnLocations(store, stat);
                DatabaseStats.getPixelmonSpawnBiomeIDs(store, stat);
                DatabaseStats.getPixelmonSwimmingParameters(store, stat);
                DatabaseStats.getPixelmonFlyingParameters(store, stat);
                DatabaseStats.getPixelmonRidingOffsets(store, stat);
            }
            rs.close();
            return store;
        }
        catch (Exception e) {
            System.out.println("Error retrieving stats for Pokemon : " + name);
            e.printStackTrace();
            return null;
        }
    }

    private static void getPixelmonRarity(BaseStats store, Statement stat, Integer rarityBase) throws SQLException {
        if (rarityBase == null) {
            store.rarity = new Rarity(0, 0, 0);
        } else {
            ResultSet rs = stat.executeQuery("select * from PIXELMONSPAWNTIMES a JOIN PIXELMON b ON (a.SPAWNTIMEID=b.SPAWNTIMEID) where b.PIXELMONID = '" + store.id + "'");
            float multiplierDay = 0.0f;
            float multiplierDawnDusk = 0.0f;
            float multiplierNight = 0.0f;
            if (rs.next()) {
                String strDay = rs.getString("MULTIPLIERDAY");
                String strDawnDusk = rs.getString("MULTIPLIERDUSKDAWN");
                String strNight = rs.getString("MULTIPLIERNIGHT");
                multiplierDay = Float.parseFloat(strDay);
                multiplierDawnDusk = Float.parseFloat(strDawnDusk);
                multiplierNight = Float.parseFloat(strNight);
            }
            store.rarity = new Rarity(Math.round((float)rarityBase.intValue() * multiplierDay), Math.round((float)rarityBase.intValue() * multiplierDawnDusk), Math.round((float)rarityBase.intValue() * multiplierNight));
            rs.close();
        }
    }

    private static void getPixelmonRidingOffsets(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONRIDE where PIXELMONID='" + store.id + "'");
        if (rs.next()) {
            rs.getDouble("STANDINGOFFSETX");
            if (!rs.wasNull()) {
                store.ridingOffsets = new RidingOffsets();
                store.ridingOffsets.setStandingOffsets(rs.getDouble("STANDINGOFFSETX"), rs.getDouble("STANDINGOFFSETY"), rs.getDouble("STANDINGOFFSETZ"));
            }
            rs.getDouble("MOVINGOFFSETX");
            if (!rs.wasNull()) {
                if (store.ridingOffsets == null) {
                    store.ridingOffsets = new RidingOffsets();
                }
                store.ridingOffsets.setMovingOffsets(rs.getDouble("MOVINGOFFSETX"), rs.getDouble("MOVINGOFFSETY"), rs.getDouble("MOVINGOFFSETZ"));
            }
        }
        rs.close();
    }

    private static void getPixelmonSwimmingParameters(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONSWIM where PIXELMONID='" + store.id + "'");
        if (rs.next()) {
            store.swimmingParameters = new SwimmingParameters(rs.getInt("SWIMDEPTHMIN"), rs.getInt("SWIMDEPTHMAX"), rs.getDouble("SWIMSPEED"), rs.getDouble("SWIMSPEEDDECAY"), rs.getInt("SWIMREFRESHRATE"));
        }
        rs.close();
    }

    private static void getPixelmonFlyingParameters(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONFLY where PIXELMONID='" + store.id + "'");
        if (rs.next()) {
            store.flyingParameters = new FlyingParameters(rs.getInt("FLYHEIGHTMIN"), rs.getInt("FLYHEIGHTMAX"), rs.getFloat("FLYSPEEDMODIFIER"), rs.getInt("FLYREFRESHRATEY"), rs.getInt("FLYREFRESHRATEXZ"), rs.getInt("FLYREFRESHRATESPEED"), rs.getInt("FLIGHTTIMEMIN"), rs.getInt("FLIGHTTIMEMAX"), rs.getInt("FLAPRATE"), rs.getString("LANDINGMATERIALGROUP"));
        }
        rs.close();
    }

    private static void getPixelmonSpawnLocations(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONSPAWNLOCATIONS where PIXELMONID='" + store.id + "'");
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            list.add(rs.getString("LOCATION"));
        }
        rs.close();
        store.spawnLocations = SpawnLocation.getSpawnLocations(list);
        list.clear();
    }

    private static void getPixelmonDrops(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONDROPS where PIXELMONID='" + store.id + "'");
        ArrayList<DropList> list = new ArrayList<DropList>();
        while (rs.next()) {
            list.add(new DropList(rs.getString("DROPITEM"), rs.getString("MAXDROPAMOUNT"), rs.getString("DROPCHANCE")));
        }
        rs.close();
        store.droppedItems = DropList.getDropStatsListFromArray(list);
        list.clear();
    }

    private static void getPixelmonEvolutions(BaseStats store, Statement stat, String name) throws SQLException {
        String p;
        ArrayList<Evolution> evolutions = new ArrayList<Evolution>();
        ResultSet evrs = stat.executeQuery("select * from PIXELMONEVOLUTIONS where PIXELMONFROMID='" + store.id + "'");
        while (evrs.next()) {
            int evolveLevel = evrs.getInt("EVOLVELEVEL");
            if (!evrs.wasNull()) {
                EnumPokemon poke = EnumPokemon.getFromDBID(evrs.getInt("PIXELMONTOID"));
                evolutions.add(new Evolution(poke, evolveLevel));
                continue;
            }
            String evolveCondition = evrs.getString("EVOLVECONDITION");
            String[] splits = evolveCondition.split(":");
            EnumPokemon poke = EnumPokemon.get(splits[splits.length - 1]);
            IEvolutionData data = null;
            if (splits[0].equalsIgnoreCase("friendship")) {
                data = splits.length > 2 ? new EvolutionFriendship(FriendshipEvolutionCondition.parse(splits[1])) : new EvolutionFriendship();
            } else if (splits[0].equalsIgnoreCase("trade")) {
                data = splits.length > 2 ? new EvolutionTrade(PixelmonItemsHeld.getHeldItem(splits[1])) : new EvolutionTrade();
            } else if (splits[0].equalsIgnoreCase("move")) {
                data = new EvolutionMove(Integer.parseInt(splits[1]));
            } else if (EnumEvolutionStone.isEvolutionStone(splits[0])) {
                data = new EvolutionByStone(EnumEvolutionStone.getEvolutionStone(splits[0]));
            } else if (EnumEvolutionRock.isEvolutionRock(splits[0])) {
                data = new EvolutionProximity(EnumEvolutionRock.getEvolutionRock(splits[0]));
            } else if (splits[0].equalsIgnoreCase("levelupbiome")) {
                if (splits.length < 4) {
                    String biome = splits[1];
                    data = new EvolutionLevel(biome);
                } else {
                    int level = Integer.parseInt(splits[1]);
                    String biome = splits[2];
                    data = new EvolutionLevel(level, biome);
                }
            } else if (splits[0].equalsIgnoreCase("leveluphelditem")) {
                String itemString = splits[1];
                try {
                    data = new EvolutionLevelHeldItem(itemString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            } else if (splits[0].equalsIgnoreCase("tyrogue")) {
                data = new EvolutionTyrogue();
            }
            evolutions.add(new Evolution(data, poke));
        }
        evrs.close();
        Object[] array = evolutions.toArray();
        store.evolutions = new Evolution[array.length];
        for (int i = 0; i < array.length; ++i) {
            store.evolutions[i] = (Evolution)array[i];
        }
        ArrayList<String> list = new ArrayList<String>();
        while ((p = DatabaseStats.getPreEvolution(name, stat)) != null) {
            list.add(p);
            name = p;
        }
        store.preEvolutions = new EnumPokemon[list.size()];
        int i = 0;
        for (String poke : list) {
            store.preEvolutions[i++] = EnumPokemon.get(poke);
        }
        list.clear();
    }

    public static String getPreEvolution(String name, Statement stat) throws SQLException {
        int id = DatabaseStats.getPokemonDBIDFromName(name, stat);
        Integer fromId = null;
        ResultSet rs = stat.executeQuery("select * from PIXELMONEVOLUTIONS where EVOLVECONDITION LIKE '%" + name + "%'");
        if (rs.next()) {
            fromId = rs.getInt("PIXELMONFROMID");
            if (id == fromId) {
                return null;
            }
            rs.close();
            return DatabaseStats.getPokemonNameFromDBID(fromId, stat);
        }
        rs = stat.executeQuery("select * from PIXELMONEVOLUTIONS where PIXELMONTOID='" + id + "'");
        if (rs.next()) {
            fromId = rs.getInt("PIXELMONFROMID");
            if (id == fromId) {
                return null;
            }
            rs.close();
            return DatabaseStats.getPokemonNameFromDBID(fromId, stat);
        }
        return null;
    }

    private static int getPokemonDBIDFromName(String name, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select PIXELMONID from PIXELMON where PIXELMONFULLNAME='" + name + "'");
        if (rs.next()) {
            int id = rs.getInt("PIXELMONID");
            rs.close();
            return id;
        }
        return -1;
    }

    private static String getPokemonNameFromDBID(int id, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select PIXELMONFULLNAME from PIXELMON where PIXELMONID='" + id + "'");
        if (rs.next()) {
            String name = rs.getString("PIXELMONFULLNAME");
            rs.close();
            return name;
        }
        return null;
    }

    private static void getPixelmonSpawnBiomeIDs(BaseStats store, Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("select * from PIXELMONSPAWNBIOMES WHERE PIXELMONID='" + store.id + "'");
        PixelmonBiomeDictionary.PixelmonBiomeInfo[] biomes = PixelmonBiomeDictionary.getBiomeInfoList();
        ArrayList<Integer> tempBiomeIDs = new ArrayList<Integer>();
        boolean isSpecificMatch = true;
        ArrayList dbtagsArray = new ArrayList();
        try {
            block2: while (rs.next()) {
                String dbBiomeName = rs.getString("BIOMENAME");
                for (int i = 0; i < biomes.length; ++i) {
                    if (biomes[i] == null || !biomes[i].isSameNameAs(dbBiomeName)) continue;
                    tempBiomeIDs.add(i);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        rs.close();
        Integer[] biomeIDs = new Integer[tempBiomeIDs.size()];
        int j = 0;
        for (Integer i : tempBiomeIDs) {
            biomeIDs[j++] = i;
        }
        store.biomeIDs = biomeIDs;
    }

    public static ArrayList<EvolutionInfo> getEvolveList(int id) {
        ArrayList<EvolutionInfo> list = new ArrayList<EvolutionInfo>();
        Connection conn = null;
        try {
            conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from PIXELMONEVOLUTIONS where PIXELMONFROMID='" + id + "' AND EVOLVECONDITION IS NOT NULL");
            while (rs.next()) {
                String[] strList;
                String type = rs.getString("EVOLVECONDITION");
                for (String s : strList = type.split(";")) {
                    String[] sSplit = s.split(":");
                    EvolutionInfo i = new EvolutionInfo();
                    if (EnumEvolutionStone.isEvolutionStone(sSplit[0])) {
                        i.mode = EvolutionInfo.InfoMode.stone;
                        i.evolutionStone = EnumEvolutionStone.getEvolutionStone(sSplit[0]);
                    } else if (EnumEvolutionRock.isEvolutionRock(sSplit[0])) {
                        i.mode = EvolutionInfo.InfoMode.evolutionRock;
                        i.evolutionRock = EnumEvolutionRock.getEvolutionRock(sSplit[0]);
                    } else if (sSplit[0].equalsIgnoreCase("Friendship")) {
                        i.mode = EvolutionInfo.InfoMode.friendship;
                        if (sSplit.length > 1) {
                            i.extraParam = sSplit[1];
                        }
                    } else if (sSplit[0].equalsIgnoreCase("Trade")) {
                        i.mode = EvolutionInfo.InfoMode.trade;
                        if (sSplit.length > 1) {
                            i.extraParam = sSplit[1];
                        }
                        if (sSplit.length > 2) {
                            i.extraParam2 = sSplit[2];
                        }
                    } else {
                        i.mode = EvolutionInfo.InfoMode.biome;
                        i.extraParam = sSplit[0];
                    }
                    i.pokemonName = sSplit[sSplit.length - 1];
                    list.add(i);
                }
            }
            rs.close();
        }
        catch (Exception e) {
            System.out.println("Error in evolution conditions for " + id);
        }
        return list;
    }

    public static String getDescription(String name) {
        try {
            Connection con = DatabaseHelper.getConnection();
            Statement stat = con.createStatement();
            ResultSet rs = stat.executeQuery("select POKEDEXDESCRIPTION from PIXELMON where PIXELMONFULLNAME='" + name + "'");
            if (rs.next()) {
                String description = rs.getString("POKEDEXDESCRIPTION");
                rs.close();
                return description;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

