/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.database;

import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class DatabaseStorage {
    private static HashMap<String, String> columnMappings = new HashMap();
    private static ArrayList<String> excludeList = new ArrayList();
    private static Statement stmt;
    private static String dbType;
    private static final String pokeDBConn;
    private static final String pokeDB = "PIXELMON";
    private static final String playerTable = "PLAYERDATA";
    private static final String pokemonTable = "POKEMON";
    private static boolean checked;
    public static Connection conn;

    public static void checkPokemonDatabaseStructure(NBTTagCompound pokeNBT) {
        if (checked) {
            return;
        }
        if (!dbType.equals("h2") && !dbType.equals("mysql")) {
            return;
        }
        try {
            if (dbType == "mysql" && !DatabaseStorage.databaseExists(conn, pokeDB)) {
                DatabaseStorage.createDatabase(conn, pokeDB);
            }
            if (!DatabaseStorage.tableExists(conn, playerTable)) {
                DatabaseStorage.createTable(conn, playerTable, true);
            }
            if (!DatabaseStorage.columnExists(conn, playerTable, "UUIDMost")) {
                DatabaseStorage.createColumn(conn, playerTable, "UUIDMost", "BIGINT");
            }
            if (!DatabaseStorage.columnExists(conn, playerTable, "UUIDLeast")) {
                DatabaseStorage.createColumn(conn, playerTable, "UUIDLeast", "BIGINT");
            }
            DatabaseStorage.checkNBTTagCompound(conn, playerTable, pokeNBT);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        checked = true;
    }

    private static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(pokeDBConn);
    }

    private static void checkNBTTagCompound(Connection conn, String table, NBTTagCompound nbt) throws SQLException {
        for (String s : nbt.func_150296_c()) {
            if (DatabaseStorage.isExcluded(s)) continue;
            NBTBase nbtbase = nbt.func_74781_a(s);
            if (nbtbase instanceof NBTTagCompound) {
                String tableName = s.toUpperCase();
                if (s.startsWith("party")) {
                    tableName = pokemonTable;
                }
                if (!DatabaseStorage.tableExists(conn, tableName)) {
                    DatabaseStorage.createTable(conn, tableName, false);
                }
                DatabaseStorage.checkNBTTagCompound(conn, tableName, (NBTTagCompound)nbtbase);
            } else {
                columnMappings.put(s, s.toUpperCase());
            }
            if (nbtbase instanceof NBTTagShort) {
                if (DatabaseStorage.columnExists(conn, table, s)) continue;
                DatabaseStorage.createColumn(conn, table, s, "SMALLINT");
                continue;
            }
            if (nbtbase instanceof NBTTagByte) {
                if (DatabaseStorage.columnExists(conn, table, s)) continue;
                DatabaseStorage.createColumn(conn, table, s, "BINARY(8)");
                continue;
            }
            if (nbtbase instanceof NBTTagByteArray) {
                if (DatabaseStorage.columnExists(conn, table, s)) continue;
                DatabaseStorage.createColumn(conn, table, s, "BINARY(64)");
                continue;
            }
            if (nbtbase instanceof NBTTagDouble) {
                if (DatabaseStorage.columnExists(conn, table, s)) continue;
                DatabaseStorage.createColumn(conn, table, s, "DOUBLE");
                continue;
            }
            if (nbtbase instanceof NBTTagFloat) {
                if (DatabaseStorage.columnExists(conn, table, s)) continue;
                DatabaseStorage.createColumn(conn, table, s, "FLOAT");
                continue;
            }
            if (nbtbase instanceof NBTTagInt) {
                if (DatabaseStorage.columnExists(conn, table, s)) continue;
                DatabaseStorage.createColumn(conn, table, s, "INTEGER");
                continue;
            }
            if (nbtbase instanceof NBTTagLong) {
                if (DatabaseStorage.columnExists(conn, table, s)) continue;
                DatabaseStorage.createColumn(conn, table, s, "BIGINT");
                continue;
            }
            if (!(nbtbase instanceof NBTTagString) || DatabaseStorage.columnExists(conn, table, s)) continue;
            DatabaseStorage.createColumn(conn, table, s, "VARCHAR(64)");
        }
    }

    private static boolean isExcluded(String s) {
        for (String e : excludeList) {
            if (!e.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private static void createTable(Connection conn, String table, boolean isRoot) throws SQLException {
        String sql = "";
        sql = isRoot ? "CREATE TABLE " + table + " (id INTEGER not NULL AUTO_INCREMENT, PRIMARY KEY (id))" : "CREATE TABLE " + table + " (id INTEGER not NULL AUTO_INCREMENT, PLAYERID INTEGER, PRIMARY KEY (id))";
        stmt.executeUpdate(sql);
    }

    private static boolean tableExists(Connection conn, String tableName) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getTables(null, null, null, new String[]{"TABLE"});
        while (rs.next()) {
            if (!rs.getString("TABLE_NAME").equals(tableName)) continue;
            return true;
        }
        return false;
    }

    private static void createDatabase(Connection conn, String pokedb2) throws SQLException {
        String sql = "CREATE DATABASE PIXELMON";
        stmt.executeUpdate(sql);
    }

    private static boolean databaseExists(Connection conn, String dbName) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getCatalogs();
        if (rs.next()) {
            try {
                if (rs.getString(dbName) != null) {
                    return true;
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static void createColumn(Connection conn, String table, String columnName, String type) throws SQLException {
        String sql = "ALTER TABLE " + table + " ADD " + columnName + " " + type;
        stmt.executeUpdate(sql);
    }

    private static boolean columnExists(Connection conn, String tableName, String columnName) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getColumns(null, null, tableName, columnName.toUpperCase());
        return rs.next();
    }

    public static void startSave() {
        try {
            conn = DatabaseStorage.getConnection();
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void readPlayerData(UUID uuid, PlayerStorage storage) {
    }

    public static void writePlayerData(UUID uuid, NBTTagCompound nbt) {
        if (conn == null) {
            DatabaseStorage.startSave();
        }
        try {
            DatabaseStorage.checkPokemonDatabaseStructure(nbt);
            String checkSql = "SELECT * FROM PLAYERDATA WHERE UUIDMOST=" + uuid.getMostSignificantBits() + " AND UUIDLEAST=" + uuid.getLeastSignificantBits() + "";
            String sql = "";
            ResultSet rs = stmt.executeQuery(checkSql);
            sql = rs.next() ? DatabaseStorage.getUpdateSQL(uuid, playerTable, nbt, "UUIDMOST=" + uuid.getMostSignificantBits() + " AND UUIDLEAST=" + uuid.getLeastSignificantBits()) : DatabaseStorage.getInsertSQL(uuid, playerTable, nbt, "UUIDMOST,UUIDLEAST", "" + uuid.getMostSignificantBits() + "," + uuid.getLeastSignificantBits());
            stmt.executeUpdate(sql);
            sql = "SELECT ID FROM PLAYERDATA WHERE UUIDMOST=" + uuid.getMostSignificantBits() + " AND UUIDLEAST=" + uuid.getLeastSignificantBits() + "";
            rs = stmt.executeQuery(sql);
            int id = 0;
            if (rs.next()) {
                id = rs.getInt("ID");
            }
            for (String s : nbt.func_150296_c()) {
                NBTBase nbtbase;
                if (DatabaseStorage.isExcluded(s) || !((nbtbase = nbt.func_74781_a(s)) instanceof NBTTagCompound)) continue;
                String tableName = s;
                checkSql = "SELECT * FROM " + tableName + " WHERE " + "PLAYERID=" + id;
                String check = "PLAYERID=" + id;
                String checkStart = "PLAYERID";
                String checkEnd = "" + id;
                if (s.startsWith("party")) {
                    tableName = pokemonTable;
                    checkSql = "SELECT * FROM " + tableName + " WHERE " + "PLAYERID=" + id + " AND PIXELMONID1=" + ((NBTTagCompound)nbtbase).func_74762_e("pixelmonID1") + " AND PIXELMONID2=" + ((NBTTagCompound)nbtbase).func_74762_e("pixelmonID2");
                    check = check + " AND PIXELMONID1=" + ((NBTTagCompound)nbtbase).func_74762_e("pixelmonID1") + " AND PIXELMONID2=" + ((NBTTagCompound)nbtbase).func_74762_e("pixelmonID2");
                }
                sql = (rs = stmt.executeQuery(checkSql)).next() ? DatabaseStorage.getUpdateSQL(uuid, tableName, (NBTTagCompound)nbtbase, check) : DatabaseStorage.getInsertSQL(uuid, tableName, (NBTTagCompound)nbtbase, checkStart, checkEnd);
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static String getUpdateSQL(UUID uuid, String table, NBTTagCompound nbt, String whereCheck) throws SQLException {
        String sql = "UPDATE " + table + " SET ";
        sql = sql + DatabaseStorage.buildSQL(conn, table, nbt, sqlMode.both);
        sql = sql.replace("SET ,", "SET ");
        sql = sql + " WHERE " + whereCheck;
        return sql;
    }

    private static String getInsertSQL(UUID uuid, String table, NBTTagCompound nbt, String whereStart, String whereEnd) throws SQLException {
        String sql = "INSERT INTO " + table + " (ID," + whereStart;
        sql = sql + DatabaseStorage.buildSQL(conn, table, nbt, sqlMode.columns);
        sql = sql + ") VALUES (NULL," + whereEnd;
        sql = sql + DatabaseStorage.buildSQL(conn, table, nbt, sqlMode.values);
        sql = sql + ")";
        return sql;
    }

    private static String buildSQL(Connection conn, String table, NBTTagCompound nbt, sqlMode mode) throws SQLException {
        String sql = "";
        for (String s : nbt.func_150296_c()) {
            if (DatabaseStorage.isExcluded(s)) continue;
            NBTBase nbtbase = nbt.func_74781_a(s);
            if (nbtbase instanceof NBTTagShort) {
                if (mode == sqlMode.columns) {
                    sql = sql + "," + columnMappings.get(s);
                    continue;
                }
                if (mode == sqlMode.values) {
                    sql = sql + "," + nbt.func_74765_d(s);
                    continue;
                }
                sql = sql + "," + columnMappings.get(s) + "=" + nbt.func_74765_d(s);
                continue;
            }
            if (nbtbase instanceof NBTTagByte) {
                if (mode == sqlMode.columns) {
                    sql = sql + "," + columnMappings.get(s);
                    continue;
                }
                if (mode == sqlMode.values) {
                    sql = sql + "," + nbt.func_74771_c(s);
                    continue;
                }
                sql = sql + "," + columnMappings.get(s) + "=" + nbt.func_74771_c(s);
                continue;
            }
            if (nbtbase instanceof NBTTagByteArray) {
                if (mode == sqlMode.columns) {
                    sql = sql + "," + columnMappings.get(s);
                    continue;
                }
                if (mode == sqlMode.values) {
                    sql = sql + "," + nbt.func_74770_j(s);
                    continue;
                }
                sql = sql + "," + columnMappings.get(s) + "=" + nbt.func_74770_j(s);
                continue;
            }
            if (nbtbase instanceof NBTTagDouble) {
                if (mode == sqlMode.columns) {
                    sql = sql + "," + columnMappings.get(s);
                    continue;
                }
                if (mode == sqlMode.values) {
                    sql = sql + "," + nbt.func_74769_h(s);
                    continue;
                }
                sql = sql + "," + columnMappings.get(s) + "=" + nbt.func_74769_h(s);
                continue;
            }
            if (nbtbase instanceof NBTTagFloat) {
                if (mode == sqlMode.columns) {
                    sql = sql + "," + columnMappings.get(s);
                    continue;
                }
                if (mode == sqlMode.values) {
                    sql = sql + "," + nbt.func_74760_g(s);
                    continue;
                }
                sql = sql + "," + columnMappings.get(s) + "=" + nbt.func_74760_g(s);
                continue;
            }
            if (nbtbase instanceof NBTTagInt) {
                if (mode == sqlMode.columns) {
                    sql = sql + "," + columnMappings.get(s);
                    continue;
                }
                if (mode == sqlMode.values) {
                    sql = sql + "," + nbt.func_74762_e(s);
                    continue;
                }
                sql = sql + "," + columnMappings.get(s) + "=" + nbt.func_74762_e(s);
                continue;
            }
            if (nbtbase instanceof NBTTagLong) {
                if (mode == sqlMode.columns) {
                    sql = sql + "," + columnMappings.get(s);
                    continue;
                }
                if (mode == sqlMode.values) {
                    sql = sql + "," + nbt.func_74763_f(s);
                    continue;
                }
                sql = sql + "," + columnMappings.get(s) + "=" + nbt.func_74763_f(s);
                continue;
            }
            if (!(nbtbase instanceof NBTTagString)) continue;
            if (mode == sqlMode.columns) {
                sql = sql + "," + columnMappings.get(s);
                continue;
            }
            if (mode == sqlMode.values) {
                sql = sql + ",'" + nbt.func_74779_i(s) + "'";
                continue;
            }
            sql = sql + "," + columnMappings.get(s) + "='" + nbt.func_74779_i(s) + "'";
        }
        return sql;
    }

    static {
        excludeList.add("Bukkit.MaxHealth");
        excludeList.add("CanPickUpLoot");
        excludeList.add("DeathTime");
        excludeList.add("Dimension");
        excludeList.add("DropChances");
        excludeList.add("Equipment");
        excludeList.add("Fire");
        excludeList.add("id");
        excludeList.add("Leashed");
        excludeList.add("InLove");
        excludeList.add("Invulnerable");
        excludeList.add("Motion");
        excludeList.add("OnGround");
        excludeList.add("PersistenceRequired");
        excludeList.add("Pos");
        excludeList.add("PortalCooldown");
        excludeList.add("Rotation");
        excludeList.add("Sitting");
        dbType = "h2";
        pokeDBConn = "jdbc:" + dbType + ":file:d:/temp/storage";
        checked = false;
    }

    private static enum sqlMode {
        columns,
        values,
        both;

    }
}

