/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.database;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.database.TrainerInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumTrainerModel;
import com.pixelmonmod.pixelmon.spawning.PixelmonBiomeDictionary;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;

public class DatabaseTrainers {
    public static TrainerInfo GetTrainerInfo(String trainerName) {
        Connection conn = null;
        try {
            conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT * from TRAINER where TRAINERTYPEID=SELECT TRAINERTYPEID FROM TRAINERTYPES WHERE TYPENAME='" + trainerName + "'");
            TrainerInfo info = new TrainerInfo();
            Random rand = new Random();
            if (rs.next()) {
                info.id = rs.getInt("TRAINERTYPEID");
                DatabaseTrainers.getNameAndModelForID(stat, info);
                DatabaseTrainers.getPartyPokemon(stat, info);
                DatabaseTrainers.getTrainerTypeInfo(stat, info);
                DatabaseTrainers.getMessages(stat, info);
            }
            return info;
        }
        catch (Exception e) {
            System.out.println("Error in database for trainer " + trainerName);
            return null;
        }
    }

    public static String getRandomName() {
        Connection conn = null;
        String name = "";
        try {
            conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT TRAINERNAME from TRAINER");
            ArrayList<String[]> nameList = new ArrayList<String[]>();
            while (rs.next()) {
                nameList.add(new String[]{rs.getString("TRAINERNAME")});
            }
            String[] result = (String[])nameList.get(RandomHelper.getRandomNumberBetween(0, nameList.size() - 1));
            name = result[0];
        }
        catch (Exception e) {
            System.out.println("Error in database for finding a random name");
        }
        return name;
    }

    private static void getMessages(Statement stat, TrainerInfo info) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT MESSAGE from TRAINERMESSAGES where TRAINERTYPEID=" + info.id + " AND MESSAGETYPE='Greeting'");
        ArrayList<String> greetings = new ArrayList<String>();
        if (rs.next()) {
            greetings.add(rs.getString("MESSAGE"));
        }
        rs = stat.executeQuery("SELECT MESSAGE from TRAINERMESSAGES where TRAINERTYPEID=" + info.id + " AND MESSAGETYPE='Victory'");
        ArrayList<String> victoryMessages = new ArrayList<String>();
        if (rs.next()) {
            victoryMessages.add(rs.getString("MESSAGE"));
        }
        rs = stat.executeQuery("SELECT MESSAGE from TRAINERMESSAGES where TRAINERTYPEID=" + info.id + " AND MESSAGETYPE='Defeat'");
        ArrayList<String> defeatMessages = new ArrayList<String>();
        if (rs.next()) {
            defeatMessages.add(rs.getString("MESSAGE"));
        }
        int ind = RandomHelper.getRandomNumberBetween(0, greetings.size() - 1);
        info.greeting = (String)greetings.get(ind);
        ind = RandomHelper.getRandomNumberBetween(0, victoryMessages.size() - 1);
        info.winMessage = (String)victoryMessages.get(ind);
        ind = RandomHelper.getRandomNumberBetween(0, defeatMessages.size() - 1);
        info.loseMessage = (String)defeatMessages.get(ind);
    }

    private static void getTrainerTypeInfo(Statement stat, TrainerInfo info) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT * from TRAINERTYPES where TRAINERTYPEID=" + info.id);
        if (rs.next()) {
            int baseLevel = rs.getInt("MINPARTYLEVEL");
            int topLevel = rs.getInt("MAXPARTYLEVEL");
            info.rarity = rs.getInt("RARITY");
            info.level = RandomHelper.getRandomNumberBetween(baseLevel, topLevel + 1);
        }
    }

    private static void getPartyPokemon(Statement stat, TrainerInfo info) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT * from TRAINERPIXELMONPOOL where TRAINERTYPEID=" + info.id);
        ArrayList<EnumPokemon> pokemonList = new ArrayList<EnumPokemon>();
        while (rs.next()) {
            pokemonList.add(Entity3HasStats.getBaseStatsFromDBID((int)rs.getInt((String)"PIXELMONID")).pokemon);
        }
        for (int i = 0; i < pokemonList.size(); ++i) {
            info.partypokemon.add((EnumPokemon)((Object)pokemonList.get(i)));
        }
    }

    private static void getNameAndModelForID(Statement stat, TrainerInfo info) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT * from TRAINER where TRAINERTYPEID=" + info.id);
        ArrayList<String[]> nameList = new ArrayList<String[]>();
        while (rs.next()) {
            nameList.add(new String[]{rs.getString("TRAINERNAME"), rs.getString("TRAINERMODEL")});
        }
        String[] result = (String[])nameList.get(RandomHelper.getRandomNumberBetween(0, nameList.size() - 1));
        info.name = result[0];
        info.model = EnumTrainerModel.parse(result[1]);
    }

    public static Integer[] GetSpawnBiomeIDs(String trainerName) {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from TRAINERSPAWNBIOMES where TRAINERTYPEID=SELECT TRAINERTYPEID FROM TRAINERTYPES WHERE TYPENAME='" + trainerName + "'");
            PixelmonBiomeDictionary.PixelmonBiomeInfo[] biomes = PixelmonBiomeDictionary.getBiomeInfoList();
            ArrayList<Integer> tempBiomeIDs = new ArrayList<Integer>();
            boolean isSpecificMatch = true;
            ArrayList dbtagsArray = new ArrayList();
            try {
                block4: while (rs.next()) {
                    String dbBiomeName = rs.getString("BIOMENAME");
                    for (int i = 0; i < biomes.length; ++i) {
                        if (biomes[i] == null || !biomes[i].isSameNameAs(dbBiomeName)) continue;
                        tempBiomeIDs.add(i);
                        continue block4;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rs.close();
            Integer[] biomeIDs = new Integer[tempBiomeIDs.size()];
            int j = 0;
            for (Integer i : tempBiomeIDs) {
                biomeIDs[j++] = i;
            }
            return biomeIDs;
        }
        catch (Exception e) {
            System.out.println("Error in biomes for trainer " + trainerName);
            return null;
        }
    }

    public static int getRarity(String name) {
        Connection conn = null;
        try {
            conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select RARITY from TRAINERTYPES WHERE TYPENAME='" + name + "'");
            boolean rarity = false;
            if (rs.next()) {
                return rs.getInt("RARITY");
            }
        }
        catch (Exception e) {
            System.out.println("Error in rarity for trainer " + name);
        }
        return 0;
    }
}

