/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.debug;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.database.DatabaseHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class DebugHelper {
    public static void langCheck(EntityPlayer player) {
        DebugHelper.checkMissingBlockLangEntries();
        DebugHelper.checkMissingItemLangEntries();
        DebugHelper.checkMissingPokemonLangEntries(player.func_130014_f_());
    }

    public static void effectRegistryCheck() {
        try {
            Connection conn = DatabaseHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from MOVES");
            int moveIndex = 0;
            while (rs.next()) {
                System.out.println("moveIndex " + moveIndex + " NAME " + rs.getString("NAME"));
                Attack attack = new Attack(moveIndex++, rs.getString("NAME"), rs);
                for (EffectBase effect : attack.baseAttack.effects) {
                }
            }
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkMissingPokemonLangEntries(World world) {
        for (EnumPokemon pokemon : EnumPokemon.values()) {
            EntityPixelmon test = new EntityPixelmon(world);
            test.init(pokemon.name);
            String langEntryName = "pixelmon." + pokemon.name.toLowerCase() + ".name";
            if (!StatCollector.func_94522_b((String)langEntryName)) {
                System.out.println("Pokemon " + pokemon.name + " Doesn't have a lang entry");
                continue;
            }
            System.out.println(StatCollector.func_150826_b((String)langEntryName));
        }
    }

    private static void checkMissingItemLangEntries() {
        for (Item item : GameData.getItemRegistry()) {
            if (!GameRegistry.findUniqueIdentifierFor((Item)item).modId.equals("pixelmon")) continue;
            String localName = item.func_77658_a();
            String itemName = item.func_77653_i(new ItemStack(item, 1));
            if (!localName.contains("item.")) continue;
            System.out.println("Item " + itemName + " Doesn't have a lang entry");
        }
    }

    private static void checkMissingBlockLangEntries() {
        for (Block block : GameData.getBlockRegistry()) {
            String localName;
            if (!GameRegistry.findUniqueIdentifierFor((Block)block).modId.equals("pixelmon") || !(localName = block.func_149732_F()).contains("tile.")) continue;
            System.out.println(localName);
            System.out.println("Block " + block.getClass().getName() + " Doesn't have a lang entry");
        }
    }
}

