/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.util.helpers.EntityHelper;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityLookHelper;

public class DeltaListener {
    protected DeltaMemory[] storage = new DeltaMemory[7];
    public final EntityLiving entity;

    public DeltaListener(EntityLiving entity, EnumEntityValue ... readThese) {
        this.entity = entity;
        for (EnumEntityValue axis : readThese) {
            this.storage[axis.ordinal()] = new DeltaMemory(axis);
        }
    }

    public boolean isListening(EnumEntityValue axis) {
        return this.storage[axis.ordinal()] != null;
    }

    public void startListening(EnumEntityValue axis) {
        if (!this.isListening(axis)) {
            this.storage[axis.ordinal()] = new DeltaMemory(axis);
        }
    }

    public void update() {
        for (int i = 0; i < 3; ++i) {
            if (this.storage[i] == null) continue;
            this.storage[i].storeDelta(this.storage[i].axis.getDelta(this.entity));
        }
    }

    public double getDelta(EnumEntityValue axis) {
        if (this.storage[axis.ordinal()] == null) {
            this.storage[axis.ordinal()] = new DeltaMemory(axis);
        }
        return this.storage[axis.ordinal()].result;
    }

    public static enum EnumEntityValue {
        x(EnumRotation.x, false),
        y(EnumRotation.y, false),
        z(EnumRotation.z, false),
        pitch(EnumRotation.x, true),
        yaw(EnumRotation.y, true),
        headPitch(EnumRotation.x, true),
        headYaw(EnumRotation.y, true);

        public final EnumRotation theAxis;
        public final boolean isRotation;
        public static Field lookHelperDeltaYaw;
        public static Field lookHelperDeltaPitch;

        private EnumEntityValue(EnumRotation theAxis, boolean isRotation) {
            this.theAxis = theAxis;
            this.isRotation = isRotation;
        }

        public double getDelta(EntityLiving entity) {
            try {
                switch (this) {
                    case headPitch: {
                        return lookHelperDeltaPitch.getFloat(entity.func_70671_ap());
                    }
                    case headYaw: {
                        return lookHelperDeltaYaw.getFloat(entity.func_70671_ap());
                    }
                    case yaw: {
                        return entity.field_70177_z - entity.field_70126_B;
                    }
                    case pitch: {
                        return entity.field_70125_A - entity.field_70127_C;
                    }
                    case x: 
                    case y: 
                    case z: {
                        return EntityHelper.getLocalMotion((Entity)entity, this.theAxis);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Double.NaN;
        }

        static {
            Field[] lookHelperFields = EntityLookHelper.class.getDeclaredFields();
            lookHelperDeltaYaw = lookHelperFields[1];
            lookHelperDeltaPitch = lookHelperFields[2];
            lookHelperDeltaYaw.setAccessible(true);
            lookHelperDeltaPitch.setAccessible(true);
        }
    }

    protected static class DeltaMemory {
        public final EnumEntityValue axis;
        protected float prevRot;
        protected float nowRot;
        public final double[] prevValues = new double[10];
        public double result;

        public DeltaMemory(EnumEntityValue axis) {
            this.axis = axis;
        }

        public void storeDelta(double value) {
            this.result = value;
            for (int i = 9; i > 0; --i) {
                this.prevValues[i] = this.prevValues[i - 1];
                this.result += this.prevValues[i];
            }
            this.prevValues[0] = value;
            this.result /= 10.0;
        }
    }
}

