/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.custom;

import com.pixelmonmod.pixelmon.client.models.custom.ModelClaw;
import com.pixelmonmod.pixelmon.client.models.custom.ModelClawBase;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumMovement;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.util.Bounds;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityClaw
extends Entity {
    Integer defaultHeight;
    Bounds bounds;
    EntityPlayerMP owner;
    boolean allowInteraction = true;
    boolean isLowering = true;
    private static final float movement = 0.3f;
    private static final float descent = 0.5f;
    private float movementModifier = 1.0f;
    private float descentModifier = 1.0f;
    private float clawBoundingBoxRadius = 0.25f;
    private Vector2d movementForward;
    private Vector2d movementBack;
    private Vector2d movementStrafeLeft;
    private Vector2d movementStrafeRight;
    static ModelClaw model;

    public EntityClaw(World world, EntityPlayerMP owner, Bounds bounds, Integer defaultHeight) {
        this(world);
        this.bounds = bounds;
        this.defaultHeight = defaultHeight;
        this.owner = owner;
        this.setMovementVectors();
    }

    public EntityClaw(World world) {
        super(world);
    }

    private void setMovementVectors() {
        double oX = this.owner.field_70165_t;
        double oZ = this.owner.field_70161_v;
        double cX = (double)(this.bounds.left + this.bounds.right) / 2.0;
        double cZ = (double)(this.bounds.top + this.bounds.bottom) / 2.0;
        this.movementForward = new Vector2d(cX - oX, cZ - oZ);
        this.movementForward.normalize();
        this.movementBack = new Vector2d(this.movementForward.x, this.movementForward.y);
        this.movementBack.scale(-1.0);
        Vector3d forward3 = new Vector3d(this.movementForward.x, 0.0, this.movementForward.y);
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        Vector3d strafe = new Vector3d();
        strafe.cross(forward3, up);
        this.movementStrafeRight = new Vector2d(strafe.x, strafe.z);
        this.movementStrafeRight.normalize();
        this.movementStrafeLeft = new Vector2d(this.movementStrafeRight.x, this.movementStrafeRight.y);
        this.movementStrafeLeft.scale(-1.0);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    public boolean func_70039_c(NBTTagCompound p_70039_1_) {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void setPosition(Vec3 vec) {
        this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    private float getMovement() {
        return 0.3f * this.movementModifier;
    }

    private float getDescent() {
        return 0.5f * this.descentModifier;
    }

    public void doMovement(EnumMovement[] movements) {
        if (this.allowInteraction) {
            for (EnumMovement movement : movements) {
                if (movement == EnumMovement.Forward) {
                    this.addVectorToPos(this.movementForward);
                    continue;
                }
                if (movement == EnumMovement.Back) {
                    this.addVectorToPos(this.movementBack);
                    continue;
                }
                if (movement == EnumMovement.Right) {
                    this.addVectorToPos(this.movementStrafeRight);
                    continue;
                }
                if (movement == EnumMovement.Left) {
                    this.addVectorToPos(this.movementStrafeLeft);
                    continue;
                }
                if (movement != EnumMovement.Jump) continue;
                this.allowInteraction = false;
                this.isLowering = true;
                break;
            }
            this.checkBounds();
        }
    }

    private void addVectorToPos(Vector2d vec) {
        this.field_70165_t += vec.x * (double)this.getMovement();
        this.field_70161_v += vec.y * (double)this.getMovement();
    }

    private void checkBounds() {
        if (this.field_70165_t < (double)this.bounds.left) {
            this.field_70165_t = this.bounds.left;
        }
        if (this.field_70165_t > (double)this.bounds.right) {
            this.field_70165_t = this.bounds.right;
        }
        if (this.field_70161_v < (double)this.bounds.bottom) {
            this.field_70161_v = this.bounds.bottom;
        }
        if (this.field_70161_v > (double)this.bounds.top) {
            this.field_70161_v = this.bounds.top;
        }
    }

    public void func_70071_h_() {
        if (!this.allowInteraction) {
            if (this.isLowering) {
                if (this.field_70170_p.func_147437_c((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u - (double)this.getDescent()), (int)Math.floor(this.field_70161_v))) {
                    this.field_70163_u -= (double)this.getDescent();
                } else {
                    this.doClosingAnimation();
                    this.isLowering = false;
                }
                this.checkForCollision();
            } else if (this.field_70163_u + (double)this.getDescent() < (double)this.defaultHeight.intValue()) {
                this.field_70163_u += (double)this.getDescent();
            } else {
                this.field_70163_u = this.defaultHeight.intValue();
                this.allowInteraction = true;
                this.isLowering = true;
                if (this.field_70153_n != null && this.field_70153_n instanceof EntityPixelmon) {
                    this.addPokemonToPlayer(this.field_70153_n.getEntityData());
                    this.field_70153_n.func_70106_y();
                }
            }
        }
    }

    public void checkForCollision() {
        this.checkForPixelmonCollision();
        this.checkForPowerupCollision();
    }

    public void checkForPowerupCollision() {
    }

    public void checkForPixelmonCollision() {
        AxisAlignedBB hitbox = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)this.clawBoundingBoxRadius), (double)(this.field_70163_u - (double)this.clawBoundingBoxRadius), (double)(this.field_70161_v - (double)this.clawBoundingBoxRadius), (double)(this.field_70165_t + (double)this.clawBoundingBoxRadius), (double)(this.field_70163_u + (double)this.clawBoundingBoxRadius), (double)(this.field_70161_v + (double)this.clawBoundingBoxRadius));
        List entities = this.field_70170_p.func_72872_a(EntityPixelmon.class, hitbox);
        if (!entities.isEmpty()) {
            Collections.shuffle(entities);
            for (Entity entity : entities) {
                if (!(entity instanceof EntityPixelmon)) continue;
                entity.func_70078_a((Entity)this);
                this.doClosingAnimation();
                this.isLowering = false;
                break;
            }
        }
    }

    public void doClosingAnimation() {
    }

    public void addPokemonToPlayer(NBTTagCompound nbt) {
        try {
            if (this.owner != null) {
                PixelmonStorage.PokeballManager.getPlayerStorage(this.owner).addToParty((EntityPixelmon)PixelmonEntityList.createEntityFromNBT(nbt, this.field_70170_p));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isOwnedBy(EntityPlayerMP owner) {
        return this.owner.func_110124_au().equals(owner.func_110124_au());
    }

    public ModelClawBase getModel() {
        if (model == null) {
            model = new ModelClaw();
        }
        return model;
    }
}

