/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.items.heldItems.ItemGems;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class EntityHalloween
extends EntityNPC {
    ModelBase model;
    public boolean persistent = false;

    public EntityHalloween(World world) {
        super(world);
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/pokemon/pokemon-halloween/haunter.png";
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.persistent;
    }

    @Override
    public ModelBase getModel() {
        if (this.model == null) {
            this.loadModel();
        }
        return this.model;
    }

    private void loadModel() {
        if (Pixelmon.proxy.isModelStatic("Haunter")) {
            if (Pixelmon.proxy.getModels().length == 0) {
                return;
            }
            int n = 93;
            if (Pixelmon.proxy.getModels()[n] != null) {
                Object mod = Pixelmon.proxy.getModels()[n];
                if (mod instanceof ModelBase) {
                    this.model = (ModelBase)mod;
                }
            } else {
                ModelBase m = Pixelmon.proxy.loadModel("Haunter");
                Pixelmon.proxy.getModels()[n] = m;
                this.model = m;
            }
        } else {
            ModelBase m;
            this.model = m = Pixelmon.proxy.loadModel("Haunter");
        }
    }

    @Override
    public EnumBossMode getBossMode() {
        return EnumBossMode.NotBoss;
    }

    @Override
    public String getDisplayText() {
        return I18n.func_135052_a((String)"halloween.entityname", (Object[])new Object[0]);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    @Override
    public boolean func_70085_c(EntityPlayer pl) {
        if (pl instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)pl;
            try {
                PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage(player);
                if (storage.playerData.finishedQuest()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("halloween.alreadyawarded", new Object[0]));
                    return false;
                }
                if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemGems && player.func_70694_bm().func_77978_p().func_74764_b("specialEvent")) {
                    if (storage.playerData.registerGem(player.func_70694_bm().func_77973_b())) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("halloween.gemregistered", new Object[]{player.func_70694_bm().func_82833_r()}));
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_146026_a(player.func_71045_bC().func_77973_b());
                        }
                        if (storage.playerData.finishedQuest()) {
                            EntityPixelmon pokemon = new EntityPixelmon(this.field_70170_p);
                            pokemon.init("Misdreavus");
                            pokemon.makeEntityIntoEgg();
                            storage.addToParty(pokemon);
                        }
                        return true;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("halloween.alreadyregistered", new Object[]{player.func_70694_bm().func_82833_r()}));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("halloween.message", new Object[0]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

