/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.database.DatabaseTrades;
import com.pixelmonmod.pixelmon.database.DatabaseTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCType;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumTrainerModel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityTrader
extends EntityNPC {
    private TradePair tradePair;
    public static final int dwLevel = 27;
    public static final int dwShiny = 28;
    public static final int dwTrade = 29;
    public static final int dwOffer = 30;
    public static final int dwExchange = 31;
    private static int idIndex = 0;
    ModelBase model = null;

    public EntityTrader(World par1World) {
        super(par1World, NPCType.Trader);
        this.setName("Trader");
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70180_af.func_75682_a(4, (Object)-1);
        this.field_70180_af.func_75682_a(29, (Object)-1);
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(31, (Object)"null");
        this.field_70180_af.func_75682_a(30, (Object)"null");
        this.field_70180_af.func_75682_a(27, (Object)10);
    }

    public void func_110159_bB() {
        if (this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void init(String name) {
        ArrayList<String> pokemon;
        if (this.field_70180_af.func_75679_c(4) == -1) {
            EnumTrainerModel[] thing = EnumTrainerModel.values();
            this.field_70180_af.func_75692_b(4, (Object)RandomHelper.getRandomNumberBetween(1, thing.length - 1));
        }
        this.field_70180_af.func_75692_b(27, (Object)this.field_70180_af.func_75679_c(27));
        if (!this.hasTrade()) {
            this.field_70180_af.func_75692_b(29, (Object)DatabaseTrades.assignRandomTradeID());
        }
        if (this.field_70180_af.func_75679_c(29) == -2) {
            this.tradePair = new TradePair(EnumPokemon.getFromName(this.field_70180_af.func_75681_e(31)), EnumPokemon.getFromName(this.field_70180_af.func_75681_e(30)));
        }
        if (this.field_70180_af.func_75681_e(26).equalsIgnoreCase("")) {
            this.field_70180_af.func_75692_b(26, (Object)DatabaseTrainers.getRandomName());
        }
        if (EnumPokemon.hasPokemon((pokemon = DatabaseTrades.getTradeFromDatabase(this.field_70180_af.func_75679_c(29))).get(0)) && EnumPokemon.hasPokemon(pokemon.get(1))) {
            this.field_70180_af.func_75692_b(31, (Object)pokemon.get(0));
            this.field_70180_af.func_75692_b(30, (Object)pokemon.get(1));
            this.tradePair = this.getTradePair(pokemon);
        } else {
            this.setNewTrade();
            this.init(name);
        }
        if (this.getId() == -1) {
            this.setId(idIndex++);
        }
    }

    public void setNewTrade() {
        this.field_70180_af.func_75692_b(29, (Object)DatabaseTrades.assignRandomTradeID());
    }

    public TradePair getTradePair(ArrayList<String> pokemon) {
        return new TradePair(EnumPokemon.getFromName(pokemon.get(0)), EnumPokemon.getFromName(pokemon.get(1)));
    }

    public TradePair getTrade() {
        return new TradePair(EnumPokemon.getFromName(this.field_70180_af.func_75681_e(31)), EnumPokemon.getFromName(this.field_70180_af.func_75681_e(30)));
    }

    public void unloadEntity() {
        this.func_70623_bb();
        this.func_70106_y();
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            this.updateTradePair();
            int id = this.getId();
            if (player.func_70694_bm() == null) {
                player.openGui((Object)Pixelmon.instance, EnumGui.NPCTraderGui.getIndex().intValue(), player.field_70170_p, id, 0, 0);
            } else if (player.func_70694_bm().func_77973_b() == PixelmonItems.trainerEditor) {
                player.openGui((Object)Pixelmon.instance, EnumGui.NPCTrade.getIndex().intValue(), player.field_70170_p, id, 0, 0);
            }
        }
        return true;
    }

    public boolean hasTrade() {
        return this.field_70180_af.func_75679_c(29) != -1;
    }

    @Override
    public ModelBase getModel() {
        EnumTrainerModel m = EnumTrainerModel.getFromInt(this.field_70180_af.func_75679_c(4));
        if (this.model == null) {
            this.model = Pixelmon.proxy.getNPCModel(NPCType.Trainer, m.toString());
        }
        return this.model;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        EnumTrainerModel m = EnumTrainerModel.getFromInt(this.field_70180_af.func_75679_c(4));
        return "pixelmon:textures/trainers/" + m.toString().toLowerCase() + ".png";
    }

    public void updateTradePair() {
        if (this.field_70180_af.func_75679_c(29) != -2) {
            ArrayList<String> pokemon = DatabaseTrades.getTradeFromDatabase(this.field_70180_af.func_75679_c(29));
            if (!EnumPokemon.hasPokemon(pokemon.get(0)) || !EnumPokemon.hasPokemon(pokemon.get(1))) {
                this.init(this.getName());
            }
            this.tradePair = this.getTradePair(pokemon);
            this.field_70180_af.func_75692_b(31, (Object)pokemon.get(0));
            this.field_70180_af.func_75692_b(30, (Object)pokemon.get(1));
        } else {
            this.tradePair = new TradePair(EnumPokemon.getFromName(this.field_70180_af.func_75681_e(31)), EnumPokemon.getFromName(this.field_70180_af.func_75681_e(30)));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("TradePair", this.field_70180_af.func_75679_c(29));
        this.updateTradePair();
        nbt.func_74778_a("Offer", this.field_70180_af.func_75681_e(30));
        nbt.func_74778_a("Exchange", this.field_70180_af.func_75681_e(31));
        nbt.func_74768_a("ModelIndex", this.field_70180_af.func_75679_c(4));
        nbt.func_74768_a("Shiny", this.field_70180_af.func_75679_c(28));
        nbt.func_74768_a("Lvl", 27);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_75692_b(29, (Object)nbt.func_74762_e("TradePair"));
        if (nbt.func_74764_b("ModelIndex")) {
            this.field_70180_af.func_75692_b(4, (Object)nbt.func_74762_e("ModelIndex"));
        }
        this.field_70180_af.func_75692_b(31, (Object)nbt.func_74779_i("Exchange"));
        this.field_70180_af.func_75692_b(30, (Object)nbt.func_74779_i("Offer"));
        this.field_70180_af.func_75692_b(28, (Object)nbt.func_74762_e("Shiny"));
        this.field_70180_af.func_75692_b(27, (Object)nbt.func_74762_e("Lvl"));
    }

    public void updateTrade(String exchange, String offer) {
        this.field_70180_af.func_75692_b(31, (Object)exchange);
        this.field_70180_af.func_75692_b(30, (Object)offer);
    }

    public int getModelIndex() {
        return this.field_70180_af.func_75679_c(4);
    }

    public static EntityTrader locateTrader(World world, int id) {
        List entityList = world.field_72996_f;
        for (Object entity : entityList) {
            if (!(entity instanceof EntityTrader) || ((EntityTrader)((Object)entity)).getId() != id) continue;
            return (EntityTrader)((Object)entity);
        }
        return null;
    }

    @Override
    public EnumBossMode getBossMode() {
        return EnumBossMode.NotBoss;
    }

    @Override
    public String getDisplayText() {
        return this.getName();
    }

    public class TradePair {
        public EnumPokemon offer;
        public EnumPokemon exchangefor;

        public TradePair(EnumPokemon offer, EnumPokemon exchangefor) {
            this.offer = offer;
            this.exchangefor = exchangefor;
        }
    }
}

