/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.AI.AIMoveTowardsTarget;
import com.pixelmonmod.pixelmon.AI.AIStartBattle;
import com.pixelmonmod.pixelmon.AI.AITargetNearest;
import com.pixelmonmod.pixelmon.AI.AITrainerInBattle;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.BeatTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.LostToTrainerEvent;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.IBattlingNPC;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.TrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.BossDropPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerEditor.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerEditor.StoreTrainerPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.database.DatabaseTrainers;
import com.pixelmonmod.pixelmon.database.TrainerInfo;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumSteveTextures;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.EnumTrainerModel;
import com.pixelmonmod.pixelmon.items.ItemTrainerEditor;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class EntityTrainer
extends EntityNPC
implements IBattlingNPC {
    public static int dwModel = 4;
    public static int dwEncounterMode = 19;
    public static int dwSteveTexture = 20;
    public static int dwBossMode = 21;
    public static int dwTrainerAI = 23;
    public static int dwTrainerLevel = 25;
    public static int dwCustomSteveTexture = 27;
    private PlayerStorage pokemonStorage = new PlayerStorage(this);
    private TrainerInfo info;
    public static int idIndex = 0;
    String greeting = "";
    String winMessage = "";
    String loseMessage = "";
    Item[] winnings = new Item[0];
    private boolean startRotationSet = false;
    private float startRotationYaw;
    public static boolean isOPOnly = false;
    public boolean ignoreDespawnCounter = false;
    public int despawnCounter = -1;
    public static int despawnRadius = 20;
    public static int TICKSPERSECOND = 20;
    public static int intMinTicksToDespawn = 30 * TICKSPERSECOND;
    public static int intMaxTicksToDespawn = 180 * TICKSPERSECOND;
    public HashMap<String, Long> playerEncounters = new HashMap();
    public ArrayList<String> winCommands = new ArrayList();
    public ArrayList<String> loseCommands = new ArrayList();
    public BattleControllerBase battleController;
    ModelBase model = null;
    String oldName = null;

    public EntityTrainer(World par1World) {
        super(par1World, NPCType.Trainer);
        this.field_70180_af.func_75682_a(dwModel, (Object)-1);
        this.field_70180_af.func_75682_a(dwEncounterMode, (Object)0);
        this.field_70180_af.func_75682_a(dwSteveTexture, (Object)"");
        this.field_70180_af.func_75682_a(dwBossMode, (Object)0);
        this.field_70180_af.func_75682_a(dwTrainerAI, (Object)((short)EnumTrainerAI.Wander.ordinal()));
        this.field_70180_af.func_75682_a(dwCustomSteveTexture, (Object)"");
        this.field_70180_af.func_75682_a(dwTrainerLevel, (Object)0);
        this.initAI();
    }

    @Override
    public void init(String name) {
        super.init(name);
        this.pokemonStorage = new PlayerStorage(this);
        this.info = DatabaseTrainers.GetTrainerInfo(name);
        if (this.info == null) {
            if (PixelmonConfig.printErrors) {
                System.out.println("Database entry error/missing for trainer " + name);
            }
            this.func_70106_y();
            return;
        }
        if (this.getId() == -1) {
            this.setId(idIndex++);
        }
        this.greeting = this.info.greeting;
        this.winMessage = this.info.winMessage;
        this.loseMessage = this.info.loseMessage;
        this.field_70180_af.func_75692_b(dwTrainerLevel, (Object)((short)this.info.level));
        if (this.info.model != null) {
            this.setModel(this.info.model);
            this.field_70180_af.func_75692_b(26, (Object)this.info.name);
        }
    }

    public void setEncounterMode(EnumEncounterMode mode) {
        this.field_70180_af.func_75692_b(dwEncounterMode, (Object)((short)mode.ordinal()));
    }

    public EnumEncounterMode getEncounterMode() {
        return EnumEncounterMode.getFromIndex(this.field_70180_af.func_75693_b(dwEncounterMode));
    }

    public void setModel(EnumTrainerModel model) {
        this.field_70180_af.func_75692_b(dwModel, (Object)((short)model.ordinal()));
    }

    public void setModel(EnumTrainerModel model, EntityPlayer player) {
        this.init(model.trainerType);
        if (model == EnumTrainerModel.Steve) {
            this.setSteveTexture(EnumSteveTextures.getFromIndex(0).toString());
        }
        this.setModel(model);
        this.loadPokemon();
        Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), (EntityPlayerMP)player);
        for (int i = 0; i < this.pokemonStorage.count(); ++i) {
            Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(new PixelmonData(this.pokemonStorage.getList()[i])), (EntityPlayerMP)player);
        }
    }

    public void func_110159_bB() {
        if (this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
    }

    public void func_70024_g(double par1, double par3, double par5) {
        if (this.func_70104_M()) {
            super.func_70024_g(par1, par3, par5);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        EnumTrainerAI ai = this.getAIMode();
        return ai != EnumTrainerAI.StandStill && ai != EnumTrainerAI.StillAndEngage;
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.ignoreDespawnCounter;
    }

    public void func_70071_h_() {
        if (this.func_70692_ba() && !this.field_70170_p.field_72995_K) {
            this.checkForRarityDespawn();
        }
        if (this.startRotationSet && this.getAIMode() == EnumTrainerAI.StillAndEngage) {
            this.field_70177_z = this.startRotationYaw;
            this.field_70759_as = this.startRotationYaw;
        }
        super.func_70071_h_();
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return false;
    }

    private void checkForRarityDespawn() {
        if (this.battleController != null) {
            return;
        }
        if (this.despawnCounter > 0) {
            --this.despawnCounter;
        } else if (this.despawnCounter == 0) {
            if (!this.playersNearby()) {
                this.func_70106_y();
            }
        } else {
            this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
        }
    }

    private boolean playersNearby() {
        boolean playerNearby = false;
        for (int i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
            double distancex = player.field_70165_t - this.field_70165_t;
            double distancey = player.field_70163_u - this.field_70163_u;
            double distancez = player.field_70161_v - this.field_70161_v;
            double distancesquared = distancex * distancex + distancey * distancey + distancez * distancez;
            if (!(distancesquared < (double)(despawnRadius * despawnRadius))) continue;
            playerNearby = true;
            break;
        }
        return playerNearby;
    }

    @Override
    public EntityPixelmon releasePokemon() {
        EntityPixelmon p;
        if (this.pokemonStorage.count() == 0) {
            this.loadPokemon();
        }
        if ((p = this.pokemonStorage.getFirstAblePokemon(this.field_70170_p)) != null && !p.isEgg && !this.pokemonStorage.EntityAlreadyExists(p)) {
            p.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            p.releaseFromPokeball();
        }
        return p;
    }

    @Override
    public boolean hasAblePokemon() {
        return this.pokemonStorage.countAblePokemon() != 0;
    }

    public void loadPokemon() {
        if (this.info == null || this.info.partypokemon == null || this.info.partypokemon.size() == 0) {
            EntityPixelmon p = (EntityPixelmon)PixelmonEntityList.createEntityByName("Rattata", this.field_70170_p);
            if (p != null) {
                p.getLvl().setLevel(new Random().nextInt(3) - 1 + 5);
                p.func_70606_j(p.stats.HP);
                p.setTrainer(this);
                this.pokemonStorage.addToParty(p);
            }
        } else {
            int numPokemon = RandomHelper.getRandomNumberBetween(1, 6);
            for (int i = 0; i < numPokemon; ++i) {
                EnumPokemon pokemon = this.info.partypokemon.get(RandomHelper.getRandomNumberBetween(0, this.info.partypokemon.size() - 1));
                EntityPixelmon p = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemon.name, this.field_70170_p);
                if (p == null) continue;
                p.getLvl().setLevel(new Random().nextInt(3) - 1 + this.info.level);
                p.func_70606_j(p.stats.HP);
                p.setTrainer(this);
                this.pokemonStorage.addToParty(p);
            }
        }
    }

    @Override
    public void startBattle(BattleParticipant battleParticipant) {
        if (battleParticipant instanceof PlayerParticipant) {
            PlayerParticipant player = (PlayerParticipant)battleParticipant;
            if (this.getEncounterMode() == EnumEncounterMode.OncePerMCDay) {
                this.playerEncounters.put(player.player.getDisplayName(), this.field_70170_p.func_82737_E());
            } else if (this.getEncounterMode() == EnumEncounterMode.OncePerDay) {
                this.playerEncounters.put(player.player.getDisplayName(), System.currentTimeMillis());
            }
            if (this.greeting != null) {
                ChatHandler.sendBattleMessage((Entity)player.player, this.info.name + ": " + this.greeting, new Object[0]);
            }
        }
        this.healAllPokemon();
    }

    @Override
    public void loseBattle(ArrayList<BattleParticipant> opponents) {
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            EntityPlayerMP player = (EntityPlayerMP)opponents.get(0).getEntity();
            if (this.loseMessage != null) {
                ChatHandler.sendBattleMessage(opponents, this.loseMessage, new Object[0]);
            }
            Pixelmon.EVENT_BUS.post((Event)new BeatTrainerEvent((EntityPlayer)player, this));
            if (this.getEncounterMode() == EnumEncounterMode.Once) {
                this.func_70623_bb();
                this.func_70106_y();
            } else {
                this.healAllPokemon();
                if (this.getEncounterMode() == EnumEncounterMode.OncePerPlayer) {
                    this.playerEncounters.put(player.getDisplayName(), this.field_70170_p.func_82737_E());
                }
            }
            if (this.winnings.length > 0) {
                for (int i = 0; i < this.winnings.length; ++i) {
                    Item item = this.winnings[i];
                    DropItemHelper.giveItemStackToPlayer(player, new ItemStack(item));
                }
                BossDropPacket p = new BossDropPacket(false, this.winnings);
                Pixelmon.network.sendTo((IMessage)p, player);
            }
            if (this.info.model != null && (this.info.model.toString().equals("Fisherman") || this.info.model.toString().equals("Fisherman2") || this.info.model.toString().equals("Fisherman3"))) {
                int number = RandomHelper.getRandomNumberBetween(1, 100);
                int number2 = RandomHelper.getRandomNumberBetween(1, 1000);
                if (number == 43) {
                    DropItemHelper.giveItemStackToPlayer(player, new ItemStack(PixelmonItems.goodRod));
                    ChatHandler.sendFormattedChat((EntityPlayer)player, EnumChatFormatting.GREEN, "pixelmon.entitytrainer.goodrod", new Object[0]);
                } else if (number2 == 564) {
                    DropItemHelper.giveItemStackToPlayer(player, new ItemStack(PixelmonItems.superRod));
                    ChatHandler.sendFormattedChat((EntityPlayer)player, EnumChatFormatting.GREEN, "pixelmon.entitytrainer.superrod", new Object[0]);
                }
            }
        }
    }

    @Override
    public void winBattle(ArrayList<BattleParticipant> opponents) {
        if (this.winMessage != null) {
            ChatHandler.sendBattleMessage(opponents, this.winMessage, new Object[0]);
        }
        if (opponents.size() == 1 && opponents.get(0) instanceof PlayerParticipant) {
            EntityPlayerMP player = (EntityPlayerMP)opponents.get(0).getEntity();
            Pixelmon.EVENT_BUS.post((Event)new LostToTrainerEvent((EntityPlayer)player, this));
        }
    }

    public void retrievePokemon(EntityPixelmon releasedPokemon) {
        if (releasedPokemon != null) {
            releasedPokemon.unloadEntity();
        }
    }

    @Override
    public void healAllPokemon() {
        this.pokemonStorage.healAllPokemon();
    }

    @Override
    public int[] getNextPokemonID() {
        EntityPixelmon p = this.pokemonStorage.getFirstAblePokemon(this.field_70170_p);
        return p.getPokemonId();
    }

    public int getLvl() {
        return this.field_70180_af.func_75693_b(dwTrainerLevel);
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean interactWithNPC(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ItemStack itemstack = player.func_71045_bC();
            System.out.println(this.getId());
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemTrainerEditor) {
                if (isOPOnly && MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71262_S()) {
                    if (MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH())) {
                        UserListOpsEntry userlistopsentry = (UserListOpsEntry)MinecraftServer.func_71276_C().func_71203_ab().func_152603_m().func_152683_b((Object)player.func_146103_bH());
                        if (userlistopsentry.func_152644_a() != 4) {
                            ChatHandler.sendChat((Entity)player, "trainer.edit.opwarning", new Object[0]);
                            return false;
                        }
                    } else {
                        ChatHandler.sendChat((Entity)player, "trainer.edit.opwarning", new Object[0]);
                        return false;
                    }
                }
                this.ignoreDespawnCounter = true;
                if (this.pokemonStorage.count() == 0) {
                    this.loadPokemon();
                }
                this.field_70714_bg.field_75782_a.clear();
                player.openGui((Object)Pixelmon.instance, EnumGui.TrainerEditor.getIndex().intValue(), player.field_70170_p, this.getId(), 0, 0);
                Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), (EntityPlayerMP)player);
                for (int i = 0; i < this.pokemonStorage.count(); ++i) {
                    Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(new PixelmonData(this.pokemonStorage.getList()[i])), (EntityPlayerMP)player);
                }
                TrainerData p = new TrainerData(this.greeting, this.winMessage, this.loseMessage, this.winnings);
                Pixelmon.network.sendTo((IMessage)new SetTrainerData(p), (EntityPlayerMP)player);
            }
        } else {
            this.field_70714_bg.field_75782_a.clear();
        }
        return super.func_70085_c(player);
    }

    @Override
    public ModelBase getModel() {
        if (this.model == null || !this.oldName.equals(this.getName())) {
            this.model = Pixelmon.proxy.getTrainerModel(this);
            this.oldName = this.getName();
        }
        return this.model;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("ModelIndex", (int)this.field_70180_af.func_75693_b(4));
        NBTTagCompound pokemonNbt = new NBTTagCompound();
        this.pokemonStorage.writeToNBT(pokemonNbt);
        nbt.func_74782_a("pokeStore", (NBTBase)pokemonNbt);
        if (EnumTrainerModel.getFromInt(this.field_70180_af.func_75693_b(4)) == EnumTrainerModel.Steve) {
            nbt.func_74778_a("SteveTexture", this.getSteveTexture());
        }
        nbt.func_74777_a("BossMode", (short)this.getBossMode().index);
        nbt.func_74778_a("Greeting", this.greeting);
        nbt.func_74778_a("WinMessage", this.winMessage);
        nbt.func_74778_a("LoseMessage", this.loseMessage);
        int[] tmpWinnings = new int[this.winnings.length];
        for (int i = 0; i < this.winnings.length; ++i) {
            tmpWinnings[i] = Item.func_150891_b((Item)this.winnings[i]);
        }
        nbt.func_74783_a("Winnings", tmpWinnings);
        nbt.func_74757_a("IsPersistent", this.ignoreDespawnCounter);
        EnumEncounterMode mode = this.getEncounterMode();
        nbt.func_74777_a("EncMode", (short)mode.ordinal());
        if (mode != EnumEncounterMode.Once) {
            nbt.func_74768_a("numEncounters", this.playerEncounters.size());
            Iterator<Map.Entry<String, Long>> it = this.playerEncounters.entrySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry<String, Long> pairs = it.next();
                nbt.func_74778_a("encPl" + i, pairs.getKey());
                if (mode != EnumEncounterMode.OncePerPlayer) {
                    nbt.func_74772_a("encTi" + i, pairs.getValue().longValue());
                }
                ++i;
            }
        }
        nbt.func_74777_a("AIMode", (short)this.getAIMode().ordinal());
        if (this.getAIMode() == EnumTrainerAI.StillAndEngage) {
            nbt.func_74776_a("TrainerRotation", this.startRotationYaw);
        }
        NBTTagCompound commandsNbt = new NBTTagCompound();
        this.writeCommandsToNBT(commandsNbt);
        nbt.func_74782_a("Commands", (NBTBase)commandsNbt);
        nbt.func_74778_a("CustomSteveTexture", this.getCustomSteveTexture());
    }

    public void writeCommandsToNBT(NBTTagCompound var1) {
        NBTTagList winList = new NBTTagList();
        for (int i = 0; i < this.winCommands.size(); ++i) {
            winList.func_74742_a((NBTBase)new NBTTagString(this.winCommands.get(i)));
        }
        var1.func_74782_a("winCommands", (NBTBase)winList);
        NBTTagList loseList = new NBTTagList();
        for (int i = 0; i < this.loseCommands.size(); ++i) {
            loseList.func_74742_a((NBTBase)new NBTTagString(this.loseCommands.get(i)));
        }
        var1.func_74782_a("loseCommands", (NBTBase)loseList);
    }

    @Override
    public boolean canStartBattle(EntityPlayer opponent, boolean printMessages) {
        if (this.playerEncounters.get(opponent.getDisplayName()) != null) {
            EnumEncounterMode mode = this.getEncounterMode();
            if (mode == EnumEncounterMode.OncePerDay) {
                long oldTime;
                long oldDay;
                long curTime = System.currentTimeMillis();
                long curDay = curTime / 86400000L;
                if (curDay <= (oldDay = (oldTime = this.playerEncounters.get(opponent.getDisplayName()).longValue()) / 86400000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "Trainer can only be battled once a day", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerMCDay) {
                long oldTime;
                long oldDay;
                long curTime = this.field_70170_p.func_82737_E();
                long curDay = curTime / 24000L;
                if (curDay <= (oldDay = (oldTime = this.playerEncounters.get(opponent.getDisplayName()).longValue()) / 24000L)) {
                    if (printMessages) {
                        ChatHandler.sendChat((Entity)opponent, "Trainer can only be battled once a Minecraft day", new Object[0]);
                    }
                    return false;
                }
            } else if (mode == EnumEncounterMode.OncePerPlayer) {
                if (printMessages) {
                    ChatHandler.sendChat((Entity)opponent, "Trainer can only be battled once by each player", new Object[0]);
                }
                return false;
            }
        } else if (opponent != null && opponent.func_70694_bm() != null && opponent.func_70694_bm().func_77973_b() == PixelmonItems.trainerEditor) {
            return false;
        }
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        int i;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("ModelIndex")) {
            this.field_70180_af.func_75692_b(4, (Object)((short)nbt.func_74762_e("ModelIndex")));
            if (EnumTrainerModel.getFromInt(this.field_70180_af.func_75693_b(4)) == EnumTrainerModel.Steve) {
                this.setSteveTexture(nbt.func_74779_i("SteveTexture"));
            }
        }
        if (nbt.func_74764_b("BossMode")) {
            this.setBossMode(EnumBossMode.getMode(nbt.func_74765_d("BossMode")));
        }
        this.pokemonStorage.readFromNBT(nbt.func_74775_l("pokeStore"));
        if (nbt.func_74764_b("Greeting")) {
            this.greeting = nbt.func_74779_i("Greeting");
            this.winMessage = nbt.func_74779_i("WinMessage");
            this.loseMessage = nbt.func_74779_i("LoseMessage");
        }
        if (nbt.func_74764_b("Winnings")) {
            int[] testArray = nbt.func_74759_k("Winnings");
            ArrayList<Item> array = new ArrayList<Item>();
            for (i = 0; i < testArray.length; ++i) {
                array.add(Item.func_150899_d((int)testArray[i]));
            }
            this.winnings = new Item[array.size()];
            for (i = 0; i < array.size(); ++i) {
                this.winnings[i] = (Item)array.get(i);
            }
        }
        if (nbt.func_74764_b("TrainerRotation")) {
            this.setStartRotationYaw(nbt.func_74760_g("TrainerRotation"));
        }
        if (nbt.func_74764_b("EncMode")) {
            EnumEncounterMode mode = EnumEncounterMode.getFromIndex(nbt.func_74765_d("EncMode"));
            this.setEncounterMode(mode);
            int numEncounters = nbt.func_74762_e("numEncounters");
            for (i = 0; i < numEncounters; ++i) {
                String username = nbt.func_74779_i("encPl" + i);
                long time = 0L;
                if (mode != EnumEncounterMode.OncePerPlayer) {
                    time = nbt.func_74763_f("encTi" + i);
                }
                this.playerEncounters.put(username, time);
            }
        } else {
            this.setEncounterMode(EnumEncounterMode.Once);
        }
        if (nbt.func_74764_b("IsPersistent")) {
            this.ignoreDespawnCounter = nbt.func_74767_n("IsPersistent");
        }
        if (nbt.func_74764_b("AIMode")) {
            this.setAIMode(EnumTrainerAI.getFromOrdinal(nbt.func_74765_d("AIMode")));
            this.initAI();
        }
        if (nbt.func_74764_b("Commands")) {
            this.readCommandsFromNBT(nbt.func_74775_l("Commands"));
        }
        this.setCustomSteveTexture(nbt.func_74779_i("CustomSteveTexture"));
    }

    public void readCommandsFromNBT(NBTTagCompound nbt) {
        int i;
        if (nbt.func_74764_b("winCommands")) {
            NBTTagList wins = nbt.func_150295_c("winCommands", 8);
            for (i = 0; i < wins.func_74745_c(); ++i) {
                this.winCommands.add(wins.func_150307_f(i));
            }
        }
        if (nbt.func_74764_b("loseCommands")) {
            NBTTagList loss = nbt.func_150295_c("loseCommands", 8);
            for (i = 0; i < loss.func_74745_c(); ++i) {
                this.loseCommands.add(loss.func_150307_f(i));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        EnumTrainerModel m = EnumTrainerModel.getFromInt(this.field_70180_af.func_75693_b(dwModel));
        if (m != EnumTrainerModel.Steve) {
            return "pixelmon:textures/" + this.getNPCType().textureDirectory + "/" + m.toString().toLowerCase() + ".png";
        }
        if (this.getSteveTexture().equals(EnumSteveTextures.Custom_RP.toString())) {
            return "pixelmon:textures/trainers/steve/" + this.getCustomSteveTexture() + ".png";
        }
        return "pixelmon:textures/trainers/steve/" + this.getSteveTexture().toLowerCase() + ".png";
    }

    public String getSteveTexture() {
        return this.field_70180_af.func_75681_e(dwSteveTexture);
    }

    public void setSteveTexture(String tex) {
        this.field_70180_af.func_75692_b(dwSteveTexture, (Object)tex);
    }

    public int getModelIndex() {
        return this.field_70180_af.func_75693_b(dwModel);
    }

    public static EntityTrainer locateTrainer(World world, int id) {
        List entityList = world.field_72996_f;
        for (Object entity : entityList) {
            if (!(entity instanceof EntityTrainer) || ((EntityTrainer)entity).getId() != id) continue;
            return (EntityTrainer)entity;
        }
        return null;
    }

    public void randomisePokemon(EntityPlayer player) {
        int i;
        for (i = 0; i < 6; ++i) {
            this.pokemonStorage.getList()[i] = null;
        }
        this.loadPokemon();
        Pixelmon.network.sendTo((IMessage)new ClearTrainerPokemon(), (EntityPlayerMP)player);
        for (i = 0; i < this.pokemonStorage.count(); ++i) {
            Pixelmon.network.sendTo((IMessage)new StoreTrainerPokemon(new PixelmonData(this.pokemonStorage.getList()[i])), (EntityPlayerMP)player);
        }
    }

    @Override
    public EnumBossMode getBossMode() {
        return EnumBossMode.getMode(this.field_70180_af.func_75693_b(dwBossMode));
    }

    public void setBossMode(EnumBossMode mode) {
        this.field_70180_af.func_75692_b(dwBossMode, (Object)((short)mode.index));
    }

    public EnumTrainerAI getAIMode() {
        return EnumTrainerAI.getFromOrdinal(this.field_70180_af.func_75693_b(dwTrainerAI));
    }

    public void setAIMode(EnumTrainerAI mode) {
        this.field_70180_af.func_75692_b(dwTrainerAI, (Object)((short)mode.ordinal()));
    }

    public String getCustomSteveTexture() {
        return this.field_70180_af.func_75681_e(dwCustomSteveTexture);
    }

    public void setCustomSteveTexture(String tex) {
        this.field_70180_af.func_75692_b(dwCustomSteveTexture, (Object)tex);
    }

    @Override
    public boolean bindTexture() {
        EnumTrainerModel m = EnumTrainerModel.getFromInt(this.field_70180_af.func_75693_b(dwModel));
        if (m == EnumTrainerModel.Steve && this.getSteveTexture().equals("Custom_PN")) {
            if (!ClientProxy.bindPlayerTexture(this.getCustomSteveTexture())) {
                RenderManager.field_78727_a.field_78724_e.func_110577_a(AbstractClientPlayer.field_110314_b);
            }
            return true;
        }
        return false;
    }

    public void updateLvl() {
        int lvlTotal = 0;
        for (int i = 0; i < this.pokemonStorage.count(); ++i) {
            lvlTotal += this.pokemonStorage.getList()[i].func_74762_e("Level");
        }
        float lvl = (float)lvlTotal / (float)this.pokemonStorage.count();
        this.field_70180_af.func_75692_b(dwTrainerLevel, (Object)((short)lvl));
    }

    public void initAI() {
        this.field_70714_bg.field_75782_a.clear();
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPixelmon.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, SharedMonsterAttributes.field_111263_d.func_111110_b()));
                break;
            }
            case StillAndEngage: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIStartBattle(this));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AITargetNearest(this, 10.0f, true));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIMoveTowardsTarget(this, 10.0f));
                break;
            }
            case WanderAndEngage: {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITrainerInBattle(this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPixelmon.class, 6.0f));
                this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIStartBattle(this));
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveTowardsTarget(this, 10.0f));
                this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AITargetNearest(this, 10.0f, true));
            }
        }
    }

    public void update(TrainerData p) {
        this.greeting = p.greeting;
        this.loseMessage = p.lose;
        this.winMessage = p.win;
        this.winnings = p.winnings;
    }

    public void unloadEntity() {
        this.func_70623_bb();
        this.func_70106_y();
    }

    public void setStartRotationYaw(float f) {
        this.startRotationSet = true;
        this.startRotationYaw = f;
        this.field_70177_z = f;
        this.field_70759_as = f;
    }

    @Override
    public String getDisplayText() {
        String s = this.getBossMode() == EnumBossMode.NotBoss ? this.getNickName() + " Lv: " + this.getLvl() : this.getNickName();
        return s;
    }

    @Override
    public void setBattleController(BattleControllerBase battleController) {
        this.battleController = battleController;
    }

    @Override
    public BattleControllerBase getBattleController() {
        return this.battleController;
    }

    @Override
    public String getNPCName() {
        return this.info.name;
    }

    @Override
    public PlayerStorage getPokemonStorage() {
        return this.pokemonStorage;
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public void setAttackTargetPix(EntityLivingBase entity) {
        this.func_70624_b(entity);
    }
}

