/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.blocks.ranch.RanchBounds;
import com.pixelmonmod.pixelmon.blocks.ranch.TileEntityRanchBase;
import com.pixelmonmod.pixelmon.blocks.ranch.TileEntityRanchBlock;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity9HasSounds;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.BreedingParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.ParticleEffects;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemIsisHourglass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class Entity10CanBreed
extends Entity9HasSounds {
    public boolean isEgg = false;
    public boolean isRandomEgg = false;
    public EnumEggGroup group = EnumEggGroup.Undiscovered;
    public Integer eggCycles = 21;
    public boolean isInRanchBlock = false;
    public ParticleEffects[] breedingParticleEffects = null;
    private short lastBreedingLevels = (short)-1;
    public float breedingStrength = 0.0f;
    public long lastBreedingTime;
    int breedingCheckCount = 0;

    public Entity10CanBreed(World par1World) {
        super(par1World);
        this.field_70180_af.func_75682_a(31, (Object)-1);
    }

    @Override
    public void init(String name) {
        super.init(name);
    }

    public short getNumBreedingLevels() {
        return this.field_70180_af.func_75693_b(31);
    }

    public void setNumBreedingLevels(int newValue) {
        this.field_70180_af.func_75692_b(31, (Object)((short)newValue));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.getNumBreedingLevels() != this.lastBreedingLevels) {
                this.breedingParticleEffects = this.getBreedingParticleEffects();
                this.lastBreedingLevels = this.getNumBreedingLevels();
            }
            if (this.breedingParticleEffects != null) {
                for (int i = 0; i < this.breedingParticleEffects.length; ++i) {
                    this.breedingParticleEffects[i].onUpdate();
                }
            }
        }
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.blockOwner != null) {
            return false;
        }
        return super.func_70692_ba();
    }

    public void setRanchBlockOwner(TileEntityRanchBase tileEntityRanchBase) {
        this.blockOwner = tileEntityRanchBase;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.isInRanchBlock) {
            nbt.func_74772_a("lastBreedingTime", this.lastBreedingTime);
        }
        nbt.func_74757_a("isEgg", this.isEgg);
        nbt.func_74757_a("isRandomEgg", this.isRandomEgg);
        nbt.func_74768_a("eggGroupID", this.group.getIndex().intValue());
        nbt.func_74768_a("eggCycles", this.eggCycles.intValue());
        nbt.func_74776_a("lastEggXCoord", (float)this.field_70165_t);
        nbt.func_74776_a("lastEggZCoord", (float)this.field_70161_v);
        nbt.func_74757_a("isInRanch", this.isInRanchBlock);
        nbt.func_74777_a("BreedingInteractions", this.getNumBreedingLevels());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) return super.func_70085_c(player);
        if (!this.isInRanchBlock) {
            return super.func_70085_c(player);
        }
        if (this.func_70902_q() != player) return super.func_70085_c(player);
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack == null) {
            this.blockOwner.updateStatus();
            if (this.blockOwner instanceof TileEntityRanchBlock) {
                TileEntityRanchBlock ranch = (TileEntityRanchBlock)this.blockOwner;
                if (this.blockOwner.getEntityCount() <= 1) return super.func_70085_c(player);
                EntityPixelmon otherPixelmon = ranch.getFirstBreedingPartner((EntityPixelmon)this);
                if (otherPixelmon != null) {
                    if (this.breedingStrength == 0.0f) {
                        if (this.type.size() == 1 || this.type.get(1) == null) {
                            this.breedingStrength = ((RanchBounds)ranch.getBounds()).getContainingBreedingConditions(this.field_70170_p).getBreedingStrength((EnumType)((Object)this.type.get(0)));
                        } else if (this.type.size() == 2) {
                            this.breedingStrength = ((RanchBounds)ranch.getBounds()).getContainingBreedingConditions(this.field_70170_p).getBreedingStrength((EnumType)((Object)this.type.get(0))) + ((RanchBounds)ranch.getBounds()).getContainingBreedingConditions(this.field_70170_p).getBreedingStrength((EnumType)((Object)this.type.get(1))) / 2.0f;
                        }
                    }
                    if (this.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.maxaffection", new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                        return false;
                    }
                    if (this.breedingStrength < 0.5f) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.level0", new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                        return true;
                    } else if (this.breedingStrength < 1.0f) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.level1", new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                        return true;
                    } else if (this.breedingStrength < 1.5f) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.level2", new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                        return true;
                    } else if (this.breedingStrength < 2.0f) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.level3", new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                        return true;
                    } else {
                        if (!(this.breedingStrength >= 2.0f)) return true;
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.level4", new Object[]{this.getNickname(), otherPixelmon.getNickname()}));
                    }
                    return true;
                }
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.notcompatible", new Object[]{this.getNickname()}));
                return false;
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("pixelmon.ranch.nopartner", new Object[]{this.getNickname()}));
            return false;
        }
        if (!(itemstack.func_77973_b() instanceof ItemIsisHourglass) || ((ItemIsisHourglass)itemstack.func_77973_b()).type != ItemIsisHourglass.HourglassType.Silver) return super.func_70085_c(player);
        if (this.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels) {
            return false;
        }
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("ranch.hourglass.upgrade", new Object[]{this.getNickname()}));
        this.setNumBreedingLevels(this.getNumBreedingLevels() + 1);
        if (player.field_71075_bZ.field_75098_d) return super.func_70085_c(player);
        player.field_71071_by.func_146026_a(player.func_71045_bC().func_77973_b());
        return super.func_70085_c(player);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        try {
            if (nbt.func_74764_b("isEgg")) {
                this.isEgg = nbt.func_74767_n("isEgg");
                this.isRandomEgg = nbt.func_74767_n("isRandomEgg");
                this.group = EnumEggGroup.getEggGroupFromIndex(nbt.func_74762_e("eggGroupID"));
                this.eggCycles = nbt.func_74762_e("eggCycles");
            } else {
                this.isEgg = false;
                this.isRandomEgg = false;
                this.group = EnumEggGroup.getRandomEggGroup(this.getName());
                this.eggCycles = 21;
            }
            if (nbt.func_74764_b("isInRanch")) {
                this.isInRanchBlock = nbt.func_74767_n("isInRanch");
            }
            if (nbt.func_74764_b("lastBreedingTime")) {
                this.lastBreedingTime = nbt.func_74763_f("lastBreedingTime");
            }
            if (nbt.func_74764_b("BreedingInteractions")) {
                this.setNumBreedingLevels(nbt.func_74765_d("BreedingInteractions"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void makeEntityIntoRandomEgg() {
        String name = EnumPokemon.randomPoke((boolean)PixelmonConfig.allowRandomBreedingEggsToBeLegendary).name;
        super.init(name);
        this.isRandomEgg = true;
        this.isEgg = true;
        this.getLvl().setLevel(1);
        this.group = Entity10CanBreed.getRandomEggGroupForPokemon(name);
        Integer tempCycles = DatabaseStats.GetBaseStats((String)name).eggCycles;
        this.eggCycles = tempCycles == null || tempCycles == 0 ? Integer.valueOf(21) : tempCycles;
    }

    public void makeEntityIntoEgg() {
        super.init(this.getName());
        this.isEgg = true;
        this.group = Entity10CanBreed.getRandomEggGroupForPokemon(this.getName());
        this.getLvl().setLevel(1);
        Integer tempCycles = DatabaseStats.GetBaseStats((String)this.getName()).eggCycles;
        this.eggCycles = tempCycles == null || tempCycles == 0 ? Integer.valueOf(21) : tempCycles;
    }

    public void makeEntityIntoEgg(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (Entity10CanBreed.canBreed(pixelmon1, pixelmon2)) {
            if (pixelmon1.getName().equalsIgnoreCase("Ditto") && pixelmon2.getName().equalsIgnoreCase("Ditto")) {
                this.makeEntityIntoRandomEgg();
            } else {
                String name = Entity10CanBreed.getPokemonInEggName(pixelmon1, pixelmon2);
                super.init(name);
                this.isEgg = true;
                this.group = Entity10CanBreed.getEggGroupForPair(pixelmon1, pixelmon2);
                this.getLvl().setLevel(1);
                Integer tempCycles = DatabaseStats.GetBaseStats((String)name).eggCycles;
                this.eggCycles = tempCycles == null || tempCycles == 0 ? Integer.valueOf(21) : tempCycles;
                this.stats.IVs = Entity10CanBreed.getIVsForEgg(pixelmon1, pixelmon2);
                this.setNature(Entity10CanBreed.getNatureForEgg(pixelmon1, pixelmon2));
                this.caughtBall = Entity10CanBreed.getMotherPokeball(pixelmon1, pixelmon2);
                this.setGrowth(Entity10CanBreed.getEggGrowth(pixelmon1, pixelmon2));
                this.setAbilitySlot(Entity10CanBreed.getEggAbilitySlot(this.baseStats.abilities, pixelmon1, pixelmon2));
                this.setAbility(this.baseStats.abilities[this.getAbilitySlot()]);
                this.setIsShiny(this.getIfEggIsShiny(pixelmon1, pixelmon2));
                Moveset moveset = Entity10CanBreed.getEggMoveset(this.baseStats.id, name, pixelmon1, pixelmon2);
                this.getMoveset().set(0, moveset.get(0));
                this.getMoveset().set(1, moveset.get(1));
                this.getMoveset().set(2, moveset.get(2));
                this.getMoveset().set(3, moveset.get(3));
            }
        } else {
            System.out.println("[Error] Error occurred in breeding, incompatible pair passed to Egg Initialization");
        }
    }

    public static EnumNature getNatureForEgg(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pixelmon1.func_70694_bm() != null && pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.everStone && pixelmon2.func_70694_bm() != null && pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.everStone) {
            return RandomHelper.getRandomNumberBetween(0, 1) == 1 ? pixelmon1.getNature() : pixelmon2.getNature();
        }
        if (pixelmon1.func_70694_bm() != null && pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.everStone) {
            return pixelmon1.getNature();
        }
        if (pixelmon2.func_70694_bm() != null && pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.everStone) {
            return pixelmon2.getNature();
        }
        return EnumNature.getRandomNature();
    }

    public static boolean canLearnVoltTackle(String name, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        return name.equalsIgnoreCase("Pichu") && (pixelmon1.func_70694_bm() != null && pixelmon1.func_70694_bm().func_77977_a().equalsIgnoreCase("Light Orb") || pixelmon2.func_70694_bm() != null && pixelmon2.func_70694_bm().func_77977_a().equalsIgnoreCase("Light Orb"));
    }

    public boolean getIfEggIsShiny(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        float intDifferentTrainerFactor = 1.0f;
        if (!pixelmon1.originalTrainer.equalsIgnoreCase(pixelmon2.originalTrainer)) {
            intDifferentTrainerFactor = 2.0f;
        }
        return PixelmonConfig.shinyRate != 0.0f && this.field_70146_Z.nextFloat() < intDifferentTrainerFactor / PixelmonConfig.shinyRate;
    }

    public static EnumPokeballs getMotherPokeball(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pixelmon1.gender == Gender.Female && pixelmon1.caughtBall != EnumPokeballs.MasterBall) {
            return pixelmon1.caughtBall;
        }
        if (pixelmon2.gender == Gender.Female && pixelmon2.caughtBall != EnumPokeballs.MasterBall) {
            return pixelmon2.caughtBall;
        }
        return EnumPokeballs.PokeBall;
    }

    public static Integer getEggAbilitySlot(String[] abilities, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pixelmon1.getName().equalsIgnoreCase("Ditto") || pixelmon2.getName().equalsIgnoreCase("Ditto")) {
            if (pixelmon1.getName().equalsIgnoreCase("Ditto") && pixelmon2.getName().equalsIgnoreCase("Ditto")) {
                return abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0;
            }
            if (pixelmon1.getName().equalsIgnoreCase("Ditto")) {
                int intPercent = 80;
                if (pixelmon2.gender == Gender.Male) {
                    intPercent = 60;
                }
                return RandomHelper.getRandomNumberBetween(0, 99) < intPercent ? (abilities[pixelmon2.getAbilitySlot()] != null ? pixelmon2.getAbilitySlot() : 0) : (abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0);
            }
            int intPercent = 80;
            if (pixelmon1.gender == Gender.Male) {
                intPercent = 60;
            }
            return RandomHelper.getRandomNumberBetween(0, 99) < intPercent ? (abilities[pixelmon1.getAbilitySlot()] != null ? pixelmon1.getAbilitySlot() : 0) : (abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0);
        }
        int intPercent = 80;
        if (pixelmon1.gender == Gender.Female) {
            return RandomHelper.getRandomNumberBetween(0, 99) < intPercent ? (abilities[pixelmon1.getAbilitySlot()] != null ? pixelmon1.getAbilitySlot() : 0) : (abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0);
        }
        return RandomHelper.getRandomNumberBetween(0, 99) < intPercent ? (abilities[pixelmon2.getAbilitySlot()] != null ? pixelmon2.getAbilitySlot() : 0) : (abilities[1] != null ? RandomHelper.getRandomNumberBetween(0, 1) : 0);
    }

    public static IVStore getIVsForEgg(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        int i;
        ArrayList<String> masterStatsList = new ArrayList<String>(Arrays.asList("HP1", "ATK1", "DEF1", "SPATK1", "SPDEF1", "SPD1", "HP2", "ATK2", "DEF2", "SPATK2", "SPDEF2", "SPD2"));
        ArrayList<String> strStatsToInherit = new ArrayList<String>();
        IVStore newIVs = IVStore.CreateNewIVs();
        int intNumberToInherit = 3;
        if (pixelmon1.func_70694_bm() != null && pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.destinyKnot || pixelmon2.func_70694_bm() != null && pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.destinyKnot) {
            intNumberToInherit = 5;
        }
        boolean skipSecondHeldItem = false;
        if (pixelmon1.func_70694_bm() != null) {
            if (pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerWeight) {
                strStatsToInherit.add("HP1");
                --intNumberToInherit;
            } else if (pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerBracer) {
                strStatsToInherit.add("ATK1");
                --intNumberToInherit;
            } else if (pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerBelt) {
                strStatsToInherit.add("DEF1");
                --intNumberToInherit;
            } else if (pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerLens) {
                strStatsToInherit.add("SPATK1");
                --intNumberToInherit;
            } else if (pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerBand) {
                strStatsToInherit.add("SPDEF1");
                --intNumberToInherit;
            } else if (pixelmon1.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerAnklet) {
                strStatsToInherit.add("SPD1");
                --intNumberToInherit;
            }
            if (pixelmon2.func_70694_bm() != null && pixelmon1.func_70694_bm().func_77973_b() == pixelmon2.func_70694_bm().func_77973_b()) {
                if (RandomHelper.getRandomNumberBetween(0, 1) == 0) {
                    skipSecondHeldItem = true;
                } else {
                    strStatsToInherit = new ArrayList();
                }
            }
        }
        if (!strStatsToInherit.isEmpty()) {
            for (String statToInherit : strStatsToInherit) {
                masterStatsList.remove(statToInherit);
                if (statToInherit.contains("1")) {
                    masterStatsList.remove(statToInherit.replace("1", "2"));
                    continue;
                }
                masterStatsList.remove(statToInherit.replace("2", "1"));
            }
        }
        if (!skipSecondHeldItem && pixelmon2.func_70694_bm() != null) {
            if (pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerWeight) {
                strStatsToInherit.add("HP2");
                --intNumberToInherit;
            } else if (pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerBracer) {
                strStatsToInherit.add("ATK2");
                --intNumberToInherit;
            } else if (pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerBelt) {
                strStatsToInherit.add("DEF2");
                --intNumberToInherit;
            } else if (pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerLens) {
                strStatsToInherit.add("SPATK2");
                --intNumberToInherit;
            } else if (pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerBand) {
                strStatsToInherit.add("SPDEF2");
                --intNumberToInherit;
            } else if (pixelmon2.func_70694_bm().func_77973_b() == PixelmonItemsHeld.powerAnklet) {
                strStatsToInherit.add("SPD2");
                --intNumberToInherit;
            }
        }
        if (!strStatsToInherit.isEmpty()) {
            for (String statToInherit : strStatsToInherit) {
                masterStatsList.remove(statToInherit);
                if (statToInherit.contains("1")) {
                    masterStatsList.remove(statToInherit.replace("1", "2"));
                    continue;
                }
                masterStatsList.remove(statToInherit.replace("2", "1"));
            }
        }
        for (i = 0; i < intNumberToInherit; ++i) {
            String statToInherit;
            statToInherit = masterStatsList.get(RandomHelper.getRandomNumberBetween(0, masterStatsList.size() - 1));
            strStatsToInherit.add(statToInherit);
            masterStatsList.remove(statToInherit);
            if (statToInherit.contains("1")) {
                masterStatsList.remove(statToInherit.replace("1", "2"));
                continue;
            }
            masterStatsList.remove(statToInherit.replace("2", "1"));
        }
        for (i = 0; i < strStatsToInherit.size(); ++i) {
            String strStat = (String)strStatsToInherit.get(i);
            if (strStat.equalsIgnoreCase("HP1")) {
                newIVs.HP = pixelmon1.stats.IVs.HP;
                continue;
            }
            if (strStat.equalsIgnoreCase("ATK1")) {
                newIVs.Attack = pixelmon1.stats.IVs.Attack;
                continue;
            }
            if (strStat.equalsIgnoreCase("DEF1")) {
                newIVs.Defence = pixelmon1.stats.IVs.Defence;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPATK1")) {
                newIVs.SpAtt = pixelmon1.stats.IVs.SpAtt;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPDEF1")) {
                newIVs.SpDef = pixelmon1.stats.IVs.SpDef;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPD1")) {
                newIVs.Speed = pixelmon1.stats.IVs.Speed;
                continue;
            }
            if (strStat.equalsIgnoreCase("HP2")) {
                newIVs.HP = pixelmon2.stats.IVs.HP;
                continue;
            }
            if (strStat.equalsIgnoreCase("ATK2")) {
                newIVs.Attack = pixelmon2.stats.IVs.Attack;
                continue;
            }
            if (strStat.equalsIgnoreCase("DEF2")) {
                newIVs.Defence = pixelmon2.stats.IVs.Defence;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPATK2")) {
                newIVs.SpAtt = pixelmon2.stats.IVs.SpAtt;
                continue;
            }
            if (strStat.equalsIgnoreCase("SPDEF2")) {
                newIVs.SpDef = pixelmon2.stats.IVs.SpDef;
                continue;
            }
            if (!strStat.equalsIgnoreCase("SPD2")) continue;
            newIVs.Speed = pixelmon2.stats.IVs.Speed;
        }
        return newIVs;
    }

    public static Moveset getEggMoveset(Integer id, String name, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        ArrayList<Attack> lvl0Moves = DatabaseMoves.getAttacksAtLevel(id, 0);
        ArrayList<Attack> levelupMoves = Entity10CanBreed.getLevelupMoves(id, pixelmon1, pixelmon2);
        ArrayList<Attack> fathersTMHMTutorMoves = Entity10CanBreed.getFathersTMHMTutorMoves(id, Entity10CanBreed.returnFather(pixelmon1, pixelmon2));
        ArrayList<Attack> fathersEggMoves = Entity10CanBreed.getEggMoves(id, Entity10CanBreed.returnFather(pixelmon1, pixelmon2));
        ArrayList<Attack> mothersEggMoves = Entity10CanBreed.getEggMoves(id, Entity10CanBreed.returnMother(pixelmon1, pixelmon2));
        boolean canLearnVoltTackle = Entity10CanBreed.canLearnVoltTackle(name, pixelmon1, pixelmon2);
        ArrayList<Attack> masterAttackList = new ArrayList<Attack>();
        if (canLearnVoltTackle) {
            masterAttackList.add(DatabaseMoves.getAttack("Volt Tackle"));
        }
        masterAttackList.addAll(mothersEggMoves);
        masterAttackList.addAll(fathersEggMoves);
        masterAttackList.addAll(fathersTMHMTutorMoves);
        masterAttackList.addAll(levelupMoves);
        masterAttackList.addAll(lvl0Moves);
        for (int i = 0; i < masterAttackList.size(); ++i) {
            Attack a = masterAttackList.get(i);
            for (int j = i + 1; j < masterAttackList.size(); ++j) {
                if (a.baseAttack.attackIndex != masterAttackList.get((int)j).baseAttack.attackIndex) continue;
                masterAttackList.remove(j);
                ++j;
            }
        }
        return Entity10CanBreed.getFirstFourMoves(masterAttackList);
    }

    public static ArrayList<Attack> getEggMoves(Integer id, EntityPixelmon pixelmon1) {
        ArrayList<Attack> eggMoves = new ArrayList<Attack>();
        if (pixelmon1 != null) {
            ArrayList<Attack> allBabyEggMoves = DatabaseMoves.getAllEggAttacks(id);
            ArrayList<Attack> allParentsMoves = new ArrayList<Attack>(Arrays.asList(pixelmon1.getMoveset().attacks));
            for (Attack attack : allParentsMoves) {
                if (!Entity10CanBreed.listContains(allBabyEggMoves, attack)) continue;
                eggMoves.add(attack);
            }
        }
        return eggMoves;
    }

    private static boolean listContains(ArrayList<Attack> list, Attack attack) {
        for (Attack a : list) {
            if (a == null || attack == null || a.baseAttack.attackIndex != attack.baseAttack.attackIndex) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<Attack> getFathersTMHMTutorMoves(Integer id, EntityPixelmon pixelmon1) {
        ArrayList<Attack> tmhmTutorMoves = new ArrayList<Attack>();
        if (pixelmon1 != null) {
            ArrayList<Attack> allBabyTMHMTutorMoves = DatabaseMoves.getAllTMHMTutorAttacks(id);
            ArrayList<Attack> allFathersMoves = new ArrayList<Attack>(Arrays.asList(pixelmon1.getMoveset().attacks));
            for (Attack attack : allFathersMoves) {
                if (!Entity10CanBreed.listContains(allBabyTMHMTutorMoves, attack)) continue;
                tmhmTutorMoves.add(attack);
            }
        }
        return tmhmTutorMoves;
    }

    public static EntityPixelmon returnFather(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pixelmon1.getName().equalsIgnoreCase("Ditto") || pixelmon2.getName().equalsIgnoreCase("Ditto")) {
            if (pixelmon1.getName().equalsIgnoreCase("Ditto") && pixelmon2.gender != Gender.Female) {
                return pixelmon2;
            }
            if (pixelmon2.getName().equalsIgnoreCase("Ditto") && pixelmon1.gender != Gender.Female) {
                return pixelmon1;
            }
            return null;
        }
        return pixelmon1.gender == Gender.Male ? pixelmon1 : pixelmon2;
    }

    public static EntityPixelmon returnMother(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pixelmon1.getName().equalsIgnoreCase("Ditto") || pixelmon2.getName().equalsIgnoreCase("Ditto")) {
            if (pixelmon1.getName().equalsIgnoreCase("Ditto") && pixelmon2.gender != Gender.Male) {
                return pixelmon2;
            }
            if (pixelmon2.getName().equalsIgnoreCase("Ditto") && pixelmon1.gender != Gender.Male) {
                return pixelmon1;
            }
            return null;
        }
        return pixelmon1.gender == Gender.Female ? pixelmon1 : pixelmon2;
    }

    public static ArrayList<Attack> getLevelupMoves(Integer id, EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        ArrayList<Attack> allBabyAttacks = DatabaseMoves.getAllAttacks(id);
        ArrayList<Attack> pixelmon1Attacks = new ArrayList<Attack>(Arrays.asList(pixelmon1.getMoveset().attacks));
        ArrayList<Attack> pixelmon2Attacks = new ArrayList<Attack>(Arrays.asList(pixelmon2.getMoveset().attacks));
        ArrayList<Attack> levelupMoves = new ArrayList<Attack>();
        for (Attack attack : allBabyAttacks) {
            if (!Entity10CanBreed.listContains(pixelmon1Attacks, attack) || !Entity10CanBreed.listContains(pixelmon2Attacks, attack)) continue;
            levelupMoves.add(attack);
        }
        return levelupMoves;
    }

    public static Moveset getFirstFourMoves(ArrayList<Attack> masterAttackList) {
        Moveset moveset = new Moveset();
        moveset.set(0, DatabaseMoves.getAttack("Tackle"));
        moveset.set(1, null);
        moveset.set(2, null);
        moveset.set(3, null);
        if (!masterAttackList.isEmpty()) {
            for (int i = 0; i < Math.min(4, masterAttackList.size()); ++i) {
                if (masterAttackList.get(i) == null) continue;
                moveset.set(i, masterAttackList.get(i));
            }
        }
        return moveset;
    }

    public static boolean canBreed(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        EnumEggGroup[] groupsMother;
        EnumEggGroup[] groupsFather;
        if (pixelmon1.getName().equalsIgnoreCase("Ditto") || pixelmon2.getName().equalsIgnoreCase("Ditto")) {
            if (pixelmon1.getName().equalsIgnoreCase("Ditto") && pixelmon2.getName().equalsIgnoreCase("Ditto")) {
                return true;
            }
            EnumEggGroup[] groupsNonDitto = pixelmon1.getName().equalsIgnoreCase("Ditto") ? EnumEggGroup.getEggGroups(pixelmon2.getName()) : EnumEggGroup.getEggGroups(pixelmon1.getName());
            for (EnumEggGroup groupNonDitto : groupsNonDitto) {
                if (groupNonDitto != EnumEggGroup.Undiscovered) continue;
                return false;
            }
            return true;
        }
        if (pixelmon1.gender == pixelmon2.gender) {
            return false;
        }
        if (pixelmon1.gender == Gender.None || pixelmon2.gender == Gender.None) {
            return false;
        }
        if (pixelmon1.gender == Gender.Male) {
            groupsFather = EnumEggGroup.getEggGroups(pixelmon1.getName());
            groupsMother = EnumEggGroup.getEggGroups(pixelmon2.getName());
        } else {
            groupsFather = EnumEggGroup.getEggGroups(pixelmon2.getName());
            groupsMother = EnumEggGroup.getEggGroups(pixelmon1.getName());
        }
        if (groupsFather == null || groupsMother == null) {
            return false;
        }
        for (EnumEggGroup groupFather : groupsFather) {
            for (EnumEggGroup groupMother : groupsMother) {
                if (groupFather != groupMother || groupMother == EnumEggGroup.Undiscovered) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPokemonInEggName(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pixelmon1.getName().equalsIgnoreCase("Ditto") || pixelmon2.getName().equalsIgnoreCase("Ditto")) {
            if (pixelmon1.getName().equalsIgnoreCase("Ditto") && pixelmon2.getName().equalsIgnoreCase("Ditto")) {
                return EnumPokemon.randomPoke((boolean)PixelmonConfig.allowRandomBreedingEggsToBeLegendary).name;
            }
            if (pixelmon1.getName().equalsIgnoreCase("Ditto")) {
                return Entity10CanBreed.getEggForm(pixelmon2, pixelmon2.func_70694_bm(), pixelmon1.func_70694_bm());
            }
            return Entity10CanBreed.getEggForm(pixelmon1, pixelmon1.func_70694_bm(), pixelmon2.func_70694_bm());
        }
        if (pixelmon1.gender == Gender.Male) {
            return Entity10CanBreed.getEggForm(pixelmon2, pixelmon2.func_70694_bm(), pixelmon1.func_70694_bm());
        }
        return Entity10CanBreed.getEggForm(pixelmon1, pixelmon1.func_70694_bm(), pixelmon2.func_70694_bm());
    }

    public static String getEggForm(EntityPixelmon parentForEggLine, ItemStack itemParentForEggLine, ItemStack itemOtherParent) {
        ArrayList<String> variableEggParents = new ArrayList<String>(Arrays.asList("Nidoranfemale", "Nidoranmale", "Illumise", "Volbeat"));
        ArrayList<String> heldItemParents = new ArrayList<String>(Arrays.asList("Marill", "Azumarill", "Wobbuffet", "Roselia", "Roserade", "Chimecho", "Sudowoodo", "MrMime", "Chansey", "Blissey", "Mantine", "Snorlax"));
        if (variableEggParents.contains(parentForEggLine.getName())) {
            if (parentForEggLine.getName().equalsIgnoreCase("Nidoranfemale") || parentForEggLine.getName().equalsIgnoreCase("Nidoranmale")) {
                String[] eggForms = new String[]{"Nidoranfemale", "Nidoranmale"};
                return EnumPokemon.get((String)eggForms[new Random().nextInt((int)eggForms.length)]).name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Illumise") || parentForEggLine.getName().equalsIgnoreCase("Volbeat")) {
                String[] eggForms = new String[]{"Illumise", "Volbeat"};
                return EnumPokemon.get((String)eggForms[new Random().nextInt((int)eggForms.length)]).name;
            }
        }
        if (heldItemParents.contains(parentForEggLine.getName())) {
            if (parentForEggLine.getName().equalsIgnoreCase("Marill") || parentForEggLine.getName().equalsIgnoreCase("Azumarill")) {
                if (EnumPokemon.hasPokemon("Azurill") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.seaIncense) {
                    return EnumPokemon.get((String)"Azurill").name;
                }
                if (EnumPokemon.hasPokemon("Azurill") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.seaIncense) {
                    return EnumPokemon.get((String)"Azurill").name;
                }
                return EnumPokemon.get((String)"Marill").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Wobbuffet")) {
                if (EnumPokemon.hasPokemon("Wynaut") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.laxIncense) {
                    return EnumPokemon.get((String)"Wynaut").name;
                }
                if (EnumPokemon.hasPokemon("Wynaut") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.laxIncense) {
                    return EnumPokemon.get((String)"Wynaut").name;
                }
                return EnumPokemon.get((String)"Wobbuffet").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Roselia") || parentForEggLine.getName().equalsIgnoreCase("Roserade")) {
                if (EnumPokemon.hasPokemon("") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.roseIncense) {
                    return EnumPokemon.get((String)"Budew").name;
                }
                if (EnumPokemon.hasPokemon("") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.roseIncense) {
                    return EnumPokemon.get((String)"Budew").name;
                }
                return EnumPokemon.get((String)"Roselia").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Chimecho")) {
                if (EnumPokemon.hasPokemon("Chingling") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.pureIncense) {
                    return EnumPokemon.get((String)"Chingling").name;
                }
                if (EnumPokemon.hasPokemon("Chingling") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.pureIncense) {
                    return EnumPokemon.get((String)"Chingling").name;
                }
                return EnumPokemon.get((String)"Chimecho").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Sudowoodo")) {
                if (EnumPokemon.hasPokemon("Bonsly") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.rockIncense) {
                    return EnumPokemon.get((String)"Bonsly").name;
                }
                if (EnumPokemon.hasPokemon("Bonsly") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.rockIncense) {
                    return EnumPokemon.get((String)"Bonsly").name;
                }
                return EnumPokemon.get((String)"Sudowoodo").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("MrMime")) {
                if (EnumPokemon.hasPokemon("MimeJr") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.oddIncense) {
                    return EnumPokemon.get((String)"MimeJr").name;
                }
                if (EnumPokemon.hasPokemon("MimeJr") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.oddIncense) {
                    return EnumPokemon.get((String)"MimeJr").name;
                }
                return EnumPokemon.get((String)"MrMime").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Chansey") || parentForEggLine.getName().equalsIgnoreCase("Blissey")) {
                if (EnumPokemon.hasPokemon("Happiny") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.luckIncense) {
                    return EnumPokemon.get((String)"Happiny").name;
                }
                if (EnumPokemon.hasPokemon("Happiny") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.luckIncense) {
                    return EnumPokemon.get((String)"Happiny").name;
                }
                return EnumPokemon.get((String)"Chansey").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Mantine")) {
                if (EnumPokemon.hasPokemon("Mantyke") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.waveIncense) {
                    return EnumPokemon.get((String)"Mantyke").name;
                }
                if (EnumPokemon.hasPokemon("Mantyke") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.waveIncense) {
                    return EnumPokemon.get((String)"Mantyke").name;
                }
                return EnumPokemon.get((String)"Mantine").name;
            }
            if (parentForEggLine.getName().equalsIgnoreCase("Snorlax")) {
                if (EnumPokemon.hasPokemon("Munchlax") && itemParentForEggLine != null && itemParentForEggLine.func_77973_b() == PixelmonItemsHeld.fullIncense) {
                    return EnumPokemon.get((String)"Munchlax").name;
                }
                if (EnumPokemon.hasPokemon("Munchlax") && itemOtherParent != null && itemOtherParent.func_77973_b() == PixelmonItemsHeld.fullIncense) {
                    return EnumPokemon.get((String)"Munchlax").name;
                }
                return EnumPokemon.get((String)"Snorlax").name;
            }
        }
        return Entity10CanBreed.getBasicPokemonForm(parentForEggLine.getName());
    }

    public static String getBasicPokemonForm(String pixelmonName) {
        try {
            BaseStats store = DatabaseStats.GetBaseStats(pixelmonName);
            if (store.preEvolutions != null && store.preEvolutions.length > 0) {
                return Entity10CanBreed.getBasicPokemonForm(store.preEvolutions[0].name);
            }
            return pixelmonName;
        }
        catch (Exception e) {
            System.out.println("[Error] Error getting basic Pokemon form for: " + pixelmonName);
            e.printStackTrace();
            return pixelmonName;
        }
    }

    public String getEggDescripion() {
        return Entity10CanBreed.getEggDescription(this.eggCycles);
    }

    public static String getEggDescription(Integer cycles) {
        if (cycles < 5) {
            return StatCollector.func_74838_a((String)"pixelmon.egg.stage1");
        }
        if (cycles < 10) {
            return StatCollector.func_74838_a((String)"pixelmon.egg.stage2");
        }
        if (cycles < 40) {
            return StatCollector.func_74838_a((String)"pixelmon.egg.stage3");
        }
        return StatCollector.func_74838_a((String)"pixelmon.egg.stage4");
    }

    public static EnumEggGroup getRandomEggGroupForPokemon(String name) {
        EnumEggGroup[] eggGroups = EnumEggGroup.getEggGroups(name);
        try {
            return eggGroups[new Random().nextInt(eggGroups.length)];
        }
        catch (Exception e) {
            System.out.println("[Error] Error finding Egg group for pokemon: " + name);
            e.printStackTrace();
            return null;
        }
    }

    public static EnumEggGroup getEggGroupForPair(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        EnumEggGroup[] groups1 = EnumEggGroup.getEggGroups(pixelmon1.getName());
        EnumEggGroup[] groups2 = EnumEggGroup.getEggGroups(pixelmon2.getName());
        ArrayList<EnumEggGroup> groupsEgg = new ArrayList<EnumEggGroup>();
        for (EnumEggGroup group1 : groups1) {
            for (EnumEggGroup group2 : groups2) {
                if (group1 != group2 || group2 == EnumEggGroup.Undiscovered) continue;
                groupsEgg.add(group2);
            }
        }
        if (groupsEgg.isEmpty()) {
            return EnumEggGroup.Undiscovered;
        }
        if (groupsEgg.size() == 1) {
            return (EnumEggGroup)((Object)groupsEgg.get(0));
        }
        return (EnumEggGroup)((Object)groupsEgg.get(RandomHelper.getRandomNumberBetween(0, groupsEgg.size() - 1)));
    }

    public static EnumGrowth getEggGrowth(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        int ordinal;
        ArrayList growths = new ArrayList();
        double averageOrdinal = (pixelmon1.getGrowth().scaleOrdinal + pixelmon2.getGrowth().scaleOrdinal) / 2;
        if ((double)((int)averageOrdinal) != averageOrdinal) {
            double d = averageOrdinal = RandomHelper.getRandomNumberBetween(0, 1) == 0 ? Math.floor(averageOrdinal) : Math.ceil(averageOrdinal);
        }
        if ((ordinal = (int)averageOrdinal) <= 0) {
            ordinal = 1;
        }
        if (ordinal >= 8) {
            ordinal = 7;
        }
        int rand = RandomHelper.getRandomNumberBetween(ordinal - 1, ordinal + 1);
        return EnumGrowth.getGrowthFromScaleOrdinal(rand);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.isInRanchBlock) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void resetBreedingLevel() {
        this.setNumBreedingLevels(0);
        this.lastBreedingTime = this.field_70170_p.func_82737_E();
    }

    public boolean readyToMakeEgg() {
        return this.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels;
    }

    public ParticleEffects[] getBreedingParticleEffects() {
        ArrayList<BreedingParticles> effects = new ArrayList<BreedingParticles>();
        if (this.getNumBreedingLevels() > 0) {
            effects.add(new BreedingParticles(this));
        }
        if (!effects.isEmpty()) {
            return effects.toArray(new ParticleEffects[effects.size()]);
        }
        return null;
    }

    public void updateBreeding() {
        if (this.getNumBreedingLevels() >= PixelmonConfig.numBreedingLevels) {
            this.setNumBreedingLevels(PixelmonConfig.numBreedingLevels);
        } else {
            if (this.breedingCheckCount-- <= 0) {
                this.breedingCheckCount = 500;
                if (this.type.size() == 1 || this.type.get(1) == null) {
                    this.breedingStrength = ((RanchBounds)this.blockOwner.getBounds()).getContainingBreedingConditions(this.field_70170_p).getBreedingStrength((EnumType)((Object)this.type.get(0)));
                } else if (this.type.size() == 2) {
                    this.breedingStrength = (((RanchBounds)this.blockOwner.getBounds()).getContainingBreedingConditions(this.field_70170_p).getBreedingStrength((EnumType)((Object)this.type.get(0))) + ((RanchBounds)this.blockOwner.getBounds()).getContainingBreedingConditions(this.field_70170_p).getBreedingStrength((EnumType)((Object)this.type.get(1)))) / 2.0f;
                }
            }
            if (this.breedingStrength == 0.0f) {
                this.lastBreedingTime = this.field_70170_p.func_82737_E();
                this.setNumBreedingLevels((short)Math.max(0, this.getNumBreedingLevels() - 1));
            } else if (this.breedingStrength > 0.0f) {
                long currentTime = this.field_70170_p.func_82737_E();
                while ((float)(currentTime - this.lastBreedingTime) - (float)PixelmonConfig.breedingTicks / this.breedingStrength >= 0.0f) {
                    this.setNumBreedingLevels((short)Math.max(0, this.getNumBreedingLevels() + 1));
                    this.lastBreedingTime = (long)((float)this.lastBreedingTime + (float)PixelmonConfig.breedingTicks / this.breedingStrength);
                }
            }
        }
    }
}

