/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.DeltaListener;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class Entity1Base
extends EntityTameable {
    public EnumPokeballs caughtBall;
    public EntityPokeBall hitByPokeball = null;
    public Gender gender;
    public boolean isInBall = false;
    public boolean isFainted = false;
    public boolean isInitialised = false;
    public String originalTrainer = "";
    public boolean canDespawn = true;
    public DeltaListener deltas;

    public Entity1Base(World par1World) {
        super(par1World);
        this.field_70180_af.func_75682_a(2, (Object)"");
        this.field_70180_af.func_75682_a(3, (Object)"");
        this.field_70180_af.func_75682_a(4, (Object)-1);
        this.field_70180_af.func_75682_a(28, (Object)-1);
        this.field_70180_af.func_75682_a(21, (Object)-1);
        this.field_70180_af.func_75682_a(22, (Object)-1);
        this.field_70180_af.func_75682_a(23, (Object)-1);
        this.field_70180_af.func_75682_a(30, (Object)-1);
    }

    protected void init(String name) {
        this.setName(name);
        if (this.getBossMode() == null) {
            this.setBoss(EnumBossMode.NotBoss);
        }
        if (this.getNature() == null) {
            this.setNature(EnumNature.getRandomNature());
        }
        if (this.getGrowth() == null) {
            this.setGrowth(EnumGrowth.getRandomGrowth());
        }
    }

    public String getName() {
        return this.field_70180_af.func_75681_e(2);
    }

    public String getLocalizedName() {
        return Entity1Base.getLocalizedName(this.getName());
    }

    public static String getLocalizedName(String name) {
        return StatCollector.func_74838_a((String)("pixelmon." + name.toLowerCase() + ".name"));
    }

    public String getLocalizedDescription() {
        return Entity1Base.getLocalizedDescription(this.getName());
    }

    public static String getLocalizedDescription(String name) {
        return StatCollector.func_74838_a((String)("pixelmon." + name.toLowerCase() + ".description"));
    }

    public void setName(String name) {
        this.field_70180_af.func_75692_b(2, (Object)name);
    }

    public void setBoss(EnumBossMode mode) {
        this.field_70180_af.func_75692_b(21, (Object)((short)mode.index));
    }

    public EnumBossMode getBossMode() {
        return EnumBossMode.getMode(this.field_70180_af.func_75693_b(21));
    }

    public void setNature(EnumNature nature) {
        this.field_70180_af.func_75692_b(22, (Object)((short)nature.index));
    }

    public void setGrowth(EnumGrowth growth) {
        this.field_70180_af.func_75692_b(23, (Object)((short)growth.index));
    }

    public EnumNature getNature() {
        return EnumNature.getNatureFromIndex(this.field_70180_af.func_75693_b(22));
    }

    public EnumGrowth getGrowth() {
        return EnumGrowth.getGrowthFromIndex(this.field_70180_af.func_75693_b(23));
    }

    public String getNickname() {
        if (this.field_70180_af.func_75681_e(3).equals("")) {
            return this.getLocalizedName();
        }
        return this.field_70180_af.func_75681_e(3);
    }

    public boolean hasNickname() {
        return !this.field_70180_af.func_75681_e(3).equals("");
    }

    public void setNickname(String nickname) {
        this.field_70180_af.func_75692_b(3, (Object)nickname);
    }

    public int[] getPokemonId() {
        return new int[]{this.field_70180_af.func_75679_c(4), this.field_70180_af.func_75679_c(28)};
    }

    public void setPokemonId(int[] id) {
        this.field_70180_af.func_75692_b(4, (Object)id[0]);
        this.field_70180_af.func_75692_b(28, (Object)id[1]);
    }

    public SpawnLocation getSpawnLocation() {
        return SpawnLocation.getFromIndex(this.field_70180_af.func_75693_b(30));
    }

    public void setSpawnLocation(SpawnLocation spawnLocation) {
        if (spawnLocation == null) {
            spawnLocation = SpawnLocation.Land;
        }
        this.field_70180_af.func_75692_b(30, (Object)((short)spawnLocation.ordinal()));
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70024_g(double par1, double par3, double par5) {
        if (this.func_70104_M()) {
            super.func_70024_g(par1, par3, par5);
        }
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isInitialised) {
            this.init(this.getName());
            this.isInitialised = true;
        }
        if (this.deltas != null) {
            this.deltas.update();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("pixelmonID1", this.field_70180_af.func_75679_c(4));
        nbt.func_74768_a("pixelmonID2", this.field_70180_af.func_75679_c(28));
        nbt.func_74778_a("Name", this.field_70180_af.func_75681_e(2));
        nbt.func_74778_a("Nickname", this.field_70180_af.func_75681_e(3));
        if (this.caughtBall != null) {
            nbt.func_74768_a("CaughtBall", this.caughtBall.ordinal());
        }
        nbt.func_74777_a("Gender", (short)this.gender.ordinal());
        nbt.func_74757_a("IsInBall", this.isInBall);
        nbt.func_74757_a("IsFainted", this.isFainted);
        nbt.func_74777_a("BossMode", this.field_70180_af.func_75693_b(21));
        nbt.func_74777_a("Nature", this.field_70180_af.func_75693_b(22));
        nbt.func_74777_a("Growth", this.field_70180_af.func_75693_b(23));
        nbt.func_74778_a("originalTrainer", this.originalTrainer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (!nbt.func_74764_b("pixelmonID1")) {
            if (this.func_70902_q() != null) {
                this.func_70076_C();
            }
            nbt.func_74768_a("pixelmonID1", -1);
            nbt.func_74768_a("pixelmonID2", -1);
        }
        this.field_70180_af.func_75692_b(4, (Object)nbt.func_74762_e("pixelmonID1"));
        this.field_70180_af.func_75692_b(28, (Object)nbt.func_74762_e("pixelmonID2"));
        this.field_70180_af.func_75692_b(2, (Object)nbt.func_74779_i("Name"));
        if (!this.isInitialised) {
            this.init(this.getName());
        }
        this.isInitialised = true;
        if (nbt.func_74764_b("Nickname")) {
            this.field_70180_af.func_75692_b(3, (Object)nbt.func_74779_i("Nickname"));
        }
        if (nbt.func_74764_b("CaughtBall")) {
            this.caughtBall = EnumPokeballs.getFromIndex(nbt.func_74762_e("CaughtBall"));
        }
        if (nbt.func_74764_b("IsMale")) {
            this.gender = nbt.func_74767_n("IsMale") ? Gender.Male : Gender.Female;
        }
        this.gender = Gender.getGender(nbt.func_74765_d("Gender"));
        if (this instanceof EntityPixelmon && ((EntityPixelmon)this).baseStats.malePercent < 0) {
            this.gender = Gender.None;
        }
        this.isInBall = nbt.func_74767_n("IsInBall");
        this.isFainted = nbt.func_74767_n("IsFainted");
        if (nbt.func_74764_b("BossMode")) {
            this.field_70180_af.func_75692_b(21, (Object)nbt.func_74765_d("BossMode"));
        } else {
            this.setBoss(EnumBossMode.NotBoss);
        }
        if (nbt.func_74764_b("Nature")) {
            this.field_70180_af.func_75692_b(22, (Object)nbt.func_74765_d("Nature"));
        } else {
            this.setNature(EnumNature.getRandomNature());
        }
        if (nbt.func_74764_b("Growth")) {
            this.field_70180_af.func_75692_b(23, (Object)nbt.func_74765_d("Growth"));
        } else {
            this.setGrowth(EnumGrowth.Ordinary);
        }
        if (nbt.func_74764_b("originalTrainer")) {
            this.originalTrainer = nbt.func_74779_i("originalTrainer");
        }
    }

    public int func_70654_ax() {
        return 0;
    }

    public EntityAnimal spawnBabyAnimal(EntityAnimal entityanimal) {
        return null;
    }

    public boolean belongsTo(EntityPlayer player) {
        return this.func_70902_q() == player;
    }

    public void update(EnumUpdateType ... types) {
        try {
            if (this.isInitialised) {
                PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.func_70902_q()).updateAndSendToClient((EntityPixelmon)this, types);
            }
        }
        catch (PlayerNotLoadedException playerNotLoadedException) {
            // empty catch block
        }
    }

    public PlayerStorage getStorage() throws PlayerNotLoadedException {
        return PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)this.func_70902_q());
    }

    public boolean hasOwner() {
        return !this.func_152113_b().equals("");
    }

    public boolean func_94056_bM() {
        return false;
    }

    public DeltaListener getDeltaListener() {
        return this.deltas == null ? (this.deltas = new DeltaListener((EntityLiving)this, new DeltaListener.EnumEntityValue[0])) : this.deltas;
    }
}

