/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.AnimationVariables;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Entity2HasModel
extends Entity1Base {
    ModelBase model;
    ModelBase flyingModel;
    private AnimationVariables animationVariables;
    public boolean animationFlyingCounting = false;
    public boolean animationFlyingSwap = false;
    int animationFlyingDelayCounter = 0;
    static int animationFlyingDelayLimit = 10;
    public boolean animationCounting = false;
    public boolean animationSwap = false;
    int animationDelayCounter = 0;
    static int animationDelayLimit = 3;
    int flyingDelayCounter = 0;
    static int flyingDelayLimit = 10;
    @SideOnly(value=Side.CLIENT)
    public boolean transformed;
    @SideOnly(value=Side.CLIENT)
    String transformedModel;
    String oldName;

    public Entity2HasModel(World par1World) {
        super(par1World);
        this.field_70180_af.func_75682_a(29, (Object)0);
    }

    @Override
    protected void init(String name) {
        super.init(name);
        this.oldName = name;
    }

    public void evolve(String evolveTo) {
        if (!EnumPokemon.hasPokemon(evolveTo)) {
            return;
        }
        this.setName(evolveTo);
        this.update(EnumUpdateType.Name);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase getModel() {
        if (this.model == null) {
            this.loadModel();
        }
        if (this.flyingModel != null && this.flyingDelayCounter >= flyingDelayLimit) {
            return this.flyingModel;
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    void loadModel() {
        if (this.model == null) {
            if (Pixelmon.proxy.isModelStatic(this.getName())) {
                if (Pixelmon.proxy.getModels().length == 0) {
                    return;
                }
                int n = ((Entity3HasStats)this).baseStats.nationalPokedexNumber;
                if (Pixelmon.proxy.getModels()[n] != null) {
                    Object mod = Pixelmon.proxy.getModels()[n];
                    if (mod instanceof ModelBase) {
                        this.model = (ModelBase)mod;
                    }
                    this.flyingModel = (ModelBase)Pixelmon.proxy.getFlyingModels()[n];
                } else {
                    ModelBase m = Pixelmon.proxy.loadModel(this.getName());
                    Pixelmon.proxy.getModels()[n] = m;
                    this.model = m;
                    m = Pixelmon.proxy.loadFlyingModel(this.getName());
                    if (m != null) {
                        Pixelmon.proxy.getFlyingModels()[n] = m;
                    }
                    this.flyingModel = m;
                }
            } else {
                ModelBase m;
                this.model = m = Pixelmon.proxy.loadModel(this.getName());
                this.flyingModel = m = Pixelmon.proxy.loadFlyingModel(this.getName());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void transform(String transformedModel) {
        ModelBase m;
        this.transformed = true;
        this.transformedModel = transformedModel;
        this.model = m = Pixelmon.proxy.loadModel(transformedModel);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("transform", this.getTransformed());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_75692_b(29, (Object)nbt.func_74765_d("transform"));
    }

    public short getTransformed() {
        return this.field_70180_af.func_75693_b(29);
    }

    public float getScaleFactor() {
        return this.getGrowth().scaleValue * this.getBossMode().scaleFactor;
    }

    public AnimationVariables getAnimationVariables() {
        if (this.animationVariables == null) {
            this.animationVariables = new AnimationVariables();
        }
        return this.animationVariables;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !this.oldName.equals(this.getName())) {
            this.isInitialised = false;
            Entity3HasStats cfr_ignored_0 = (Entity3HasStats)this;
            ((Entity3HasStats)this).baseStats = Entity3HasStats.getBaseStats(this.getName());
            this.model = null;
            this.oldName = this.getName();
        }
        if (this.field_70170_p.field_72995_K && this.animationVariables != null) {
            this.animationVariables.tick();
        }
        if (!this.field_70122_E && !this.field_70171_ac) {
            if (this.flyingDelayCounter < flyingDelayLimit) {
                ++this.flyingDelayCounter;
            }
        } else {
            this.flyingDelayCounter = 0;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.animationFlyingCounting) {
                if (this.animationFlyingDelayCounter < animationFlyingDelayLimit) {
                    ++this.animationFlyingDelayCounter;
                    this.animationFlyingSwap = false;
                }
                if (this.animationFlyingDelayCounter >= animationFlyingDelayLimit) {
                    this.animationFlyingSwap = true;
                    this.animationFlyingDelayCounter = 0;
                }
            } else {
                this.animationFlyingDelayCounter = 0;
                this.animationFlyingSwap = false;
            }
            if (this.animationCounting) {
                if (this.animationDelayCounter < animationDelayLimit) {
                    ++this.animationDelayCounter;
                    this.animationSwap = false;
                }
                if (this.animationDelayCounter >= animationDelayLimit) {
                    this.animationSwap = true;
                    this.animationDelayCounter = 0;
                }
            } else {
                this.animationDelayCounter = 0;
                this.animationSwap = false;
            }
            if (this.getModel() instanceof PixelmonModelSmd && this instanceof EntityPixelmon) {
                ((PixelmonModelSmd)this.getModel()).doAnimation((Entity)this);
            }
        }
    }
}

