/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PixelmonFaintEvent;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.DatabaseAbilities;
import com.pixelmonmod.pixelmon.database.DatabaseStats;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity2HasModel;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FriendShip;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class Entity3HasStats
extends Entity2HasModel {
    protected Level level;
    public Stats stats;
    public BaseStats baseStats;
    public FriendShip friendship;
    public ArrayList<EnumType> type = new ArrayList();
    public float length;
    public boolean doesLevel = true;
    private static BaseStats[] baseStatsStore = new BaseStats[650];
    public ExtraStats extraStats = null;
    private AbilityBase ability;
    private Integer abilitySlot;

    public Entity3HasStats(World par1World) {
        super(par1World);
        this.field_70180_af.func_75682_a(19, (Object)1000);
        this.stats = new Stats();
        if (this instanceof EntityPixelmon) {
            this.level = new Level((EntityPixelmon)this);
            this.friendship = new FriendShip((EntityPixelmon)this);
        }
        this.field_70180_af.func_75682_a(20, (Object)10);
    }

    public int getCatchRate() {
        float c = this.baseStats.catchRate;
        return (int)c;
    }

    public boolean func_70094_T() {
        if (super.func_70094_T()) {
            if (this.field_70170_p.func_147439_a((int)this.field_70165_t + 1, (int)this.field_70163_u, (int)this.field_70161_v).func_149688_o() == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v);
            } else if (this.field_70170_p.func_147439_a((int)this.field_70165_t - 1, (int)this.field_70163_u, (int)this.field_70161_v).func_149688_o() == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v);
            } else if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v).func_149688_o() == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
            } else if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u - 1, (int)this.field_70161_v).func_149688_o() == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
            } else if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v + 1).func_149688_o() == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0);
            } else if (this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v - 1).func_149688_o() == Material.field_151579_a) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v - 1.0);
            }
        }
        return super.func_70094_T();
    }

    @Override
    protected void init(String name) {
        super.init(name);
        this.baseStats = Entity3HasStats.getBaseStats(name);
        if (this.baseStats == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return;
        }
        this.extraStats = this.getExtraStats(name);
        this.stats.IVs = IVStore.CreateNewIVs();
        this.func_70105_a(this.baseStats.width, this.baseStats.height + this.baseStats.hoverHeight);
        this.setType();
        this.length = this.baseStats.length;
        this.gender = this.baseStats.malePercent < 0 ? Gender.None : (this.field_70146_Z.nextInt(100) < this.baseStats.malePercent ? Gender.Male : Gender.Female);
        this.field_70178_ae = this.type.contains((Object)EnumType.Fire);
        if (!(this instanceof EntityStatue) && this.level.getLevel() == -1) {
            int spawnLevelRange = this.baseStats.spawnLevelRange;
            int spawnLevel = this.baseStats.spawnLevel;
            if (spawnLevelRange <= 0) {
                this.level.setLevel(spawnLevel);
            } else {
                this.level.setLevel(spawnLevel + this.field_70146_Z.nextInt(spawnLevelRange));
            }
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.stats.HP);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
            this.func_70606_j(this.stats.HP);
        }
        if (this.getAbility() == null) {
            this.giveAbility();
        }
    }

    private ExtraStats getExtraStats(String name) {
        return ExtraStats.getExtraStats(name);
    }

    float getMoveSpeed() {
        return 0.3f + (1.0f - (200.0f - (float)this.stats.Speed) / 200.0f) * 0.3f;
    }

    public static BaseStats getBaseStatsFromStore(String name) {
        for (int i = 0; i < baseStatsStore.length && baseStatsStore[i] != null; ++i) {
            if (!Entity3HasStats.baseStatsStore[i].pixelmonName.equals(name)) continue;
            return baseStatsStore[i];
        }
        return null;
    }

    public static BaseStats getBaseStats(int index) {
        for (BaseStats b : baseStatsStore) {
            if (b == null || b.nationalPokedexNumber != index) continue;
            return b;
        }
        return null;
    }

    public static BaseStats getBaseStatsFromDBID(int id) {
        for (BaseStats b : baseStatsStore) {
            if (b == null || b.id != id) continue;
            return b;
        }
        return null;
    }

    public static BaseStats getBaseStats(String name) {
        BaseStats baseStats = Entity3HasStats.getBaseStatsFromStore(name);
        if (baseStats != null) {
            return baseStats;
        }
        baseStats = DatabaseStats.GetBaseStats(name);
        for (int i = 0; i < baseStatsStore.length; ++i) {
            if (baseStatsStore[i] != null) continue;
            Entity3HasStats.baseStatsStore[i] = baseStats;
            break;
        }
        return baseStats;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        if (this.func_70902_q() != null) {
            this.friendship.onFaint();
            Pixelmon.EVENT_BUS.post((Event)new PixelmonFaintEvent((EntityPlayer)this.func_70902_q(), this));
        }
        super.func_70645_a(par1DamageSource);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this instanceof EntityStatue) {
            return false;
        }
        if (par1DamageSource.func_76364_f() == this.func_70902_q()) {
            this.friendship.hurtByOwner();
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    private void setType() {
        this.type.clear();
        this.type.add(this.baseStats.type1);
        if (this.baseStats.type2 != EnumType.Mystery) {
            this.type.add(this.baseStats.type2);
        }
    }

    @Override
    public void evolve(String evolveTo) {
        super.evolve(evolveTo);
        this.baseStats = Entity3HasStats.getBaseStats(evolveTo);
        this.setType();
        this.updateStats();
        try {
            Pokedex pokedex = this.getStorage().pokedex;
            pokedex.set(Pokedex.nameToID(this.getName()), Pokedex.DexRegisterStatus.caught);
            pokedex.sendToPlayer((EntityPlayerMP)pokedex.owner);
        }
        catch (PlayerNotLoadedException playerNotLoadedException) {
            // empty catch block
        }
        if (this.func_70902_q() != null) {
            this.update(EnumUpdateType.Name, EnumUpdateType.Stats);
        }
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void func_70106_y() {
        if (this.func_70902_q() != null && !this.field_70170_p.field_72995_K) {
            try {
                this.getStorage().retrieve((EntityPixelmon)this);
            }
            catch (PlayerNotLoadedException e) {
                e.printStackTrace();
            }
        }
        super.func_70106_y();
    }

    protected void func_70069_a(float f) {
        if (this.baseStats != null) {
            if (((EntityPixelmon)this).getSpawnLocation() == SpawnLocation.Water) {
                return;
            }
            if (this.baseStats.canFly) {
                return;
            }
        }
        super.func_70069_a(f);
    }

    public boolean func_70648_aU() {
        if (this.baseStats != null) {
            return ((EntityPixelmon)this).getSpawnLocation() == SpawnLocation.Water || this.baseStats.type1 == EnumType.Water || this.baseStats.type2 == EnumType.Water;
        }
        return true;
    }

    public void func_70606_j(float par1) {
        super.func_70606_j(par1);
        this.updateHealth();
    }

    public void healEntityBy(int i) {
        if (((Entity6CanBattle)this).battleController != null) {
            ((Entity6CanBattle)this).battleController.sendHealPacket((EntityPixelmon)this, i);
        }
        this.func_70606_j(this.func_110143_aJ() + (float)i);
    }

    public void updateHealth() {
        if (this.stats != null && this.func_110143_aJ() > this.func_110138_aP()) {
            super.func_70606_j(this.func_110138_aP());
        }
        if (this.func_110143_aJ() < 0.0f) {
            super.func_70606_j(0.0f);
        }
        if (this.func_70902_q() != null && !this.field_70170_p.field_72995_K) {
            this.update(EnumUpdateType.HP);
        }
    }

    public void setPixelmonScale(float scale) {
        this.field_70180_af.func_75692_b(19, (Object)((short)(scale * 1000.0f)));
    }

    public float getPixelmonScale() {
        return (float)this.field_70180_af.func_75693_b(19) / 1000.0f;
    }

    public void func_70107_b(double par1, double par3, double par5) {
        float scaleFactor;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        float scale = 1.0f;
        float f = scaleFactor = PixelmonConfig.scaleModelsUp ? 1.3f : 1.0f;
        if (this.isInitialised) {
            scale = this.getPixelmonScale() * scaleFactor * this.getScaleFactor();
        }
        if (this.baseStats != null) {
            float halfWidth = this.baseStats.width * scale / 2.0f;
            this.field_70121_D.func_72324_b(par1 - (double)halfWidth, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - (double)halfWidth, par1 + (double)halfWidth, par3 - (double)this.field_70129_M + (double)this.field_70139_V + (double)this.baseStats.height * (double)scale + (double)this.baseStats.hoverHeight, par5 + (double)halfWidth);
        } else {
            float halfWidth = this.field_70130_N * scale / 2.0f;
            this.field_70121_D.func_72324_b(par1 - (double)halfWidth, par3 - (double)this.field_70129_M + (double)this.field_70139_V, par5 - (double)halfWidth, par1 + (double)halfWidth, par3 - (double)this.field_70129_M + (double)this.field_70139_V + (double)this.field_70131_O * (double)scale, par5 + (double)halfWidth);
        }
    }

    public void updateStats() {
        this.stats.setLevelStats(this.getNature(), this.baseStats, this.level.getLevel());
        this.field_70180_af.func_75692_b(20, (Object)((short)this.stats.HP));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.stats.HP);
        this.updateHealth();
    }

    public Level getLvl() {
        return this.level;
    }

    @Override
    public void func_70071_h_() {
        if (!(this instanceof EntityStatue)) {
            if (this.func_70902_q() != null && !this.field_70170_p.field_72995_K) {
                this.friendship.tick();
            }
            if (this.hasOwner() && this.func_70902_q() == null && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.field_70759_as = this.field_70177_z;
        }
        super.func_70071_h_();
    }

    public boolean func_70039_c(NBTTagCompound par1nbtTagCompound) {
        if (this instanceof EntityStatue) {
            return super.func_70039_c(par1nbtTagCompound);
        }
        if (!(this.field_70128_L || ((EntityPixelmon)this).blockOwner != null || this.func_70692_ba() && !PixelmonConfig.writeEntitiesToWorld)) {
            return super.func_70039_c(par1nbtTagCompound);
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (!(this instanceof EntityStatue)) {
            this.stats.writeToNBT(nbt);
            this.level.writeToNBT(nbt);
            this.friendship.writeToNBT(nbt);
            nbt.func_74757_a("DoesLevel", this.doesLevel);
            if (this.extraStats != null) {
                this.extraStats.writeToNBT(nbt);
            }
            if (this.ability != null) {
                if (this.ability.getName().equals("Coming Soon")) {
                    nbt.func_74778_a("Ability", ((ComingSoon)this.ability).getTrueAbility());
                } else {
                    nbt.func_74778_a("Ability", this.ability.getName());
                }
            }
            if (this.abilitySlot != null) {
                nbt.func_74768_a("AbilitySlot", this.abilitySlot.intValue());
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (!(this instanceof EntityStatue)) {
            this.stats.readFromNBT(nbt);
            this.friendship.readFromNBT(nbt);
            this.doesLevel = nbt.func_74764_b("DoesLevel") ? nbt.func_74767_n("DoesLevel") : true;
            if (this.extraStats != null) {
                this.extraStats.readFromNBT(nbt);
            }
            try {
                if (nbt.func_74764_b("Ability")) {
                    String abilityName = nbt.func_74779_i("Ability");
                    try {
                        Class<?> abilityClass = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.abilities." + abilityName);
                        this.ability = (AbilityBase)abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        this.giveAbility();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Didn't have an ability, giving it one");
                this.giveAbility();
            }
            try {
                if (nbt.func_74764_b("AbilitySlot")) {
                    this.abilitySlot = nbt.func_74762_e("AbilitySlot");
                } else {
                    this.giveAbilitySlot();
                }
            }
            catch (Exception e) {
                System.out.println("Didn't have an ability slot, giving it one");
                this.giveAbilitySlot();
            }
        }
    }

    public int func_70641_bl() {
        return this.field_70146_Z.nextInt(this.baseStats.maxGroupSize - this.baseStats.minGroupSize + 1) + this.baseStats.minGroupSize;
    }

    private void giveAbility() {
        String abilityName = "";
        if (RandomHelper.getRandomNumberBetween(1, 150) != 1 && this.baseStats.abilities != null) {
            this.abilitySlot = this.baseStats.abilities[1] != null ? Integer.valueOf(RandomHelper.getRandomNumberBetween(0, 1)) : Integer.valueOf(0);
            abilityName = this.baseStats.abilities[this.abilitySlot];
            try {
                Class<?> abilityClass = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.abilities." + abilityName);
                this.ability = (AbilityBase)abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                this.ability = new ComingSoon(abilityName);
            }
            catch (Exception e) {
                System.out.println("Entity3Stats.giveAbility() is erroring and it is weird");
                e.printStackTrace();
            }
        } else {
            this.abilitySlot = 2;
            try {
                if (this.baseStats.abilities[this.abilitySlot] != null) {
                    abilityName = this.baseStats.abilities[this.abilitySlot];
                    Class<?> abilityClass = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.abilities." + abilityName);
                    this.ability = (AbilityBase)abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    this.ability = new ComingSoon(abilityName);
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.ability = new ComingSoon(abilityName);
            }
            catch (Exception e) {
                System.out.println("Entity3Stats.giveAbility() is erroring and it is weird");
                e.printStackTrace();
            }
        }
    }

    private void giveAbilitySlot() {
        Integer slot = DatabaseAbilities.getSlotForAbility(this.getName(), this.ability.getName());
        this.abilitySlot = slot == null ? Integer.valueOf(0) : slot;
    }

    public AbilityBase getAbility() {
        return this.ability;
    }

    public Integer getAbilitySlot() {
        return this.abilitySlot;
    }

    public void setAbility(AbilityBase newAbility) {
        this.ability = newAbility;
    }

    public void setAbility(String abilityName) {
        abilityName = abilityName.replace(" ", "");
        try {
            Class<?> abilityClass = Class.forName("com.pixelmonmod.pixelmon.entities.pixelmon.abilities." + abilityName);
            this.ability = (AbilityBase)abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            this.ability = new ComingSoon(abilityName);
        }
        catch (Exception e) {
            System.out.println("Entity3Stats.setAbility() is erroring and it is weird");
        }
    }

    public void setAbilitySlot(Integer slot) {
        this.abilitySlot = Math.max(0, Math.min(2, slot));
    }
}

