/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.controller.BattleController2Participant;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.IBattlingNPC;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Transformed;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.npcs.EntityTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity5Rideable;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilitiesUnfinished.Synchronize;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.BattleVariables;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BattleStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class Entity6CanBattle
extends Entity5Rideable {
    public BattleStats battleStats = new BattleStats(this);
    private ArrayList<StatusBase> status = new ArrayList();
    private Moveset moveset = new Moveset();
    public BattleControllerBase battleController;
    protected EntityTrainer trainer;
    public boolean isLockedInBattle = false;
    public Attack lastMoveUsed;
    public Attack disabledMove;
    public boolean mustUseLastMove = false;
    public BattleVariables battleVariables = new BattleVariables();

    public Entity6CanBattle(World par1World) {
        super(par1World);
        this.field_70180_af.func_75682_a(15, (Object)"");
    }

    public void loadMoveset() {
        this.moveset = DatabaseMoves.GetInitialMoves(this, this.getLvl().getLevel());
    }

    public void loadMoveset(String ... moves) {
        this.moveset = DatabaseMoves.GetInitialMoves(this, this.getLvl().getLevel());
        int j = 0;
        for (int i = 0; i < moves.length; ++i) {
            if (this.moveset.add(DatabaseMoves.getAttack(moves[i]))) continue;
            this.moveset.set(j, DatabaseMoves.getAttack(moves[i]));
            ++j;
        }
    }

    public void setMoveset(Moveset moveset) {
        this.moveset = moveset;
    }

    public Moveset getMoveset() {
        if (this.hasStatus(StatusType.Transformed)) {
            for (int i = 0; i < this.status.size(); ++i) {
                if (!(this.getStatus(i) instanceof Transformed)) continue;
                return ((Transformed)this.getStatus(i)).getMoveset();
            }
        }
        return this.moveset;
    }

    @Override
    public void setBoss(EnumBossMode mode) {
        super.setBoss(mode);
    }

    public void StartBattle(BattleParticipant p1, BattleParticipant p2) {
        if (this.moveset.size() == 0) {
            this.loadMoveset();
        }
        try {
            p1.startedBattle = true;
            this.battleController = new BattleController2Participant(p1, p2);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.battleController = null;
        }
    }

    public void EndBattle() {
        this.wipeLastMoveUsed();
        this.battleController = null;
        if (this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() != null) {
            ((ItemHeld)this.func_70694_bm().func_77973_b()).onBattleEnd();
        }
    }

    public void setTrainer(EntityTrainer trainer) {
        this.trainer = trainer;
        this.field_70180_af.func_75692_b(15, (Object)trainer.getName());
    }

    public IBattlingNPC getTrainer() {
        return this.trainer;
    }

    public String getTrainerName() {
        return this.field_70180_af.func_75681_e(15);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getBossMode() != EnumBossMode.NotBoss && par1DamageSource.field_76373_n.equals("mob") && !(par1DamageSource.func_76346_g() instanceof EntityPixelmon)) {
                return false;
            }
            if (par1DamageSource.field_76373_n.equals("player") || par1DamageSource == DamageSource.field_76367_g || par1DamageSource.field_76373_n.equals("arrow")) {
                return false;
            }
            if (this.battleController != null && (par1DamageSource == DamageSource.field_76367_g || par1DamageSource == DamageSource.field_76369_e || par1DamageSource == DamageSource.field_76379_h || par1DamageSource == DamageSource.field_76372_a || par1DamageSource == DamageSource.field_76368_d || par1DamageSource == DamageSource.field_76371_c || par1DamageSource == DamageSource.field_76370_b || par1DamageSource == DamageSource.field_82729_p || par1DamageSource == DamageSource.field_82728_o)) {
                return false;
            }
            boolean flag = super.func_70097_a(par1DamageSource, par2);
            this.updateHealth();
            if (this.battleController != null) {
                if (par1DamageSource instanceof BattleDamageSource) {
                    this.battleController.updatePokemonHealth((EntityPixelmon)this);
                    this.battleController.sendDamagePacket((EntityPixelmon)this, (BattleDamageSource)par1DamageSource, (int)par2);
                } else {
                    return false;
                }
            }
            if (this.func_110143_aJ() <= 0.0f) {
                this.func_70645_a(par1DamageSource);
            }
            Entity entity = par1DamageSource.func_76346_g();
            if (this.func_70902_q() != null) {
                this.update(EnumUpdateType.HP);
            }
            if (this.isValidTarget(entity)) {
                this.func_70624_b((EntityLivingBase)((EntityLiving)entity));
                this.func_70784_b(entity);
            }
            return flag;
        }
        return false;
    }

    public ArrayList<Attack> getAttacksAtLevel(int level) {
        return DatabaseMoves.getAttacksAtLevel(this.baseStats.id, level);
    }

    public boolean LearnsAttackAtLevel(int level) {
        return DatabaseMoves.LearnsAttackAtLevel(this.baseStats.id, level);
    }

    protected boolean isValidTarget(Entity entity) {
        return entity instanceof EntityPixelmon;
    }

    public boolean removeStatus(StatusType s) {
        for (int i = 0; i < this.status.size(); ++i) {
            StatusBase base = this.status.get(i);
            if (base.type != s) continue;
            base.applyAfterEffect((EntityPixelmon)this);
            this.status.remove(base);
            return true;
        }
        return false;
    }

    public void removeStatus(int i) {
        this.status.remove(i);
    }

    public boolean hasStatus(StatusType s) {
        try {
            for (int i = 0; i < this.status.size(); ++i) {
                StatusBase base = this.status.get(i);
                if (base.type != s) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPrimaryStatus() {
        return this.hasStatus(StatusType.Poison) || this.hasStatus(StatusType.Burn) || this.hasStatus(StatusType.PoisonBadly) || this.hasStatus(StatusType.Freeze) || this.hasStatus(StatusType.Sleep) || this.hasStatus(StatusType.Paralysis);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.moveset.writeToNBT(nbt);
        for (int i = 0; i < this.status.size(); ++i) {
            try {
                if (!(this.status.get(i) instanceof StatusPersist)) continue;
                ((StatusPersist)this.status.get(i)).writeToNBT(i, nbt);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        nbt.func_74777_a("StatusCount", (short)this.status.size());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.moveset.readFromNBT(nbt);
        int statusCount = 0;
        statusCount = nbt.func_74765_d("StatusCount");
        for (int i = 0; i < statusCount; ++i) {
            StatusPersist s = StatusType.getEffectInstance(nbt.func_74762_e("Status" + i));
            if (s == null) continue;
            this.status.add(s.restoreFromNBT(nbt));
        }
    }

    @Override
    public void func_70606_j(float par1) {
        super.func_70606_j(par1);
        if (this.battleController != null) {
            this.battleController.updatePokemonHealth((EntityPixelmon)this);
        }
    }

    public Attack getLastMoveUsed() {
        return this.lastMoveUsed;
    }

    public void wipeLastMoveUsed() {
        this.lastMoveUsed = null;
    }

    public BattleParticipant getParticipant() {
        if (this.battleController == null) {
            return null;
        }
        for (BattleParticipant p : this.battleController.participants) {
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (pw.pokemon != this) continue;
                return p;
            }
        }
        return null;
    }

    public int getStatusSize() {
        return this.status.size();
    }

    public StatusBase getStatus(int i) {
        return this.status.get(i);
    }

    public void clearStatus() {
        this.status.clear();
    }

    public void addStatus(StatusBase e, EntityPixelmon opponent) {
        if ((EntityPixelmon)this != opponent && this.getAbility() instanceof Synchronize) {
            if (e.type == StatusType.Burn) {
                if (!opponent.cannotHaveStatus(StatusType.Burn, opponent, (EntityPixelmon)this)) {
                    opponent.addStatus(new Burn(), opponent);
                    ChatHandler.sendBattleMessage((Entity)this.func_70902_q(), (Entity)opponent.func_70902_q(), "pixelmon.entities.syncpassed", opponent.getNickname());
                }
            } else if (e.type == StatusType.Paralysis) {
                if (!opponent.cannotHaveStatus(StatusType.Paralysis, opponent, (EntityPixelmon)this)) {
                    opponent.addStatus(new Paralysis(opponent), opponent);
                    ChatHandler.sendBattleMessage((Entity)this.func_70902_q(), (Entity)opponent.func_70902_q(), "pixelmon.entities.syncpassed", opponent.getNickname());
                }
            } else if (e.type == StatusType.Poison) {
                if (!opponent.cannotHaveStatus(StatusType.Poison, opponent, (EntityPixelmon)this)) {
                    opponent.addStatus(new Poison(), opponent);
                    ChatHandler.sendBattleMessage((Entity)this.func_70902_q(), (Entity)opponent.func_70902_q(), "pixelmon.entities.syncpassed", opponent.getNickname());
                }
            } else if (e.type == StatusType.PoisonBadly && !opponent.cannotHaveStatus(StatusType.PoisonBadly, opponent, (EntityPixelmon)this)) {
                opponent.addStatus(new PoisonBadly(), opponent);
                ChatHandler.sendBattleMessage((Entity)this.func_70902_q(), (Entity)opponent.func_70902_q(), "pixelmon.entities.syncpassed", opponent.getNickname());
            }
        }
        e.applyBeforeEffect((EntityPixelmon)this, opponent);
        if (this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() != null) {
            ((ItemHeld)this.func_70694_bm().func_77973_b()).onStatusAdded((EntityPixelmon)this, opponent, e);
        }
        this.status.add(e);
    }

    public void removeStatus(StatusBase e) {
        e.applyAfterEffect((EntityPixelmon)this);
        this.status.remove(e);
    }

    public boolean cannotHaveStatus(StatusType t, EntityPixelmon pokemon, EntityPixelmon opponent) {
        for (int i = 0; i < this.status.size(); ++i) {
            try {
                if (!this.status.get(i).stopsStatusChange()) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("Problem with cannotHaveStatus for StatusType." + t.name());
                e.printStackTrace();
            }
        }
        if (!pokemon.getAbility().allowsStatus(t, pokemon, opponent)) {
            return true;
        }
        if ((t == StatusType.Poison || t == StatusType.PoisonBadly) && (pokemon.type.contains((Object)EnumType.Poison) || pokemon.type.contains((Object)EnumType.Steel) || pokemon.hasPrimaryStatus())) {
            return true;
        }
        if (t == StatusType.Burn && (pokemon.type.contains((Object)EnumType.Fire) || pokemon.hasPrimaryStatus())) {
            return true;
        }
        if (t == StatusType.Freeze && (pokemon.type.contains((Object)EnumType.Ice) || pokemon.hasPrimaryStatus())) {
            return true;
        }
        return t == StatusType.Leech && pokemon.type.contains((Object)EnumType.Grass);
    }

    public ArrayList<EnumType> getEffectiveTypes(EntityPixelmon target) {
        ArrayList<EnumType> effectiveTypes = target.type;
        for (int i = 0; i < target.getStatusSize() && (effectiveTypes = target.getStatus(i).getEffectiveTypes(target)) == target.type; ++i) {
        }
        return effectiveTypes;
    }
}

