/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.BattleDamageSource;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Substitute;
import com.pixelmonmod.pixelmon.blocks.IPokemonOwner;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.AIHelper;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public abstract class Entity7HasAI
extends Entity6CanBattle {
    private int lastOwnerX;
    private int lastOwnerY;
    private int lastOwnerZ;
    private ChunkCoordinates idleSpot;
    public IPokemonOwner blockOwner = null;
    public Aggression aggression;
    public int aggressionTimer = 0;
    protected AIHelper aiHelper;
    public int moveIndex = -1;
    public int targetX;
    public int targetY;
    public int targetZ;
    public int targetSide;

    public AIHelper getAIHelper() {
        if (this.aiHelper == null) {
            this.aiHelper = new AIHelper(this.getName(), this, this.field_70714_bg);
        }
        return this.aiHelper;
    }

    public Entity7HasAI(World par1World) {
        super(par1World);
    }

    @Override
    protected void init(String name) {
        super.init(name);
        int r = this.field_70146_Z.nextInt(100) + 1;
        this.lastOwnerZ = 0;
        this.lastOwnerY = 0;
        this.lastOwnerX = 0;
        this.idleSpot = null;
        com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression a = this.baseStats.aggression;
        if (this.aggression == null) {
            if (a == null) {
                this.aggression = Aggression.passive;
                return;
            }
            this.aggression = r < a.timid ? Aggression.timid : (r < a.timid + a.passive ? Aggression.passive : (r < a.timid + a.passive + a.aggressive ? Aggression.aggressive : Aggression.passive));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.aggression == null) {
            this.aggression = Aggression.passive;
        }
        nbt.func_74768_a("Aggression", this.aggression.index);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.aggression = Aggression.getAggression(nbt.func_74762_e("Aggression"));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.aiHelper == null && this.baseStats != null) {
            this.resetAI();
        }
        if (this.aggressionTimer > 0 && this.battleController == null) {
            --this.aggressionTimer;
        }
    }

    public void resetAI() {
        this.aiHelper = new AIHelper(this.getName(), this, this.field_70714_bg);
    }

    @Override
    public void func_70612_e(float par1, float par2) {
        SpawnLocation location = ((EntityPixelmon)this).getSpawnLocation();
        double motionY = this.field_70181_x;
        super.func_70612_e(par1, par2);
        if (location == SpawnLocation.AirPersistent) {
            motionY = 0.0;
        }
        if (location == SpawnLocation.Air && this.isFlying) {
            this.field_70181_x = motionY - 0.01;
        }
    }

    public void setIdleSpot(ChunkCoordinates coords) {
        this.idleSpot = coords;
    }

    public ChunkCoordinates getIdleSpot() {
        return this.idleSpot;
    }

    public void updateOwnerCoords() {
        this.lastOwnerX = (int)(this.func_70902_q().field_70165_t + 0.5);
        this.lastOwnerY = (int)(this.func_70902_q().field_70163_u + 0.5);
        this.lastOwnerZ = (int)(this.func_70902_q().field_70161_v + 0.5);
    }

    public int getLastOwnerX() {
        return this.lastOwnerX;
    }

    public int getLastOwnerY() {
        return this.lastOwnerY;
    }

    public int getLastOwnerZ() {
        return this.lastOwnerZ;
    }

    public boolean getIsIdle() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setIsIdle(boolean par1) {
        this.setIdleSpot(null);
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFE)));
        }
    }

    @Override
    public void StartBattle(BattleParticipant p1, BattleParticipant p2) {
        super.StartBattle(p1, p2);
        if (this.aggression == Aggression.aggressive) {
            this.aggressionTimer = RandomHelper.getRandomNumberBetween(100, 400);
        }
    }

    public void doBattleDamage(PixelmonWrapper source, float damage) {
        int i;
        if (source.pokemon != (EntityPixelmon)this) {
            damage = source.pokemon.getAbility().modifyDamage((int)damage, source.pokemon, (EntityPixelmon)this, source.attack, false);
            damage = this.getAbility().modifyDamage((int)damage, source.pokemon, (EntityPixelmon)this, source.attack, true);
        }
        if (this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() instanceof ItemHeld) {
            damage = ((ItemHeld)this.func_70694_bm().func_77973_b()).modifyDamage((int)damage, source.pokemon, (EntityPixelmon)this, source.attack, true);
        }
        if (this.func_110143_aJ() == 0.0f) {
            if (source != null && this.battleController != null) {
                this.battleController.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            }
            return;
        }
        if (((EntityPixelmon)this).hasStatus(StatusType.Substitute) && source.pokemon != this) {
            for (i = 0; i < this.getStatusSize(); ++i) {
                if (!(this.getStatus(i) instanceof Substitute)) continue;
                ((Substitute)this.getStatus(i)).attackSubstitute(damage, (EntityPixelmon)this);
                return;
            }
        }
        if (source.pokemon.heldItem != null && source.pokemon.heldItem.func_77973_b() != null && source.pokemon.heldItem.func_77973_b() instanceof ItemHeld) {
            ((ItemHeld)source.pokemon.heldItem.func_77973_b()).dealtDamage(source.pokemon, this, damage);
        }
        for (i = 0; i < this.getStatusSize(); ++i) {
            this.getStatus(i).onDamageRecieved(source, (EntityPixelmon)this, source.attack, (int)damage);
        }
        this.func_70097_a(new BattleDamageSource("battle", source), damage);
    }

    public void func_70624_b(EntityLivingBase entity) {
        this.moveIndex = -1;
        super.func_70624_b(entity);
    }

    public void setAttackTarget(EntityLivingBase entity, int moveIndex) {
        this.func_70624_b(entity);
        this.moveIndex = moveIndex;
    }

    public void setBlockTarget(int x, int y, int z, int side, int moveIndex) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetSide = side;
        this.moveIndex = moveIndex;
    }

    public static enum Aggression {
        timid(0),
        passive(1),
        aggressive(2);

        public int index;

        private Aggression(int i) {
            this.index = i;
        }

        public static Aggression getAggression(int index) {
            for (Aggression a : Aggression.values()) {
                if (a.index != index) continue;
                return a;
            }
            return passive;
        }
    }
}

