/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.blocks.pixelmonSpawner.TileEntityPixelmonSpawner;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.SpawnLocation;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity10CanBreed;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity7HasAI;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.AIHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionType;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityPixelmon
extends Entity10CanBreed {
    public static final int dwName = 2;
    public static final int dwNickname = 3;
    public static final int dwPokemonID1 = 4;
    public static final int dwExp = 14;
    public static final int dwTrainerName = 15;
    public static final int dwRed = 18;
    public static final int dwScale = 19;
    public static final int dwMaxHP = 20;
    public static final int dwBossMode = 21;
    public static final int dwNature = 22;
    public static final int dwGrowth = 23;
    public static final int dwNumInteractions = 24;
    public static final int dwShiny = 25;
    public static final int dwSpecialTexture = 26;
    public static final int dwLevel = 27;
    public static final int dwPokemonID2 = 28;
    public static final int dwTransformation = 29;
    public static final int dwSpawnLocation = 30;
    public static final int dwNumBreedingLevels = 31;
    public boolean playerOwned = false;
    public int legendaryTicks = -1;
    public int despawnCounter = -1;
    public static int despawnRadius = 20;
    public static int TICKSPERSECOND = 20;
    public static int intMinTicksToDespawn = 30 * TICKSPERSECOND;
    public static int intMaxTicksToDespawn = 180 * TICKSPERSECOND;
    public static ArrayList<IInteraction> interactionList = new ArrayList();
    public int evolving = 0;
    public String evolvingInto;
    public int evolvingVal = 0;
    public boolean canMove = true;
    public float heightDiff;
    public float widthDiff;
    public float lengthDiff;
    public boolean stopRender = false;
    public TileEntityPixelmonSpawner spawner = null;

    public EntityPixelmon(World par1World) {
        super(par1World);
        this.field_70155_l = PixelmonConfig.renderDistanceWeight;
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.func_70661_as().func_75491_a(true);
    }

    @Override
    public void init(String name) {
        super.init(name);
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        if (!this.field_70170_p.field_72995_K) {
            super.func_70645_a(damagesource);
            if (this.func_70902_q() != null) {
                this.isFainted = true;
                this.func_70606_j(0.0f);
                this.catchInPokeball();
            } else {
                this.func_70106_y();
            }
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack;
        if (player instanceof EntityPlayerMP && (itemstack = player.func_71045_bC()) != null) {
            for (IInteraction i : interactionList) {
                if (!i.interact(this, player)) continue;
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    public void catchInPokeball() {
        this.isInBall = true;
        this.unloadEntity();
    }

    public void releaseFromPokeball() {
        if (this.hasOwner()) {
            this.aggression = Entity7HasAI.Aggression.passive;
        }
        this.field_70128_L = false;
        this.field_70170_p.func_72838_d((Entity)this);
        this.isInBall = false;
        this.field_70170_p.func_72956_a((Entity)this, this.func_70639_aQ(), this.func_70599_aP(), this.func_70647_i());
    }

    public void clearAttackTarget() {
        this.func_70784_b(null);
        this.func_70624_b(null);
    }

    public boolean func_70601_bi() {
        if (this.getSpawnLocation() == SpawnLocation.Water) {
            if (this.baseStats.swimmingParameters == null) {
                return false;
            }
            int wdepth = WorldHelper.getWaterDepth((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p);
            if (wdepth > this.baseStats.swimmingParameters.depthRangeStart && wdepth < this.baseStats.swimmingParameters.depthRangeEnd) {
                return true;
            }
            double y = this.field_70163_u - (double)(this.baseStats.swimmingParameters.depthRangeStart + this.field_70146_Z.nextInt(this.baseStats.swimmingParameters.depthRangeEnd - this.baseStats.swimmingParameters.depthRangeStart));
            wdepth = WorldHelper.getWaterDepth((int)this.field_70165_t, (int)y, (int)this.field_70161_v, this.field_70170_p);
            if (wdepth > this.baseStats.swimmingParameters.depthRangeStart && wdepth < this.baseStats.swimmingParameters.depthRangeEnd) {
                return false;
            }
            this.field_70163_u = y;
            return true;
        }
        return true;
    }

    public void func_110159_bB() {
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.legendaryTicks > 0) {
            return false;
        }
        return super.func_70692_ba();
    }

    public EntityLivingBase func_70902_q() {
        if (!this.hasOwner()) {
            return null;
        }
        return super.func_70902_q();
    }

    protected void func_70623_bb() {
        Event.Result result = null;
        if (this.func_104002_bU()) {
            this.field_70708_bq = 0;
        } else if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.func_70106_y();
            }
        } else {
            EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entityplayer != null) {
                double d0 = entityplayer.field_70165_t - this.field_70165_t;
                double d2 = entityplayer.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d2 * d2;
                if (this.func_70692_ba() && d3 > 16384.0) {
                    this.func_70106_y();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d3 > 1024.0 && this.func_70692_ba()) {
                    this.func_70106_y();
                } else if (d3 < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.checkGeneration();
        }
        if (Pixelmon.freeze) {
            return;
        }
        if (this.field_70165_t > 1.0E20 || this.field_70165_t < -1.0E20 || this.field_70161_v > 1.0E20 || this.field_70161_v < -1.0E20) {
            this.unloadEntity();
        }
        if (this.field_70163_u < 0.0 && !this.field_70170_p.field_72995_K) {
            if (this.battleController != null) {
                this.battleController = null;
            }
            this.func_70106_y();
        }
        if (this.canDespawn && !this.field_70170_p.field_72995_K) {
            this.checkForRarityDespawn();
            if (this.legendaryTicks >= 0 && this.battleController == null) {
                --this.legendaryTicks;
                if (this.legendaryTicks == 0) {
                    this.func_70106_y();
                }
            }
        }
        if (this.playerOwned && this.func_70902_q() == null) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    private void checkForRarityDespawn() {
        if (this.legendaryTicks > 0 || this.battleController != null || this.func_70902_q() != null || this.baseStats == null || this.blockOwner != null) {
            return;
        }
        if (this.despawnCounter > 0) {
            --this.despawnCounter;
        } else if (this.despawnCounter == 0) {
            if (!this.playersNearby()) {
                this.func_70106_y();
            }
        } else {
            this.despawnCounter = (int)(Math.random() * (double)(intMaxTicksToDespawn - intMinTicksToDespawn) + (double)intMinTicksToDespawn);
        }
    }

    private boolean playersNearby() {
        boolean playerNearby = false;
        for (int i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
            double distancex = player.field_70165_t - this.field_70165_t;
            double distancey = player.field_70163_u - this.field_70163_u;
            double distancez = player.field_70161_v - this.field_70161_v;
            double distancesquared = distancex * distancex + distancey * distancey + distancez * distancez;
            if (!(distancesquared < (double)(despawnRadius * despawnRadius))) continue;
            playerNearby = true;
            break;
        }
        return playerNearby;
    }

    private void checkGeneration() {
        String name = this.getName();
        int ID = EntityPixelmon.getBaseStats((String)name).nationalPokedexNumber;
        if (ID < 151) {
            if (!PixelmonConfig.Gen1) {
                this.func_70106_y();
            }
        } else if (ID > 151 && ID <= 251) {
            if (!PixelmonConfig.Gen2) {
                this.func_70106_y();
            }
        } else if (ID > 251 && ID <= 386) {
            if (!PixelmonConfig.Gen3) {
                this.func_70106_y();
            }
        } else if (ID > 386 && ID <= 493) {
            if (!PixelmonConfig.Gen4) {
                this.func_70106_y();
            }
        } else if (ID > 493 && ID <= 649 && !PixelmonConfig.Gen5) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.func_70902_q() != null) {
            nbt.func_74778_a("pixelmonOwner", this.func_152113_b());
        }
        if (this.getSpawnLocation() == null) {
            this.setSpawnLocation(SpawnLocation.Land);
        }
        nbt.func_74768_a("pixelmonType", this.getSpawnLocation().ordinal());
        if (this.legendaryTicks > 0) {
            nbt.func_74768_a("legendaryTicks", this.legendaryTicks);
            nbt.func_74772_a("legendaryTime", this.field_70170_p.func_82737_E());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        try {
            super.func_70037_a(nbt);
            if (nbt.func_74764_b("pixelmonOwner")) {
                this.func_152115_b(nbt.func_74779_i("pixelmonOwner"));
            }
            float h = this.func_110143_aJ();
            this.level.readFromNBT(nbt);
            this.func_70606_j(h);
            if (nbt.func_74764_b("pixelmonType")) {
                this.setSpawnLocation(SpawnLocation.getFromIndex(nbt.func_74762_e("pixelmonType")));
            } else if (this.baseStats.spawnLocations[0] == SpawnLocation.Land) {
                this.setSpawnLocation(SpawnLocation.Land);
            } else {
                this.setSpawnLocation(SpawnLocation.Water);
            }
            this.aiHelper = new AIHelper(this.getName(), this, this.field_70714_bg);
            if (nbt.func_74764_b("legendaryTicks")) {
                this.legendaryTicks = nbt.func_74762_e("legendaryTicks");
                long lastTime = nbt.func_74763_f("legendaryTime");
                this.legendaryTicks = (int)((long)this.legendaryTicks - (this.field_70170_p.func_82737_E() - lastTime));
                if (this.legendaryTicks <= 0) {
                    this.func_70106_y();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unloadEntity() {
        super.unloadEntity();
        this.field_70170_p.func_72900_e((Entity)this);
        this.clearAttackTarget();
        if (this.battleController != null) {
            this.battleController = null;
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    public EnumPokemon[] getPreEvolutions() {
        return this.baseStats.preEvolutions;
    }

    public boolean func_110164_bC() {
        return false;
    }

    public void startEvolution(String evolutionName, boolean fromLevelUp) {
        new EvolutionQuery(this, evolutionName, fromLevelUp);
    }

    public boolean isLoaded() {
        List entityList = this.field_70170_p.field_72996_f;
        for (Object entity : entityList) {
            if (!(entity instanceof EntityPixelmon) || !PixelmonMethods.isIDSame((EntityPixelmon)((Object)entity), this.getPokemonId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkEvolution(EvolutionType ... typeList) {
        for (Evolution e : this.baseStats.evolutions) {
            for (EvolutionType type : typeList) {
                if (!e.handleEvolution(this, type)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSpawnerParent(TileEntityPixelmonSpawner spawner) {
        this.spawner = spawner;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        if (!this.field_70122_E && this.field_70163_u > 64.0) {
            double d3 = this.field_70165_t - p_145770_1_;
            double d5 = this.field_70161_v - p_145770_5_;
            double d6 = d3 * d3 + d5 * d5;
            return this.func_70112_a(d6);
        }
        double d3 = this.field_70165_t - p_145770_1_;
        double d4 = this.field_70163_u - p_145770_3_;
        double d5 = this.field_70161_v - p_145770_5_;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.func_70112_a(d6);
    }
}

