/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import net.minecraft.util.MovingObjectPosition;

public abstract class ExternalMoveBase {
    protected boolean targetted = true;
    protected AttackBase[] attacks;

    public ExternalMoveBase(String ... attacks) {
        this.attacks = this.getAttacks(attacks);
    }

    private AttackBase[] getAttacks(String[] nameList) {
        AttackBase[] attacks = new AttackBase[nameList.length];
        int entry = 0;
        for (int i = 0; i < nameList.length; ++i) {
            String name = nameList[i];
            int index = DatabaseMoves.getAttackIndex(name);
            if (index == -1) continue;
            attacks[entry++] = this.getAttackBaseFromIndex(index);
        }
        return attacks;
    }

    private AttackBase getAttackBaseFromIndex(int attackIndex) {
        if (Attack.fullAttackList[attackIndex] == null) {
            AttackBase a;
            Attack.fullAttackList[attackIndex] = a = DatabaseMoves.getAttackBase(attackIndex);
            return a;
        }
        return Attack.fullAttackList[attackIndex];
    }

    public boolean isTargetted() {
        return this.targetted;
    }

    public boolean matches(Attack a) {
        for (AttackBase base : this.attacks) {
            if (a.baseAttack != base) continue;
            return true;
        }
        return false;
    }

    public boolean matches(int attackIndex) {
        for (AttackBase base : this.attacks) {
            if (attackIndex != base.attackIndex) continue;
            return true;
        }
        return false;
    }

    public abstract void execute(EntityPixelmon var1, MovingObjectPosition var2, int var3);
}

